/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.aspect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.text.TextFormatting;
import thaumcraft.api.aspects.Aspect;

public final class AspectUtil {
    private static final HashMap<TextFormatting, Integer> CHAT_COLORS = new HashMap();
    private static ArrayList<String> ASPECT_KEYS;

    private AspectUtil() {
    }

    public static String getChatColorForAspect(Aspect aspect) {
        return AspectUtil.getChatColorForAspect(aspect, Collections.emptySet());
    }

    public static String getChatColorForAspect(Aspect aspect, Set<TextFormatting> forbiddenColors) {
        if (aspect.getChatcolor() != null) {
            return '\u00a7' + aspect.getChatcolor();
        }
        int smallestDistance = Integer.MAX_VALUE;
        String color = "";
        int aspectColor = aspect.getColor();
        int r = aspectColor >> 16 & 0xFF;
        int g = aspectColor >> 8 & 0xFF;
        int b = aspectColor & 0xFF;
        for (Map.Entry<TextFormatting, Integer> entry : CHAT_COLORS.entrySet()) {
            if (forbiddenColors.contains(entry.getKey())) continue;
            int number = entry.getValue();
            int red = number >> 16 & 0xFF;
            int green = number >> 8 & 0xFF;
            int blue = number & 0xFF;
            int distance = (int)(Math.pow(red - r, 2.0) + Math.pow(green - g, 2.0) + Math.pow(blue - b, 2.0));
            if (distance >= smallestDistance) continue;
            smallestDistance = distance;
            color = entry.getKey().toString();
        }
        return color;
    }

    public static Aspect getRandomAspect(Random rand) {
        if (ASPECT_KEYS == null) {
            ASPECT_KEYS = new ArrayList(Aspect.aspects.keySet());
        }
        if (!ASPECT_KEYS.isEmpty()) {
            return Aspect.getAspect((String)ASPECT_KEYS.get(rand.nextInt(ASPECT_KEYS.size())));
        }
        return Aspect.ORDER;
    }

    static {
        CHAT_COLORS.put(TextFormatting.BLACK, 0);
        CHAT_COLORS.put(TextFormatting.DARK_BLUE, 170);
        CHAT_COLORS.put(TextFormatting.DARK_GREEN, 43520);
        CHAT_COLORS.put(TextFormatting.DARK_AQUA, 43690);
        CHAT_COLORS.put(TextFormatting.DARK_RED, 0xAA0000);
        CHAT_COLORS.put(TextFormatting.DARK_PURPLE, 0xAA00AA);
        CHAT_COLORS.put(TextFormatting.GOLD, 0xFFAA00);
        CHAT_COLORS.put(TextFormatting.GRAY, 0xAAAAAA);
        CHAT_COLORS.put(TextFormatting.DARK_GRAY, 0x555555);
        CHAT_COLORS.put(TextFormatting.BLUE, 0x5555FF);
        CHAT_COLORS.put(TextFormatting.GREEN, 0x55FF55);
        CHAT_COLORS.put(TextFormatting.AQUA, 0x55FFFF);
        CHAT_COLORS.put(TextFormatting.RED, 0xFF5555);
        CHAT_COLORS.put(TextFormatting.LIGHT_PURPLE, 0xFF55FF);
        CHAT_COLORS.put(TextFormatting.YELLOW, 0xFFFF55);
        CHAT_COLORS.put(TextFormatting.WHITE, 0xFFFFFF);
    }
}

