/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;
import thecodex6824.thaumicaugmentation.common.network.PacketAugmentableItemSync;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public final class AugmentEventHelper {
    private AugmentEventHelper() {
    }

    public static void fireEquipEvent(IAugmentableItem cap, Entity entity) {
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            aug.onEquip(entity);
        }
    }

    public static void fireUnequipEvent(IAugmentableItem cap, Entity entity) {
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            aug.onUnequip(entity);
        }
    }

    public static boolean fireCastPreEvent(IAugmentableItem cap, ItemStack caster, FocusWrapper focusPackage, Entity entity) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onCastPre(caster, focusPackage, entity);
        }
        return res;
    }

    public static void fireCastPostEvent(IAugmentableItem cap, ItemStack caster, FocusWrapper focusPackage, Entity entity) {
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            aug.onCastPost(caster, focusPackage, entity);
        }
    }

    public static boolean fireHurtEntityEvent(IAugmentableItem cap, Entity attacker, Entity attacked) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onHurtEntity(attacker, attacked);
        }
        return res;
    }

    public static boolean fireHurtByEntityEvent(IAugmentableItem cap, Entity attacked, Entity attacker) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onHurt(attacked, attacker);
        }
        return res;
    }

    public static boolean fireDamageEntityEvent(IAugmentableItem cap, Entity attacker, Entity attacked) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onDamagedEntity(attacker, attacked);
        }
        return res;
    }

    public static boolean fireDamagedByEntityEvent(IAugmentableItem cap, Entity attacked, Entity attacker) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onDamaged(attacked, attacker);
        }
        return res;
    }

    public static boolean fireInteractEntityEvent(IAugmentableItem cap, Entity user, ItemStack used, Entity target, EnumHand hand) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onInteractEntity(user, used, target, hand);
        }
        return res;
    }

    public static boolean fireInteractBlockEvent(IAugmentableItem cap, Entity user, ItemStack used, BlockPos target, EnumFacing face, EnumHand hand) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onInteractBlock(user, used, target, face, hand);
        }
        return res;
    }

    public static boolean fireInteractAirEvent(IAugmentableItem cap, Entity user, ItemStack used, EnumHand hand) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onInteractAir(user, used, hand);
        }
        return res;
    }

    public static boolean fireUseItemEvent(IAugmentableItem cap, Entity user, ItemStack used) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onUseItem(user, used);
        }
        return res;
    }

    public static boolean fireTickEvent(IAugmentableItem cap, Entity entity) {
        boolean res = false;
        for (ItemStack a : cap.getAllAugments()) {
            IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug == null) continue;
            res |= aug.onTick(entity);
        }
        return res;
    }

    public static void handleSync(IAugmentableItem cap, Entity entity, int index) {
        if (!entity.func_130014_f_().field_72995_K) {
            boolean sync = false;
            for (ItemStack a : cap.getAllAugments()) {
                IAugment aug = (IAugment)a.getCapability(CapabilityAugment.AUGMENT, null);
                if (aug == null || !aug.shouldSync()) continue;
                sync = true;
                break;
            }
            if (sync) {
                PacketAugmentableItemSync syncPacket = new PacketAugmentableItemSync(entity.func_145782_y(), index, cap.getSyncNBT());
                if (entity instanceof EntityPlayerMP) {
                    TANetwork.INSTANCE.sendTo((IMessage)syncPacket, (EntityPlayerMP)entity);
                }
                TANetwork.INSTANCE.sendToAllTracking((IMessage)syncPacket, entity);
            }
        }
    }
}

