/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusGraph;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusProvider;
import thecodex6824.thaumicaugmentation.api.internal.TAInternals;
import thecodex6824.thaumicaugmentation.api.item.CapabilityImpetusLinker;
import thecodex6824.thaumicaugmentation.api.item.IImpetusLinker;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.api.util.RaytraceHelper;

public final class NodeHelper {
    private NodeHelper() {
    }

    public static boolean handleLinkInteract(TileEntity provider, World world, ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing face, EnumHand hand) {
        IImpetusLinker linker = (IImpetusLinker)stack.getCapability(CapabilityImpetusLinker.IMPETUS_LINKER, null);
        if (!world.field_72995_K && linker != null) {
            DimensionalBlockPos origin = linker.getOrigin();
            if (player.func_70093_af()) {
                if (!origin.isInvalid() && origin.getPos().func_177958_n() == pos.func_177958_n() && origin.getPos().func_177956_o() == pos.func_177956_o() && origin.getPos().func_177952_p() == pos.func_177952_p() && origin.getDimension() == world.field_73011_w.getDimension()) {
                    linker.setOrigin(DimensionalBlockPos.INVALID);
                    return true;
                }
                linker.setOrigin(new DimensionalBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension()));
                return true;
            }
            if (!origin.isInvalid()) {
                IImpetusNode node = (IImpetusNode)provider.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null);
                if (!origin.equals(node.getLocation()) && world.func_175667_e(origin.getPos())) {
                    IImpetusNode otherNode;
                    TileEntity te = world.func_175726_f(origin.getPos()).func_177424_a(origin.getPos(), Chunk.EnumCreateEntityType.CHECK);
                    if (te != null && (otherNode = (IImpetusNode)te.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
                        if (node.getInputLocations().contains(origin)) {
                            if (node.canRemoveNodeAsInput(otherNode) && otherNode.canRemoveNodeAsOutput(node)) {
                                node.removeInput(otherNode);
                                provider.func_70296_d();
                                te.func_70296_d();
                                NodeHelper.syncRemovedImpetusNodeInput(node, origin);
                            }
                        } else if (otherNode.getNumOutputs() >= otherNode.getMaxOutputs()) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.impetus_link_limit_out", new Object[0]), true);
                        } else if (node.getNumInputs() >= node.getMaxInputs()) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.impetus_link_limit_in", new Object[0]), true);
                        } else if (node.canConnectNodeAsInput(otherNode) && otherNode.canConnectNodeAsOutput(node)) {
                            double otherNodeMax;
                            double nodeMax;
                            double dist = node.getLocation().getPos().func_177951_i((Vec3i)otherNode.getLocation().getPos());
                            if (dist > Math.min((nodeMax = node.getMaxConnectDistance(otherNode)) * nodeMax, (otherNodeMax = otherNode.getMaxConnectDistance(node)) * otherNodeMax)) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.impetus_link_too_far", new Object[0]), true);
                            } else if (!NodeHelper.nodesPassDefaultCollisionCheck(world, node, otherNode)) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.impetus_link_blocked", new Object[0]), true);
                            } else {
                                node.addInput(otherNode);
                                provider.func_70296_d();
                                te.func_70296_d();
                                NodeHelper.syncAddedImpetusNodeInput(node, origin);
                            }
                        }
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.impetus_link_same_pos", new Object[0]), true);
                }
                return true;
            }
        } else if (world.field_72995_K) {
            return true;
        }
        return false;
    }

    public static ConsumeResult consumeImpetusFromConnectedProviders(long amount, IImpetusConsumer dest, boolean simulate) {
        if (amount <= 0L) {
            return new ConsumeResult(0L, Collections.emptyMap());
        }
        ArrayList<IImpetusProvider> providers = new ArrayList<IImpetusProvider>(((IImpetusGraph)dest.getGraph()).findDirectProviders(dest));
        if (!providers.isEmpty()) {
            providers.sort((p1, p2) -> Long.compare(p2.provide(Long.MAX_VALUE, true), p1.provide(Long.MAX_VALUE, true)));
            if (amount < (long)providers.size()) {
                int remove = providers.size() - (int)amount;
                for (int i = 0; i < remove; ++i) {
                    providers.remove(providers.size() - 1 - i);
                }
            }
            ArrayList<Deque<IImpetusConsumer>> paths = new ArrayList<Deque<IImpetusConsumer>>(providers.size());
            HashSet<IImpetusProvider> removedProviders = new HashSet<IImpetusProvider>();
            for (IImpetusProvider p : providers) {
                Deque<IImpetusConsumer> path = ((IImpetusGraph)dest.getGraph()).findPath(p, dest);
                if (path != null) {
                    paths.add(path);
                    continue;
                }
                NodeHelper.validateFullGraph((IImpetusGraph)p.getGraph());
                removedProviders.add(p);
            }
            providers.removeAll(removedProviders);
            if (providers.size() > 0) {
                long drawn = 0L;
                long step = amount / (long)providers.size();
                long remain = amount % (long)providers.size();
                HashMap<Deque<IImpetusNode>, Long> usedPaths = new HashMap<Deque<IImpetusNode>, Long>();
                for (int i = 0; i < providers.size(); ++i) {
                    IImpetusProvider p = providers.get(i);
                    long actuallyDrawn = p.provide(Math.min(step + (long)(remain > 0L ? 1 : 0), amount - drawn), true);
                    if (actuallyDrawn > 0L) {
                        IImpetusNode n;
                        Deque nodes = (Deque)paths.get(i);
                        Iterator iterator = nodes.iterator();
                        while (iterator.hasNext() && (actuallyDrawn = (n = (IImpetusNode)iterator.next()).onTransaction(nodes, actuallyDrawn, simulate)) > 0L) {
                        }
                        if (actuallyDrawn > 0L) {
                            actuallyDrawn = p.provide(actuallyDrawn, simulate);
                            usedPaths.put(nodes, actuallyDrawn);
                            drawn += actuallyDrawn;
                            if (actuallyDrawn < step && i < providers.size() - 1) {
                                step = (amount - drawn) / (long)(providers.size() - (i + 1));
                                remain = (amount - drawn) % (long)(providers.size() - (i + 1));
                                continue;
                            }
                            --remain;
                            continue;
                        }
                        if (i >= providers.size() - 1) continue;
                        step = (amount - drawn) / (long)(providers.size() - (i + 1));
                        remain = (amount - drawn) % (long)(providers.size() - (i + 1));
                        continue;
                    }
                    if (i >= providers.size() - 1) continue;
                    step = (amount - drawn) / (long)(providers.size() - (i + 1));
                    remain = (amount - drawn) % (long)(providers.size() - (i + 1));
                }
                return new ConsumeResult(drawn, usedPaths);
            }
        }
        return new ConsumeResult(0L, Collections.emptyMap());
    }

    public static boolean nodesPassDefaultCollisionCheck(World sharedWorld, IImpetusNode node1, IImpetusNode node2) {
        RayTraceResult r;
        Vec3d start = node1.getBeamEndpoint();
        Vec3d target = node2.getBeamEndpoint();
        boolean clear = true;
        while (!start.equals((Object)target) && (r = sharedWorld.func_147447_a(start, target, false, true, false)) != null && !node2.getLocation().getPos().equals((Object)r.func_178782_a())) {
            if (r.func_178782_a() == null || r.field_72307_f == null) continue;
            IBlockState state = sharedWorld.func_180495_p(r.func_178782_a());
            if (state.func_185914_p() || state.getLightOpacity((IBlockAccess)sharedWorld, r.func_178782_a()) > 0) {
                clear = false;
                break;
            }
            double dX = Math.max(-1.0, Math.min(1.0, target.field_72450_a - r.field_72307_f.field_72450_a));
            double dY = Math.max(-1.0, Math.min(1.0, target.field_72448_b - r.field_72307_f.field_72448_b));
            double dZ = Math.max(-1.0, Math.min(1.0, target.field_72449_c - r.field_72307_f.field_72449_c));
            start = start.func_72441_c(dX, dY, dZ);
        }
        return clear;
    }

    public static void validateFullGraph(IImpetusGraph graph) {
        HashSet<IImpetusNode> toRemove = new HashSet<IImpetusNode>();
        for (IImpetusNode node : graph.getNodes()) {
            for (IImpetusNode input : node.getInputs()) {
                if (input.hasOutput(node)) continue;
                toRemove.add(input);
            }
            for (IImpetusNode n : toRemove) {
                node.removeInput(n);
            }
            toRemove.clear();
            for (IImpetusNode output : node.getOutputs()) {
                if (output.hasInput(node)) continue;
                toRemove.add(output);
            }
            for (IImpetusNode n : toRemove) {
                node.removeOutput(n);
            }
            toRemove.clear();
        }
    }

    public static void validateOutputs(World sharedWorld, IImpetusNode node) {
        HashSet<IImpetusNode> changed = new HashSet<IImpetusNode>();
        for (IImpetusNode output : node.getOutputs()) {
            if (sharedWorld.field_73011_w.getDimension() != node.getLocation().getDimension() || sharedWorld.field_73011_w.getDimension() != output.getLocation().getDimension()) continue;
            boolean enforce1 = node.shouldEnforceBeamLimitsWith(output);
            boolean enforce2 = output.shouldEnforceBeamLimitsWith(node);
            if (!enforce1 && !enforce2) continue;
            double dist = node.getLocation().getPos().func_177951_i((Vec3i)output.getLocation().getPos());
            if (!(enforce1 && dist > node.getMaxConnectDistance(output) * node.getMaxConnectDistance(output) || enforce2 && dist > output.getMaxConnectDistance(node) * output.getMaxConnectDistance(node)) && NodeHelper.nodesPassDefaultCollisionCheck(sharedWorld, node, output)) continue;
            node.removeOutput(output);
            changed.add(node);
            changed.add(output);
            NodeHelper.syncRemovedImpetusNodeOutput(node, output.getLocation());
            NodeHelper.syncRemovedImpetusNodeInput(output, node.getLocation());
        }
        for (IImpetusNode n : changed) {
            TileEntity tile;
            if (n.getLocation().getDimension() != sharedWorld.field_73011_w.getDimension() || (tile = sharedWorld.func_175625_s(n.getLocation().getPos())) == null) continue;
            tile.func_70296_d();
        }
    }

    public static void damageEntitiesFromTransaction(Deque<IImpetusNode> path, long energy) {
        NodeHelper.damageEntitiesFromTransaction(path, (node, entity) -> ImpetusAPI.causeImpetusDamage(node.getLocation().getDimension() == entity.field_71093_bK ? new Vec3d((Vec3i)node.getLocation().getPos()) : null, entity, Math.max((float)energy / 10.0f, 1.0f)));
    }

    public static void damageEntitiesFromTransaction(Deque<IImpetusNode> path, BiConsumer<IImpetusNode, Entity> damageFunc) {
        if (path.size() >= 2) {
            Iterator<IImpetusNode> iterator = path.iterator();
            IImpetusNode first = iterator.next();
            while (iterator.hasNext()) {
                WorldServer world;
                IImpetusNode second = iterator.next();
                if (first.getLocation().getDimension() == second.getLocation().getDimension() && first.shouldPhysicalBeamLinkTo(second) && second.shouldPhysicalBeamLinkTo(first) && (world = DimensionManager.getWorld((int)first.getLocation().getDimension())) != null) {
                    for (Entity e : RaytraceHelper.raytraceEntities((World)world, first.getBeamEndpoint(), second.getBeamEndpoint())) {
                        damageFunc.accept(first, e);
                    }
                }
                first = second;
            }
        }
    }

    public static void syncImpetusTransaction(Deque<IImpetusNode> path) {
        TAInternals.syncImpetusTransaction(path);
    }

    public static void syncAllImpetusTransactions(Collection<Deque<IImpetusNode>> paths) {
        for (Deque<IImpetusNode> path : paths) {
            TAInternals.syncImpetusTransaction(path);
        }
    }

    public static void syncImpetusNodeFully(IImpetusNode node) {
        TAInternals.fullySyncImpetusNode(node);
    }

    public static void syncAddedImpetusNodeInput(IImpetusNode node, DimensionalBlockPos input) {
        TAInternals.updateImpetusNode(node, input, false, false);
    }

    public static void syncAddedImpetusNodeOutput(IImpetusNode node, DimensionalBlockPos output) {
        TAInternals.updateImpetusNode(node, output, true, false);
    }

    public static void syncRemovedImpetusNodeInput(IImpetusNode node, DimensionalBlockPos input) {
        TAInternals.updateImpetusNode(node, input, false, true);
    }

    public static void syncRemovedImpetusNodeOutput(IImpetusNode node, DimensionalBlockPos output) {
        TAInternals.updateImpetusNode(node, output, true, true);
    }

    public static void syncDestroyedImpetusNode(IImpetusNode node) {
        for (IImpetusNode n : node.getInputs()) {
            NodeHelper.syncRemovedImpetusNodeOutput(n, node.getLocation());
        }
        for (IImpetusNode n : node.getOutputs()) {
            NodeHelper.syncRemovedImpetusNodeInput(n, node.getLocation());
        }
    }
}

