/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer;

import com.sasmaster.glelwjgl.java.CoreGLE;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXFireMote;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.utils.EntityUtils;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;
import thecodex6824.thaumicaugmentation.client.fx.FXArcCustom;
import thecodex6824.thaumicaugmentation.client.fx.FXGenericP2ECustomSpeed;
import thecodex6824.thaumicaugmentation.client.shader.TAShaderManager;
import thecodex6824.thaumicaugmentation.client.shader.TAShaders;
import thecodex6824.thaumicaugmentation.common.block.trait.IRenderableSides;
import thecodex6824.thaumicaugmentation.common.tile.TileObelisk;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftBarrier;
import thecodex6824.thaumicaugmentation.common.tile.TileStarfieldGlass;
import thecodex6824.thaumicaugmentation.common.util.ITARenderHelper;
import thecodex6824.thaumicaugmentation.common.util.ShaderType;

public class TARenderHelperClient
implements ITARenderHelper {
    protected static final ResourceLocation RIFT_TEXTURE = new ResourceLocation("minecraft", "textures/entity/end_portal.png");
    protected static final ResourceLocation BLANK = new ResourceLocation("thaumicaugmentation", "textures/misc/white.png");
    protected static final CoreGLE GLE = new CoreGLE();
    protected static double[][] POINT_BUFFER = new double[0][0];
    protected static float[][] COLOR_BUFFER = new float[0][0];
    protected static double[] RADIUS_BUFFER = new double[0];
    protected static final FloatBuffer BUFFER_X = (FloatBuffer)GLAllocation.func_74529_h((int)16).put(1.0f).put(0.0f).put(0.0f).put(0.0f).flip();
    protected static final FloatBuffer BUFFER_Y = (FloatBuffer)GLAllocation.func_74529_h((int)16).put(0.0f).put(1.0f).put(0.0f).put(0.0f).flip();
    protected static final FloatBuffer BUFFER_Z = (FloatBuffer)GLAllocation.func_74529_h((int)16).put(0.0f).put(0.0f).put(1.0f).put(0.0f).flip();
    protected static final FloatBuffer BUFFER_W = (FloatBuffer)GLAllocation.func_74529_h((int)16).put(0.0f).put(0.0f).put(0.0f).put(1.0f).flip();
    protected static final double Z_CLOSE_NEG = Math.pow(2.0, -12.0);
    protected static final double Z_CLOSE_POS = 1.0 - Z_CLOSE_NEG;
    protected static final ResourceLocation FRACTURE_TEXTURE_CLOSED = new ResourceLocation("thaumicaugmentation", "textures/environment/emptiness_sky.png");
    protected static final ResourceLocation FRACTURE_TEXTURE_OPEN = new ResourceLocation("thaumicaugmentation", "textures/environment/emptiness_sky.png");
    protected static final Vec3d[] FRACTURE_POINTS_CLOSED = new Vec3d[]{new Vec3d(0.91, 1.99, 0.41), new Vec3d(0.85, 1.97, 0.39), new Vec3d(0.6, 1.77, 0.45), new Vec3d(0.48, 1.35, 0.53), new Vec3d(0.29, 1.1, 0.66), new Vec3d(0.15, 0.8, 0.78), new Vec3d(0.25, 0.45, 0.62), new Vec3d(0.45, 0.1, 0.52), new Vec3d(0.65, -0.25, 0.38), new Vec3d(0.6, -0.55, 0.25), new Vec3d(0.5, -0.85, 0.2), new Vec3d(0.55, -0.9, 0.23)};
    protected static final Vec3d[] FRACTURE_POINTS_OPEN = new Vec3d[]{new Vec3d(0.8, 1.99, 0.65), new Vec3d(0.75, 1.97, 0.49), new Vec3d(0.6, 1.77, 0.5), new Vec3d(0.54, 1.35, 0.55), new Vec3d(0.56, 1.1, 0.6), new Vec3d(0.5, 0.8, 0.5), new Vec3d(0.5, 0.15, 0.5), new Vec3d(0.59, -0.1, 0.58), new Vec3d(0.58, -0.45, 0.52), new Vec3d(0.6, -0.75, 0.5), new Vec3d(0.5, -0.95, 0.2), new Vec3d(0.27, -0.98, 0.16)};
    protected static final double[] FRACTURE_WIDTHS_CLOSED = new double[]{0.0, 5.2E-4, 0.0051, 0.0056, 0.008, 0.009, 0.009, 0.0074, 0.0056, 0.0041, 4.2E-4, 0.0};
    protected static final double[] FRACTURE_WIDTHS_OPEN = new double[]{0.0, 5.2E-4, 0.152, 0.279, 0.316, 0.35, 0.35, 0.328, 0.272, 0.152, 5.2E-4, 0.0};
    protected static final double[][] FRACTURE_POINT_BUFFER = new double[FRACTURE_POINTS_CLOSED.length][3];
    protected static final float[][] FRACTURE_COLOR_BUFFER = new float[FRACTURE_POINTS_CLOSED.length][4];
    protected static final double[] FRACTURE_RADIUS_BUFFER = new double[FRACTURE_POINTS_CLOSED.length];

    @Override
    public void renderGlowingSphere(World world, double x, double y, double z, int color) {
        FXFireMote sphere = new FXFireMote(world, x, y, z, 0.0, 0.0, 0.0, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 3.0f, 0);
        sphere.func_187114_a(48);
        ParticleEngine.addEffect((World)world, (Particle)sphere);
    }

    @Override
    public void renderBurst(World world, double x, double y, double z, float size, int color) {
        FXGeneric fx = new FXGeneric(world, x, y, z, 0.0, 0.0, 0.0);
        fx.func_187114_a(31);
        fx.setGridSize(16);
        fx.setParticles(208, 31, 1);
        fx.setScale(new float[]{size});
        fx.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }

    @Override
    public void renderSpark(World world, double x, double y, double z, float size, int color, boolean colorAlpha) {
        FXDispatcher.INSTANCE.spark(x, y, z, size, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, colorAlpha ? (float)(color >> 24 & 0xFF) / 255.0f : 1.0f);
    }

    @Override
    public void renderArc(World world, double x, double y, double z, double dx, double dy, double dz, int color, double height) {
        FXArcCustom arc = new FXArcCustom(world, x, y, z, dx, dy, dz, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, height, 0.2, 0.0625, 0.125f);
        arc.func_187114_a(5 + world.field_73012_v.nextInt(5));
        ParticleEngine.addEffect((World)world, (Particle)arc);
    }

    protected void renderFluxRiftShared(FluxRiftReconstructor rift, int stability, float partialTicks, int tessLevel, boolean goggles) {
        float stab = Math.max(Math.min(1.0f - (float)stability / 50.0f, 1.5f), 0.0f);
        for (int layer = 0; layer < 4; ++layer) {
            if (layer < 3) {
                GlStateManager.func_179132_a((boolean)false);
                if (layer == 0 && goggles) {
                    GlStateManager.func_179097_i();
                }
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)(layer != 3 ? GlStateManager.DestFactor.ONE : GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
            if (rift.getPoints().length > 2) {
                GlStateManager.func_179094_E();
                if (rift.getPoints().length > POINT_BUFFER.length) {
                    POINT_BUFFER = new double[rift.getPoints().length][3];
                    for (float[] arr : COLOR_BUFFER = new float[rift.getPoints().length][4]) {
                        Arrays.fill(arr, 1.0f);
                    }
                    RADIUS_BUFFER = new double[rift.getPoints().length];
                }
                for (int i = 0; i < rift.getPoints().length; ++i) {
                    float time = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
                    if (i > rift.getPoints().length / 2) {
                        time -= (float)(i * 10);
                    } else if (i < rift.getPoints().length / 2) {
                        time += (float)(i * 10);
                    }
                    TARenderHelperClient.POINT_BUFFER[i][0] = rift.getPoints()[i].field_72450_a + Math.sin((double)time / 50.0) * (double)0.1f * (double)stab;
                    TARenderHelperClient.POINT_BUFFER[i][1] = rift.getPoints()[i].field_72448_b + Math.sin((double)time / 60.0) * (double)0.1f * (double)stab;
                    TARenderHelperClient.POINT_BUFFER[i][2] = rift.getPoints()[i].field_72449_c + Math.sin((double)time / 70.0) * (double)0.1f * (double)stab;
                    TARenderHelperClient.RADIUS_BUFFER[i] = (double)rift.getWidths()[i] * (1.0 - Math.sin((double)time / 8.0) * (double)0.1f * (double)stab) * (layer < 3 ? 1.25 + 0.5 * (double)layer : 1.0);
                }
                GLE.set_POLYCYL_TESS(tessLevel);
                GLE.gleSetJoinStyle(2);
                GLE.glePolyCone(rift.getPoints().length, POINT_BUFFER, COLOR_BUFFER, RADIUS_BUFFER, 1.0f, 0.0f);
                GlStateManager.func_179121_F();
            }
            if (layer >= 3) continue;
            GlStateManager.func_179132_a((boolean)true);
            if (layer != 0 || !goggles) continue;
            GlStateManager.func_179126_j();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderFluxRift(FluxRiftReconstructor rift, int stability, float partialTicks, int tessLevel, boolean ignoreGoggles) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(RIFT_TEXTURE);
        TAShaderManager.enableShader(TAShaders.FLUX_RIFT, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
        GlStateManager.func_179147_l();
        this.renderFluxRiftShared(rift, stability, partialTicks, tessLevel, !ignoreGoggles && EntityUtils.hasGoggles((Entity)Minecraft.func_71410_x().field_71439_g));
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        TAShaderManager.disableShader();
        GlStateManager.func_179121_F();
    }

    protected void renderFluxRiftSingleLayer(FluxRiftReconstructor rift, int stability, float partialTicks, int tessLevel, boolean disableDepth, float r, float g, float b, float a, int joinType) {
        boolean colorMod = r < 1.0f || g < 1.0f || b < 1.0f || a < 1.0f;
        float stab = Math.max(Math.min(1.0f - (float)stability / 50.0f, 1.5f), 0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (disableDepth) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
        }
        if (rift.getPoints().length > 2) {
            GlStateManager.func_179094_E();
            if (rift.getPoints().length > POINT_BUFFER.length) {
                POINT_BUFFER = new double[rift.getPoints().length][3];
                for (float[] arr : COLOR_BUFFER = new float[rift.getPoints().length][4]) {
                    Arrays.fill(arr, 1.0f);
                }
                RADIUS_BUFFER = new double[rift.getPoints().length];
            }
            for (int i = 0; i < rift.getPoints().length; ++i) {
                float time = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
                if (i > rift.getPoints().length / 2) {
                    time -= (float)(i * 10);
                } else if (i < rift.getPoints().length / 2) {
                    time += (float)(i * 10);
                }
                TARenderHelperClient.POINT_BUFFER[i][0] = rift.getPoints()[i].field_72450_a + Math.sin((double)time / 50.0) * (double)0.1f * (double)stab;
                TARenderHelperClient.POINT_BUFFER[i][1] = rift.getPoints()[i].field_72448_b + Math.sin((double)time / 60.0) * (double)0.1f * (double)stab;
                TARenderHelperClient.POINT_BUFFER[i][2] = rift.getPoints()[i].field_72449_c + Math.sin((double)time / 70.0) * (double)0.1f * (double)stab;
                if (colorMod) {
                    TARenderHelperClient.COLOR_BUFFER[i][0] = r;
                    TARenderHelperClient.COLOR_BUFFER[i][1] = g;
                    TARenderHelperClient.COLOR_BUFFER[i][2] = b;
                    TARenderHelperClient.COLOR_BUFFER[i][3] = a;
                }
                TARenderHelperClient.RADIUS_BUFFER[i] = (double)rift.getWidths()[i] * (1.0 - Math.sin((double)time / 8.0) * (double)0.1f * (double)stab);
            }
            GLE.set_POLYCYL_TESS(tessLevel);
            GLE.gleSetJoinStyle(joinType);
            GLE.glePolyCone(rift.getPoints().length, POINT_BUFFER, COLOR_BUFFER, RADIUS_BUFFER, 1.0f, 0.0f);
            GlStateManager.func_179121_F();
        }
        if (disableDepth) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (colorMod) {
            for (float[] arr : COLOR_BUFFER) {
                Arrays.fill(arr, 1.0f);
            }
        }
    }

    @Override
    public void renderFluxRiftOutline(FluxRiftReconstructor rift, int stability, float partialTicks, int tessLevel, float r, float g, float b, float a, boolean bindTexture, int joinType) {
        GlStateManager.func_179094_E();
        if (bindTexture) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RIFT_TEXTURE);
        }
        GlStateManager.func_187409_d((int)1032, (int)6913);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        this.renderFluxRiftSingleLayer(rift, stability, partialTicks, tessLevel, false, r, g, b, a, joinType);
        GlStateManager.func_179089_o();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_187409_d((int)1032, (int)6914);
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderFluxRiftSolidLayer(FluxRiftReconstructor rift, int stability, float partialTicks, int tessLevel, float r, float g, float b, float a, boolean bindTexture, int joinType) {
        GlStateManager.func_179094_E();
        if (bindTexture) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BLANK);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        this.renderFluxRiftSingleLayer(rift, stability, partialTicks, tessLevel, false, r, g, b, a, joinType);
        GlStateManager.func_179145_e();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected double lerp(double initial, double last, double currentTime, double timeOpened, double totalTime) {
        double factor = MathHelper.func_151237_a((double)((currentTime - timeOpened) / totalTime), (double)0.0, (double)1.0);
        return (1.0 - factor) * initial + factor * last;
    }

    protected void renderDimensionalFractureSingleLayer(boolean open, long worldTime, long timeOpened, long openingDuration, float partialTicks, int tessLevel, float r, float g, float b, float a, int joinType) {
        GlStateManager.func_179094_E();
        double[][] pointBuffer = new double[FRACTURE_POINTS_CLOSED.length][3];
        float[][] colorBuffer = new float[FRACTURE_POINTS_CLOSED.length][4];
        double[] radiusBuffer = new double[FRACTURE_POINTS_CLOSED.length];
        for (int i = 0; i < FRACTURE_POINTS_CLOSED.length; ++i) {
            double time = (float)worldTime + partialTicks;
            if (i > FRACTURE_POINTS_CLOSED.length / 2) {
                time -= (double)(i * 10);
            } else if (i < FRACTURE_POINTS_CLOSED.length / 2) {
                time += (double)(i * 10);
            }
            Vec3d rotatedClosed = FRACTURE_POINTS_CLOSED[i].func_72441_c(-0.5, 1.0, -0.5);
            Vec3d rotatedOpen = FRACTURE_POINTS_OPEN[i].func_72441_c(-0.5, 1.0, -0.5);
            pointBuffer[i][0] = this.lerp(rotatedClosed.field_72450_a, rotatedOpen.field_72450_a, worldTime, timeOpened, openingDuration) + Math.sin(time / 50.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
            pointBuffer[i][1] = this.lerp(rotatedClosed.field_72448_b, rotatedOpen.field_72448_b, worldTime, timeOpened, openingDuration) + Math.sin(time / 60.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
            pointBuffer[i][2] = this.lerp(rotatedClosed.field_72449_c, rotatedOpen.field_72449_c, worldTime, timeOpened, openingDuration) + Math.sin(time / 70.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
            colorBuffer[i][0] = r;
            colorBuffer[i][1] = g;
            colorBuffer[i][2] = b;
            colorBuffer[i][3] = (float)this.lerp((double)a / 4.0, a, worldTime, timeOpened, openingDuration);
            double widthMultiplier = 1.0 - Math.sin(time / 8.0) * 0.1;
            radiusBuffer[i] = this.lerp(FRACTURE_WIDTHS_CLOSED[i], FRACTURE_WIDTHS_OPEN[i], worldTime, timeOpened, openingDuration) * widthMultiplier;
        }
        GLE.set_POLYCYL_TESS(tessLevel);
        GLE.gleSetJoinStyle(joinType);
        GLE.glePolyCone(pointBuffer.length, pointBuffer, colorBuffer, radiusBuffer, 1.0f, 0.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderDimensionalFracture(boolean open, long worldTime, long timeOpened, long openingDuration, float partialTicks, int tessLevel, boolean ignoreGoggles, float r, float g, float b, float a) {
        GlStateManager.func_179094_E();
        boolean isRevealing = !ignoreGoggles && EntityUtils.hasGoggles((Entity)(Minecraft.func_71410_x().func_175606_aa() != null ? Minecraft.func_71410_x().func_175606_aa() : Minecraft.func_71410_x().field_71439_g));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(open ? FRACTURE_TEXTURE_OPEN : FRACTURE_TEXTURE_CLOSED);
        if (TAShaderManager.shouldUseShaders()) {
            TAShaderManager.enableShader(TAShaders.FRACTURE, TAShaders.SHADER_CALLBACK_GENERIC_SPHERE);
        }
        GlStateManager.func_179147_l();
        for (int layer = 0; layer < 4; ++layer) {
            if (layer != 3) {
                GlStateManager.func_179132_a((boolean)false);
                if (layer == 0 && isRevealing) {
                    GlStateManager.func_179097_i();
                }
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)(layer != 3 ? GlStateManager.DestFactor.ONE : GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
            GlStateManager.func_179094_E();
            for (int i = 0; i < FRACTURE_POINTS_CLOSED.length; ++i) {
                double time = (float)worldTime + partialTicks;
                if (i > FRACTURE_POINTS_CLOSED.length / 2) {
                    time -= (double)(i * 10);
                } else if (i < FRACTURE_POINTS_CLOSED.length / 2) {
                    time += (double)(i * 10);
                }
                Vec3d rotatedClosed = FRACTURE_POINTS_CLOSED[i].func_72441_c(-0.5, 1.0, -0.5);
                Vec3d rotatedOpen = FRACTURE_POINTS_OPEN[i].func_72441_c(-0.5, 1.0, -0.5);
                TARenderHelperClient.FRACTURE_POINT_BUFFER[i][0] = this.lerp(rotatedClosed.field_72450_a, rotatedOpen.field_72450_a, worldTime, timeOpened, openingDuration) + Math.sin(time / 50.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
                TARenderHelperClient.FRACTURE_POINT_BUFFER[i][1] = this.lerp(rotatedClosed.field_72448_b, rotatedOpen.field_72448_b, worldTime, timeOpened, openingDuration) + Math.sin(time / 60.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
                TARenderHelperClient.FRACTURE_POINT_BUFFER[i][2] = this.lerp(rotatedClosed.field_72449_c, rotatedOpen.field_72449_c, worldTime, timeOpened, openingDuration) + Math.sin(time / 70.0) * this.lerp(0.1, 0.01, worldTime, timeOpened, openingDuration);
                TARenderHelperClient.FRACTURE_COLOR_BUFFER[i][0] = r;
                TARenderHelperClient.FRACTURE_COLOR_BUFFER[i][1] = g;
                TARenderHelperClient.FRACTURE_COLOR_BUFFER[i][2] = b;
                TARenderHelperClient.FRACTURE_COLOR_BUFFER[i][3] = (float)this.lerp((double)a / 4.0, a, worldTime, timeOpened, openingDuration);
                double widthMultiplier = 1.0 - Math.sin(time / 8.0) * 0.1;
                TARenderHelperClient.FRACTURE_RADIUS_BUFFER[i] = this.lerp(FRACTURE_WIDTHS_CLOSED[i], FRACTURE_WIDTHS_OPEN[i], worldTime, timeOpened, openingDuration) * widthMultiplier * (layer != 3 ? 1.25 + 0.5 * (double)layer : 1.0);
            }
            GLE.set_POLYCYL_TESS(tessLevel);
            GLE.gleSetJoinStyle(2);
            GLE.glePolyCone(FRACTURE_POINT_BUFFER.length, FRACTURE_POINT_BUFFER, FRACTURE_COLOR_BUFFER, FRACTURE_RADIUS_BUFFER, 1.0f, 0.0f);
            GlStateManager.func_179121_F();
            if (layer == 3) continue;
            GlStateManager.func_179132_a((boolean)true);
            if (layer != 0 || !isRevealing) continue;
            GlStateManager.func_179126_j();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        if (TAShaderManager.shouldUseShaders()) {
            TAShaderManager.disableShader();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderDimensionalFractureSolidLayer(boolean open, long worldTime, long timeOpened, long openingDuration, float partialTicks, int tessLevel, float r, float g, float b, float a, boolean bindTexture, int joinType) {
        GlStateManager.func_179094_E();
        if (bindTexture) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BLANK);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        this.renderDimensionalFractureSingleLayer(open, worldTime, timeOpened, openingDuration, partialTicks, tessLevel, r, g, b, a, joinType);
        GlStateManager.func_179145_e();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderWispyMotes(World world, double x, double y, double z, double dx, double dy, double dz, int age, float r, float g, float b, float gravity) {
        FXDispatcher.INSTANCE.drawWispyMotes(x, y, z, dx, dy, dz, age, r, g, b, gravity);
    }

    @Override
    public void renderFireMote(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale) {
        FXDispatcher.INSTANCE.drawFireMote(x, y, z, vx, vy, vz, r, g, b, a, scale);
    }

    @Override
    public void renderSmokeSpiral(World world, double x, double y, double z, float rad, int start, int minY, int color) {
        FXDispatcher.INSTANCE.smokeSpiral(x, y, z, rad, start, minY, color);
    }

    @Override
    public void renderTerraformerParticle(World world, double x, double y, double z, double vx, double vy, double vz, int color) {
        FXGeneric fx = new FXGeneric(world, x, y, z, vx, vy, vz);
        fx.func_187114_a(30 + world.field_73012_v.nextInt(12));
        fx.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        fx.setAlphaF(new float[]{0.9f, 0.0f});
        fx.setGridSize(16);
        fx.setParticles(56, 1, 1);
        fx.setScale(new float[]{4.0f});
        fx.setLayer(1);
        fx.setLoop(true);
        fx.setNoClip(false);
        fx.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }

    @Override
    public void renderRiftMoverParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        FXGeneric fx = new FXGeneric(world, x, y, z, vx, vy, vz);
        fx.func_187114_a(12 + world.field_73012_v.nextInt(6));
        fx.func_70538_b(0.044f, 0.036f, 0.063f);
        fx.func_82338_g(0.75f);
        fx.setGridSize(64);
        fx.setParticles(264, 8, 1);
        fx.setScale(new float[]{2.0f});
        fx.setLayer(1);
        fx.setLoop(true);
        fx.setNoClip(false);
        fx.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }

    @Override
    public void renderObeliskParticles(World world, double x, double y, double z) {
        FXGeneric fx = new FXGeneric(world, x, y, z, 0.0, 0.0, 0.0);
        fx.func_187114_a(80 + world.field_73012_v.nextInt(20));
        fx.func_70538_b(0.05f, 0.05f, 0.05f);
        fx.setAlphaF(new float[]{0.0f, 0.75f, 0.0f});
        fx.setGridSize(64);
        fx.setParticles(264, 8, 1);
        fx.setScale(new float[]{2.0f});
        fx.setLayer(1);
        fx.setLoop(true);
        fx.setNoClip(false);
        fx.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }

    @Override
    public void renderParticleTrail(World world, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b) {
        for (int i = 0; i < 2 + world.field_73012_v.nextInt(4); ++i) {
            FXGeneric fx = new FXGeneric(world, x + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 2.0, y + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 2.0, z + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 2.0, vx, vy, vz);
            fx.func_187114_a(80 + world.field_73012_v.nextInt(20));
            fx.func_70538_b(r, g, b);
            fx.setAlphaF(new float[]{0.0f, 0.5f, 0.0f});
            fx.setGridSize(64);
            fx.setParticles(264, 8, 1);
            fx.setScale(new float[]{2.0f, 1.0f});
            fx.setLayer(1);
            fx.setLoop(true);
            fx.setNoClip(false);
            fx.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
            ParticleEngine.addEffect((World)world, (Particle)fx);
        }
    }

    @Override
    public void renderWisp(double x, double y, double z, Entity target) {
        FXDispatcher.INSTANCE.wispFXEG(x, y, z, target);
    }

    @Override
    public void renderVent(double x, double y, double z, double vx, double vy, double vz, int color, float scale) {
        FXDispatcher.INSTANCE.drawVentParticles(x, y, z, vx, vy, vz, color, scale);
    }

    @Override
    public void renderWispParticles(double x, double y, double z, double vx, double vy, double vz, int color, int delay) {
        FXDispatcher.INSTANCE.drawWispParticles(x, y, z, vx, vy, vz, color, delay);
    }

    @Override
    public void renderFollowingParticles(World world, double x, double y, double z, Entity toFollow, float r, float g, float b) {
        FXGenericP2ECustomSpeed orb = new FXGenericP2ECustomSpeed(world, x, y, z, toFollow, -0.2, 0.2);
        orb.func_70538_b(r, g, b);
        orb.func_187114_a(200);
        orb.setAlphaF(new float[]{0.75f, 1.0f, 0.0f});
        orb.setGridSize(64);
        orb.setParticles(264, 8, 1);
        orb.setScale(new float[]{2.0f});
        orb.setLayer(1);
        orb.setLoop(true);
        orb.setNoClip(false);
        orb.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
        ParticleEngine.addEffect((World)world, (Particle)orb);
    }

    @Nullable
    private static EnumHand findImpulseCannon(EntityLivingBase entity) {
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() == TAItems.IMPULSE_CANNON) {
            return EnumHand.MAIN_HAND;
        }
        stack = entity.func_184592_cb();
        if (stack.func_77973_b() == TAItems.IMPULSE_CANNON) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    @Override
    public void renderStarfieldGlass(ShaderType type, TileStarfieldGlass tile, double pX, double pY, double pZ) {
        List allSides;
        IExtendedBlockState state;
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        IBlockState s = world.func_180495_p(pos);
        if ((s = s.func_177230_c().getExtendedState(s, (IBlockAccess)world, pos)) instanceof IExtendedBlockState && (state = (IExtendedBlockState)s).getUnlistedNames().contains(IRenderableSides.SIDES) && (allSides = (List)state.getValue(IRenderableSides.SIDES)) != null && !allSides.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - pX), (double)((double)pos.func_177956_o() - pY), (double)((double)pos.func_177952_p() - pZ));
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder buffer = t.func_178180_c();
            for (EnumFacing face : allSides) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                switch (face) {
                    case DOWN: {
                        buffer.func_181662_b(0.0, Z_CLOSE_NEG, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, Z_CLOSE_NEG, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, Z_CLOSE_NEG, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(0.0, Z_CLOSE_NEG, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                        break;
                    }
                    case UP: {
                        buffer.func_181662_b(0.0, Z_CLOSE_POS, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(0.0, Z_CLOSE_POS, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, Z_CLOSE_POS, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(1.0, Z_CLOSE_POS, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                        break;
                    }
                    case EAST: {
                        buffer.func_181662_b(Z_CLOSE_POS, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_POS, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_POS, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_POS, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                        break;
                    }
                    case WEST: {
                        buffer.func_181662_b(Z_CLOSE_NEG, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_NEG, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_NEG, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(Z_CLOSE_NEG, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                        break;
                    }
                    case SOUTH: {
                        buffer.func_181662_b(0.0, 0.0, Z_CLOSE_POS).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, 0.0, Z_CLOSE_POS).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, 1.0, Z_CLOSE_POS).func_187315_a(1.0, 1.0).func_181675_d();
                        buffer.func_181662_b(0.0, 1.0, Z_CLOSE_POS).func_187315_a(1.0, 0.0).func_181675_d();
                        break;
                    }
                    case NORTH: {
                        buffer.func_181662_b(0.0, 0.0, Z_CLOSE_NEG).func_187315_a(0.0, 0.0).func_181675_d();
                        buffer.func_181662_b(0.0, 1.0, Z_CLOSE_NEG).func_187315_a(1.0, 0.0).func_181675_d();
                        buffer.func_181662_b(1.0, 1.0, Z_CLOSE_NEG).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b(1.0, 0.0, Z_CLOSE_NEG).func_187315_a(1.0, 1.0).func_181675_d();
                        break;
                    }
                }
                t.func_78381_a();
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void renderObelisk(ShaderType type, TileObelisk tile, double pX, double pY, double pZ) {
        BlockPos pos = tile.func_174877_v();
        IBlockState state = tile.func_145831_w().func_180495_p(pos);
        double offset = Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().func_71356_B() ? 0.0 : (double)Minecraft.func_71410_x().func_184121_ak();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - pX), (double)((double)pos.func_177956_o() - pY + Math.sin(((double)Minecraft.func_71410_x().field_71439_g.field_70173_aa + offset) / 20.0) / 4.0), (double)((double)pos.func_177952_p() - pZ));
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (!state.func_185894_c((IBlockAccess)tile.func_145831_w(), pos, face) && !state.func_185894_c((IBlockAccess)tile.func_145831_w(), pos.func_177984_a(), face) && !state.func_185894_c((IBlockAccess)tile.func_145831_w(), pos.func_177977_b(), face)) continue;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            switch (face) {
                case EAST: {
                    buffer.func_181662_b(Z_CLOSE_POS, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_POS, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_POS, 2.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_POS, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case WEST: {
                    buffer.func_181662_b(Z_CLOSE_NEG, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_NEG, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_NEG, 2.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(Z_CLOSE_NEG, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case SOUTH: {
                    buffer.func_181662_b(0.0, -1.0, Z_CLOSE_POS).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, -1.0, Z_CLOSE_POS).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, 2.0, Z_CLOSE_POS).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(0.0, 2.0, Z_CLOSE_POS).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case NORTH: {
                    buffer.func_181662_b(0.0, -1.0, Z_CLOSE_NEG).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.0, 2.0, Z_CLOSE_NEG).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, 2.0, Z_CLOSE_NEG).func_187315_a(0.0, 1.0).func_181675_d();
                    buffer.func_181662_b(1.0, -1.0, Z_CLOSE_NEG).func_187315_a(1.0, 1.0).func_181675_d();
                    break;
                }
            }
            t.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderRiftBarrier(ShaderType type, TileRiftBarrier tile, double pX, double pY, double pZ) {
        BlockPos pos = tile.func_174877_v();
        IBlockState state = tile.func_145831_w().func_180495_p(pos);
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
        if (state.func_185894_c((IBlockAccess)tile.func_145831_w(), pos, face) || state.func_185894_c((IBlockAccess)tile.func_145831_w(), pos, face.func_176734_d())) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - pX), (double)((double)pos.func_177956_o() - pY), (double)((double)pos.func_177952_p() - pZ));
            GlStateManager.func_179129_p();
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder buffer = t.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            switch (face) {
                case EAST: {
                    buffer.func_181662_b(0.5, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.5, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.5, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(0.5, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case WEST: {
                    buffer.func_181662_b(0.5, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.5, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.5, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(0.5, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case SOUTH: {
                    buffer.func_181662_b(0.0, 0.0, 0.5).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                    break;
                }
                case NORTH: {
                    buffer.func_181662_b(0.0, 0.0, 0.5).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 0.5).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                    break;
                }
            }
            t.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawCube() {
        this.drawCube(0.0, 1.0);
    }

    @Override
    public void drawCube(double min, double max) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(min, min, max).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(max, min, max).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(min, max, max).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(max, max, max).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(max, max, min).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(max, min, max).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(max, min, min).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(min, min, max).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(min, min, min).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(min, max, max).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(min, max, min).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(max, max, min).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(min, min, min).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(max, min, min).func_187315_a(1.0, 1.0).func_181675_d();
        t.func_78381_a();
    }

    @Override
    public Vec3d estimateImpulseCannonFiringPoint(EntityLivingBase entity, float partialTicks) {
        ModelBase model;
        Vec3d origin = null;
        Entity rv = Minecraft.func_71410_x().func_175606_aa() != null ? Minecraft.func_71410_x().func_175606_aa() : Minecraft.func_71410_x().field_71439_g;
        Render r = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entity);
        if (r instanceof RenderLivingBase && (model = ((RenderLivingBase)r).func_177087_b()) instanceof ModelBiped) {
            ModelBiped biped = (ModelBiped)model;
            EnumHand hand = TARenderHelperClient.findImpulseCannon(entity);
            EnumHandSide side = hand == EnumHand.MAIN_HAND ? entity.func_184591_cq() : entity.func_184591_cq().func_188468_a();
            float armLength = 0.0f;
            float armHeight = 0.0f;
            float armHeightFromGround = 0.0f;
            float armWidth = 0.0f;
            boolean rightSide = side == EnumHandSide.RIGHT;
            boolean rotateHeight = true;
            if (entity.equals((Object)rv) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                armLength = 0.3f;
                armHeightFromGround = 1.525f;
                if (entity.func_70093_af()) {
                    armHeightFromGround -= 0.08f;
                }
                armHeight = 0.0f;
                armWidth = rightSide ? -0.125f : 0.125f;
                rotateHeight = false;
            } else {
                ModelRenderer arm;
                ModelRenderer modelRenderer = arm = rightSide ? biped.field_178723_h : biped.field_178724_i;
                if (!arm.field_78804_l.isEmpty()) {
                    ModelBox box = (ModelBox)arm.field_78804_l.get(0);
                    armLength = (box.field_78249_e - box.field_78250_b) / 16.0f + 0.7f;
                    armHeightFromGround = arm.field_78797_d / 2.0f;
                    if (entity.func_70093_af()) {
                        armHeightFromGround -= 0.3f;
                    }
                    armHeight = (box.field_78246_f - box.field_78251_c) / 16.0f + 0.1f;
                    armWidth = arm.field_78800_c / 16.0f;
                } else {
                    armLength = 0.7f;
                    armHeightFromGround = entity.func_70093_af() ? 0.6f : 0.9f;
                    armHeight = 0.2f;
                    armWidth = 0.2f;
                }
            }
            double lerpX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double lerpY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
            double lerpZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            float lerpPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float lerpYaw = entity.field_70758_at + (entity.field_70759_as - entity.field_70758_at) * partialTicks;
            origin = rotateHeight ? new Vec3d(0.0, (double)armHeight, (double)armLength).func_178789_a((float)(-Math.toRadians(lerpPitch))).func_72441_c((double)armWidth, 0.0, 0.0).func_178785_b((float)(-Math.toRadians(lerpYaw))).func_72441_c(lerpX, lerpY + (double)armHeightFromGround, lerpZ) : new Vec3d(0.0, 0.0, (double)armLength).func_178789_a((float)(-Math.toRadians(lerpPitch))).func_72441_c((double)armWidth, 0.0, 0.0).func_178785_b((float)(-Math.toRadians(lerpYaw))).func_72441_c(lerpX, lerpY + (double)armHeightFromGround, lerpZ);
        }
        if (origin == null) {
            double lerpX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double lerpY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
            double lerpZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            origin = new Vec3d(lerpX, lerpY, lerpZ).func_72441_c(0.0, (double)(entity.field_70131_O / 2.0f), 0.0);
        }
        return origin;
    }

    @Override
    public boolean shadersAvailable() {
        return TAShaderManager.shouldUseShaders();
    }

    @Override
    public boolean stencilAvailable() {
        return GL11.glGetInteger((int)3415) > 0;
    }
}

