/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.ARBShaderObjects;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;

public final class TAShaderManager {
    private static final String EMPTY_SHADER_NAME = "__reserved_empty_shader";
    private static final HashMap<String, Shader> SHADERS = new HashMap();
    private static boolean disabled = false;

    private TAShaderManager() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadFile(ResourceLocation file, String ext) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TAShaderManager.class.getResourceAsStream("/assets/" + file.func_110624_b() + "/shaders/" + file.func_110623_a() + ext), StandardCharsets.UTF_8));){
            reader.lines().forEach(str -> builder.append((String)str).append('\n'));
            String string = builder.toString();
            return string;
        }
        catch (IOException ex) {
            ThaumicAugmentation.getLogger().error((Object)ex);
            return "";
        }
    }

    private static String getExtensionForType(int type) {
        if (type == 35633) {
            return ".vert";
        }
        if (type == 35632) {
            return ".frag";
        }
        return "";
    }

    private static int loadShader(ResourceLocation path, int type) {
        int id = ARBShaderObjects.glCreateShaderObjectARB((int)type);
        if (id == 0) {
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)id, (CharSequence)TAShaderManager.loadFile(path, TAShaderManager.getExtensionForType(type)));
        ARBShaderObjects.glCompileShaderARB((int)id);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)id, (int)35713) == 0) {
            ThaumicAugmentation.getLogger().error("OpenGL shader error: " + ARBShaderObjects.glGetInfoLogARB((int)id, (int)ARBShaderObjects.glGetObjectParameteriARB((int)id, (int)35716)));
            ARBShaderObjects.glDeleteObjectARB((int)id);
            return 0;
        }
        return id;
    }

    private static int loadShaderProgram(ResourceLocation path) {
        int vert = TAShaderManager.loadShader(path, 35633);
        int frag = TAShaderManager.loadShader(path, 35632);
        if (vert != 0 && frag != 0) {
            int program = ARBShaderObjects.glCreateProgramObjectARB();
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vert);
            ARBShaderObjects.glAttachObjectARB((int)program, (int)frag);
            ARBShaderObjects.glLinkProgramARB((int)program);
            ARBShaderObjects.glDeleteObjectARB((int)vert);
            ARBShaderObjects.glDeleteObjectARB((int)frag);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
                ThaumicAugmentation.getLogger().error("OpenGL shader errror: " + ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
                return 0;
            }
            ARBShaderObjects.glValidateProgramARB((int)program);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
                ThaumicAugmentation.getLogger().error("OpenGL shader errror: " + ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
                return 0;
            }
            return program;
        }
        return 0;
    }

    public static void init() {
        disabled = TAConfig.disableShaders.getValue();
    }

    public static boolean shouldUseShaders() {
        return OpenGlHelper.field_148824_g && !disabled;
    }

    public static Shader registerShader(ResourceLocation shader) {
        if (TAShaderManager.shouldUseShaders()) {
            if (shader.toString().equals(EMPTY_SHADER_NAME)) {
                throw new RuntimeException("Invalid usage of empty shader name (use literally anything else): __reserved_empty_shader");
            }
            Shader toAdd = new Shader(TAShaderManager.loadShaderProgram(shader));
            SHADERS.put(shader.toString(), toAdd);
            return toAdd;
        }
        return SHADERS.get(EMPTY_SHADER_NAME);
    }

    public static void enableShader(Shader shader) {
        TAShaderManager.enableShader(shader, null);
    }

    public static void enableShader(Shader shader, @Nullable Consumer<Shader> callback) {
        if (TAShaderManager.shouldUseShaders() && shader.getID() != 0) {
            ARBShaderObjects.glUseProgramObjectARB((int)shader.getID());
            int timeUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader.getID(), (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)timeUniform, (int)(Minecraft.func_71410_x().func_175606_aa() != null ? Minecraft.func_71410_x().func_175606_aa().field_70173_aa : Minecraft.func_71410_x().field_71439_g.field_70173_aa));
            if (callback != null) {
                callback.accept(shader);
            }
        }
    }

    public static void disableShader() {
        if (TAShaderManager.shouldUseShaders()) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    public static void destroyShaders() {
        for (Shader shader : SHADERS.values()) {
            if (shader.getID() == 0) continue;
            ARBShaderObjects.glDeleteObjectARB((int)shader.getID());
        }
        SHADERS.clear();
        SHADERS.put(new ResourceLocation("thaumicaugmentation", EMPTY_SHADER_NAME).toString(), new Shader(0));
    }

    static {
        SHADERS.put(new ResourceLocation("thaumicaugmentation", EMPTY_SHADER_NAME).toString(), new Shader(0));
    }

    public static final class Shader {
        private int id;

        protected Shader(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

