/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionBoolean;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionDouble;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionDoubleList;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionEnum;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionFloat;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionInt;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionIntList;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionIntSet;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionLong;
import thecodex6824.thaumicaugmentation.api.config.ConfigOptionStringList;
import thecodex6824.thaumicaugmentation.api.config.IEnumSerializer;
import thecodex6824.thaumicaugmentation.api.config.TAConfigManager;
import thecodex6824.thaumicaugmentation.common.network.PacketConfigSync;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

@Config(modid="thaumicaugmentation", category="")
@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public final class TAConfigHolder {
    @Config.LangKey(value="thaumicaugmentation.text.config.general")
    public static GeneralOptions general = new GeneralOptions();
    @Config.LangKey(value="thaumicaugmentation.text.config.gameplay")
    public static GameplayOptions gameplay = new GameplayOptions();
    @Config.LangKey(value="thaumicaugmentation.text.config.world")
    public static WorldOptions world = new WorldOptions();
    @Config.LangKey(value="thaumicaugmentation.text.config.client")
    public static ClientOptions client = new ClientOptions();
    private static ArrayList<Runnable> listeners = new ArrayList();

    private TAConfigHolder() {
    }

    public static void addListener(Runnable r) {
        listeners.add(r);
    }

    public static boolean removeListener(Runnable r) {
        return listeners.remove(r);
    }

    public static Collection<Runnable> getListeners() {
        return listeners;
    }

    public static void loadConfigValues(Side side) {
        TAConfig.gauntletVisDiscounts.setValue(TAConfigHolder.gameplay.gauntletVisDiscounts, side);
        TAConfig.gauntletCooldownModifiers.setValue(TAConfigHolder.gameplay.gauntletCooldownModifiers, side);
        TAConfig.voidseerArea.setValue(TAConfigHolder.gameplay.voidseerArea, side);
        TAConfig.voidBootsLandSpeedBoost.setValue(TAConfigHolder.gameplay.voidBootsLandSpeedBoost, side);
        TAConfig.voidBootsWaterSpeedBoost.setValue(TAConfigHolder.gameplay.voidBootsWaterSpeedBoost, side);
        TAConfig.voidBootsJumpBoost.setValue(TAConfigHolder.gameplay.voidBootsJumpBoost, side);
        TAConfig.voidBootsJumpFactor.setValue(TAConfigHolder.gameplay.voidBootsJumpFactor, side);
        TAConfig.voidBootsStepHeight.setValue(TAConfigHolder.gameplay.voidBootsStepHeight, side);
        TAConfig.voidBootsSneakReduction.setValue(TAConfigHolder.gameplay.voidBootsSneakReduction, side);
        TAConfig.serverMovementCalculation.setValue(TAConfigHolder.gameplay.serverMovementCalculation, side);
        TAConfig.opWardOverride.setValue(TAConfigHolder.gameplay.ward.opWardOverride, side);
        TAConfig.singlePlayerWardOverride.setValue(TAConfigHolder.gameplay.ward.singlePlayerWardOverride, side);
        TAConfig.tileWardMode.setValue(TAConfigHolder.gameplay.ward.tileWardMode, side);
        TAConfig.reducedEffects.setValue(TAConfigHolder.client.reducedEffects, side);
        TAConfig.disableCreativeOnlyText.setValue(TAConfigHolder.client.disableCreativeOnlyText, side);
        TAConfig.defaultGauntletColors.setValue(TAConfigHolder.gameplay.defaultGauntletColors, side);
        TAConfig.defaultVoidBootsColor.setValue(TAConfigHolder.gameplay.defaultVoidBootsColor, side);
        TAConfig.emptinessMoveFactor.setValue(TAConfigHolder.world.emptinessMoveFactor, side);
        TAConfig.fractureGenChance.setValue(TAConfigHolder.world.fractureGenChance, side);
        TAConfig.fractureLocatorUpdateInterval.setValue(TAConfigHolder.world.fractureLocatorUpdateInterval, side);
        TAConfig.fracturesAlwaysTeleport.setValue(TAConfigHolder.world.fracturesAlwaysTeleport, side);
        TAConfig.gauntletCastAnimation.setValue(TAConfigHolder.client.gauntletCastAnimation, side);
        TAConfig.terraformerImpetusCost.setValue(Long.valueOf(TAConfigHolder.gameplay.impetus.terraformerCost));
        TAConfig.shieldFocusImpetusCost.setValue(Long.valueOf(TAConfigHolder.gameplay.impetus.shieldFocusCost));
        TAConfig.allowWussRiftSeed.setValue(TAConfigHolder.gameplay.allowWussRiftSeed);
        TAConfig.cannonBeamDamage.setValue(Float.valueOf(TAConfigHolder.gameplay.impetus.cannon.beamDamage));
        TAConfig.cannonBeamCost.setValue(Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.beamCost));
        TAConfig.cannonBeamRange.setValue(TAConfigHolder.gameplay.impetus.cannon.beamRange);
        TAConfig.cannonRailgunDamage.setValue(Float.valueOf(TAConfigHolder.gameplay.impetus.cannon.railgunDamage));
        TAConfig.cannonRailgunCost.setValue(Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.railgunCost));
        TAConfig.cannonRailgunCooldown.setValue(TAConfigHolder.gameplay.impetus.cannon.railgunCooldown);
        TAConfig.cannonRailgunRange.setValue(TAConfigHolder.gameplay.impetus.cannon.railgunRange);
        TAConfig.cannonBurstDamage.setValue(Float.valueOf(TAConfigHolder.gameplay.impetus.cannon.burstDamage));
        TAConfig.cannonBurstCost.setValue(Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.burstCost));
        TAConfig.cannonBurstCooldown.setValue(TAConfigHolder.gameplay.impetus.cannon.burstCooldown);
        TAConfig.cannonBurstRange.setValue(TAConfigHolder.gameplay.impetus.cannon.burstRange);
        TAConfig.primalCutterDamage.setValue(Float.valueOf(TAConfigHolder.gameplay.primalCutterDamage));
        TAConfig.deniedCategories.setValue(TAConfigHolder.gameplay.deniedCategories);
        TAConfig.generateSpires.setValue(TAConfigHolder.world.generateSpires);
        TAConfig.spireMinDist.setValue(TAConfigHolder.world.spireMinDist);
        TAConfig.spireSpacing.setValue(TAConfigHolder.world.spireSpacing);
        TAConfig.experienceModifierCap.setValue(TAConfigHolder.gameplay.augment.experienceModifierCap);
        TAConfig.experienceModifierBase.setValue(TAConfigHolder.gameplay.augment.experienceModifierBase);
        TAConfig.experienceModifierScale.setValue(TAConfigHolder.gameplay.augment.experienceModifierScale);
        TAConfig.elementalModifierPositiveFactor.setValue(TAConfigHolder.gameplay.augment.elementalModifierPositiveFactor);
        TAConfig.elementalModifierNegativeFactor.setValue(TAConfigHolder.gameplay.augment.elementalModifierNegativeFactor);
        TAConfig.dimensionalModifierOverworldPostiveFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierOverworldPositiveFactor);
        TAConfig.dimensionalModifierOverworldNegativeFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierOverworldNegativeFactor);
        TAConfig.dimensionalModifierOverworldDims.setValue((Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierOverworldDims));
        TAConfig.dimensionalModifierNetherPostiveFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierNetherPositiveFactor);
        TAConfig.dimensionalModifierNetherNegativeFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierNetherNegativeFactor);
        TAConfig.dimensionalModifierNetherDims.setValue((Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierNetherDims));
        TAConfig.dimensionalModifierEndPostiveFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierEndPositiveFactor);
        TAConfig.dimensionalModifierEndNegativeFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierEndNegativeFactor);
        TAConfig.dimensionalModifierEndDims.setValue((Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierEndDims));
        TAConfig.dimensionalModifierEmptinessPostiveFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessPositiveFactor);
        TAConfig.dimensionalModifierEmptinessNegativeFactor.setValue(TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessNegativeFactor);
        TAConfig.dimensionalModifierEmptinessDims.setValue((Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessDims));
        TAConfig.frenzyModifierScaleFactor.setValue(TAConfigHolder.gameplay.augment.frenzyModifierScale);
        TAConfig.frenzyModifierCooldown.setValue(TAConfigHolder.gameplay.augment.frenzyModifierCooldown);
        TAConfig.frenzyModifierMaxLevel.setValue(TAConfigHolder.gameplay.augment.frenzyModifierMaxLevel);
        TAConfig.impetusConductorFactor.setValue(TAConfigHolder.gameplay.augment.impetusConductorFactor);
    }

    public static void syncLocally() {
        ConfigManager.sync((String)"thaumicaugmentation", (Config.Type)Config.Type.INSTANCE);
    }

    public static void syncConfig() {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            TAConfigHolder.syncConfig(player);
        }
    }

    public static void syncConfig(EntityPlayerMP target) {
        TANetwork.INSTANCE.sendTo((IMessage)new PacketConfigSync(TAConfigManager.createSyncBuffer(Side.CLIENT)), target);
    }

    public static void loadOrSyncConfig(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            TAConfigHolder.loadConfigValues(Side.SERVER);
            TAConfigHolder.syncConfig((EntityPlayerMP)player);
        } else if (!player.field_70170_p.field_72995_K) {
            TAConfigHolder.loadConfigValues(Side.SERVER);
        } else {
            TAConfigHolder.loadConfigValues(Side.CLIENT);
        }
    }

    public static void preInit() {
        TAConfig.gauntletVisDiscounts = TAConfigManager.addOption(new ConfigOptionDoubleList(false, TAConfigHolder.gameplay.gauntletVisDiscounts));
        TAConfig.gauntletCooldownModifiers = TAConfigManager.addOption(new ConfigOptionDoubleList(false, TAConfigHolder.gameplay.gauntletCooldownModifiers));
        TAConfig.voidseerArea = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.gameplay.voidseerArea));
        TAConfig.voidBootsLandSpeedBoost = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsLandSpeedBoost));
        TAConfig.voidBootsWaterSpeedBoost = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsWaterSpeedBoost));
        TAConfig.voidBootsJumpBoost = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsJumpBoost));
        TAConfig.voidBootsJumpFactor = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsJumpFactor));
        TAConfig.voidBootsStepHeight = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsStepHeight));
        TAConfig.voidBootsSneakReduction = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.voidBootsSneakReduction));
        TAConfig.serverMovementCalculation = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.gameplay.serverMovementCalculation));
        TAConfig.opWardOverride = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.gameplay.ward.opWardOverride));
        TAConfig.singlePlayerWardOverride = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.gameplay.ward.singlePlayerWardOverride));
        TAConfig.disableWardFocus = TAConfigManager.addOption(new ConfigOptionBoolean(true, TAConfigHolder.gameplay.ward.disableWardFocus));
        TAConfig.tileWardMode = TAConfigManager.addOption(new ConfigOptionEnum<TAConfig.TileWardMode>(false, TAConfigHolder.gameplay.ward.tileWardMode, new IEnumSerializer<TAConfig.TileWardMode>(){

            @Override
            public void serialize(TAConfig.TileWardMode value, ByteBuf buf) {
                buf.writeInt(value.ordinal());
            }

            @Override
            public TAConfig.TileWardMode deserialize(ByteBuf buf) {
                return TAConfig.TileWardMode.values()[Math.min(TAConfig.TileWardMode.values().length - 1, Math.max(buf.readInt(), 0))];
            }
        }));
        TAConfig.reducedEffects = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.reducedEffects));
        TAConfig.optimizedFluxRiftRenderer = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.optimizedFluxRiftRenderer));
        TAConfig.enableBoosterKeybind = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.enableBoosterKeybind));
        TAConfig.disableShaders = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.disableShaders));
        TAConfig.morphicArmorExclusions = TAConfigManager.addOption(new ConfigOptionStringList(false, TAConfigHolder.client.morphicArmorExclusions));
        TAConfig.disableCreativeOnlyText = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.disableCreativeOnlyText));
        TAConfig.defaultGauntletColors = TAConfigManager.addOption(new ConfigOptionIntList(true, TAConfigHolder.gameplay.defaultGauntletColors));
        TAConfig.defaultVoidBootsColor = TAConfigManager.addOption(new ConfigOptionInt(true, TAConfigHolder.gameplay.defaultVoidBootsColor));
        TAConfig.emptinessDimID = TAConfigManager.addOption(new ConfigOptionInt(true, TAConfigHolder.world.emptinessDimID));
        TAConfig.emptinessMoveFactor = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.world.emptinessMoveFactor));
        TAConfig.fractureGenChance = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.world.fractureGenChance));
        TAConfig.fractureDimList = TAConfigManager.addOption(new ConfigOptionStringList(false, TAConfigHolder.world.fractureDimList));
        TAConfig.fractureLocatorUpdateInterval = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.world.fractureLocatorUpdateInterval));
        TAConfig.fracturesAlwaysTeleport = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.world.fracturesAlwaysTeleport));
        TAConfig.disableEmptiness = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.world.disableEmptiness));
        TAConfig.disableCoremod = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.general.disableCoremod));
        TAConfig.disabledTransformers = TAConfigManager.addOption(new ConfigOptionStringList(false, TAConfigHolder.general.disabledTransformers));
        TAConfig.gauntletCastAnimation = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.client.gauntletCastAnimation));
        TAConfig.terraformerImpetusCost = TAConfigManager.addOption(new ConfigOptionLong(false, Long.valueOf(TAConfigHolder.gameplay.impetus.terraformerCost)));
        TAConfig.shieldFocusImpetusCost = TAConfigManager.addOption(new ConfigOptionLong(false, Long.valueOf(TAConfigHolder.gameplay.impetus.shieldFocusCost)));
        TAConfig.allowWussRiftSeed = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.gameplay.allowWussRiftSeed));
        TAConfig.cannonBeamDamage = TAConfigManager.addOption(new ConfigOptionFloat(false, TAConfigHolder.gameplay.impetus.cannon.beamDamage));
        TAConfig.cannonBeamCost = TAConfigManager.addOption(new ConfigOptionLong(true, Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.beamCost)));
        TAConfig.cannonBeamRange = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.impetus.cannon.beamRange));
        TAConfig.cannonRailgunDamage = TAConfigManager.addOption(new ConfigOptionFloat(false, TAConfigHolder.gameplay.impetus.cannon.railgunDamage));
        TAConfig.cannonRailgunCost = TAConfigManager.addOption(new ConfigOptionLong(true, Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.railgunCost)));
        TAConfig.cannonRailgunCooldown = TAConfigManager.addOption(new ConfigOptionInt(true, TAConfigHolder.gameplay.impetus.cannon.railgunCooldown));
        TAConfig.cannonRailgunRange = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.impetus.cannon.railgunRange));
        TAConfig.cannonBurstDamage = TAConfigManager.addOption(new ConfigOptionFloat(false, TAConfigHolder.gameplay.impetus.cannon.burstDamage));
        TAConfig.cannonBurstCost = TAConfigManager.addOption(new ConfigOptionLong(true, Long.valueOf(TAConfigHolder.gameplay.impetus.cannon.burstCost)));
        TAConfig.cannonBurstCooldown = TAConfigManager.addOption(new ConfigOptionInt(true, TAConfigHolder.gameplay.impetus.cannon.burstCooldown));
        TAConfig.cannonBurstRange = TAConfigManager.addOption(new ConfigOptionDouble(true, TAConfigHolder.gameplay.impetus.cannon.burstRange));
        TAConfig.primalCutterDamage = TAConfigManager.addOption(new ConfigOptionFloat(false, TAConfigHolder.gameplay.primalCutterDamage));
        TAConfig.deniedCategories = TAConfigManager.addOption(new ConfigOptionStringList(true, TAConfigHolder.gameplay.deniedCategories));
        TAConfig.generateSpires = TAConfigManager.addOption(new ConfigOptionBoolean(false, TAConfigHolder.world.generateSpires));
        TAConfig.spireMinDist = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.world.spireMinDist));
        TAConfig.spireSpacing = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.world.spireSpacing));
        TAConfig.experienceModifierCap = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.experienceModifierCap));
        TAConfig.experienceModifierBase = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.experienceModifierBase));
        TAConfig.experienceModifierScale = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.experienceModifierScale));
        TAConfig.elementalModifierPositiveFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.elementalModifierPositiveFactor));
        TAConfig.elementalModifierNegativeFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.elementalModifierNegativeFactor));
        TAConfig.dimensionalModifierOverworldPostiveFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierOverworldPositiveFactor));
        TAConfig.dimensionalModifierOverworldNegativeFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierOverworldNegativeFactor));
        TAConfig.dimensionalModifierOverworldDims = TAConfigManager.addOption(new ConfigOptionIntSet(false, (Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierOverworldDims)));
        TAConfig.dimensionalModifierNetherPostiveFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierNetherPositiveFactor));
        TAConfig.dimensionalModifierNetherNegativeFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierNetherNegativeFactor));
        TAConfig.dimensionalModifierNetherDims = TAConfigManager.addOption(new ConfigOptionIntSet(false, (Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierNetherDims)));
        TAConfig.dimensionalModifierEndPostiveFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierEndPositiveFactor));
        TAConfig.dimensionalModifierEndNegativeFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierEndNegativeFactor));
        TAConfig.dimensionalModifierEndDims = TAConfigManager.addOption(new ConfigOptionIntSet(false, (Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierEndDims)));
        TAConfig.dimensionalModifierEmptinessPostiveFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessPositiveFactor));
        TAConfig.dimensionalModifierEmptinessNegativeFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessNegativeFactor));
        TAConfig.dimensionalModifierEmptinessDims = TAConfigManager.addOption(new ConfigOptionIntSet(false, (Set<Integer>)ImmutableSet.copyOf((Object[])TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessDims)));
        TAConfig.frenzyModifierScaleFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.frenzyModifierScale));
        TAConfig.frenzyModifierCooldown = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.gameplay.augment.frenzyModifierCooldown));
        TAConfig.frenzyModifierMaxLevel = TAConfigManager.addOption(new ConfigOptionInt(false, TAConfigHolder.gameplay.augment.frenzyModifierMaxLevel));
        TAConfig.impetusConductorFactor = TAConfigManager.addOption(new ConfigOptionDouble(false, TAConfigHolder.gameplay.augment.impetusConductorFactor));
    }

    public static class ClientOptions {
        @Config.Name(value="ReducedEffects")
        @Config.Comment(value={"Disables some unneccessary particle effects.", "This includes the special effect of the casted light, as well as most of the particles on the Metaspatial Accumulator/Extruder"})
        public boolean reducedEffects = false;
        @Config.Name(value="OptimizedFluxRiftRenderer")
        @Config.Comment(value={"Overrides Thaumcraft's Flux Rift renderer to use one that is slightly better for performance.", "It probably won't make a major difference as of now, but can help.", "Further work may make this option more useful."})
        @Config.RequiresMcRestart
        public boolean optimizedFluxRiftRenderer = false;
        @Config.Name(value="GauntletCastAnimation")
        @Config.Comment(value={"Enables a simple animation where an entity holds their arm out after casting.", "This is a client-side setting."})
        public boolean gauntletCastAnimation = true;
        @Config.Name(value="EnableImpetusThrusterKeybind")
        @Config.Comment(value={"Allows the Impetus Thruster boost key to be rebindable (with caveats).", "By default, the Impetus Thruster requires holding the jump key to activate it, and is not rebindable.", "This is required to not mess with other mods/content that checks for the jump key, as a normal keybind would conflict.", "However, if you'd rather not use jump for that, enabling this and restarting will make it appear as a normal keybind.", "To properly set it to jump again, you will need to disable this option and restart the game."})
        @Config.RequiresMcRestart
        public boolean enableBoosterKeybind = false;
        @Config.Name(value="DisableShaders")
        @Config.Comment(value={"Disables all shaders used by TA for rendering.", "This will make certain things look ugly, but should prevent issues with shader mods.", "This does not change things for vanilla TC, except for flux rifts if \"OptimizedFluxRiftRenderer\" is enabled."})
        @Config.RequiresMcRestart
        public boolean disableShaders = false;
        @Config.Name(value="MorphicArmorExclusions")
        @Config.Comment(value={"Due to the way Morphic Armor works, some armor items may not play nicely with it.", "This most commonly appears as the armor being invisible in the inventory.", "If that occurs, add its model name here (including variant names, if needed).", "Regular expressions are supported."})
        @Config.RequiresMcRestart
        public String[] morphicArmorExclusions = new String[]{"extrabitmanipulation:moving_part*"};
        @Config.Name(value="DisableCreativeOnlyText")
        @Config.Comment(value={"Removes the \"Creative Only\" text on items that are creative-only normally.", "This is for modpack authors that might want to make these items obtainable."})
        public boolean disableCreativeOnlyText = false;
    }

    public static class WorldOptions {
        @Config.Name(value="EmptinessDimID")
        @Config.Comment(value={"The dimension ID to use for the Emptiness dimension.", "If this ID is already taken, a new one will automatically be assigned."})
        @Config.RequiresMcRestart
        public int emptinessDimID = 14676;
        @Config.Name(value="EmptinessMoveFactor")
        @Config.Comment(value={"The scaling factor applied to distances in the Emptiness dimension.", "For example, the nether has a value of 8 since it multiplies coords by 8.", "Note that move factors for the Emptiness are calculated based on chunk rather than position, so final values", "may be slightly different than expected."})
        public double emptinessMoveFactor = 16.0;
        @Config.Name(value="FractureGenChance")
        @Config.Comment(value={"The chance for a fracture to generate in a chunk in the Emptiness dimension.", "The approximate chance will be 1 / chance (assuming the chunk meets all other conditions).", "Set this to 0 to stop fractures from spawning completely, but be warned that there is no", "other way in Thaumic Augmentation to access the Emptiness in survival."})
        public int fractureGenChance = 35;
        @Config.Name(value="FractureDimList")
        @Config.Comment(value={"Lists the whitelisted dimensions for fractures (not including the Emptiness dim), and their associated weights.", "The format for each line is dim=weight, with higher weights (compared to lower weights) being more likely to spawn.", "This WILL affect worldgen, so use with caution on existing worlds.", "Default dimensions: 0 = Overworld, -1 = Nether, 1 = End, 7 = Twilight Forest, 17 = Atum 2,", "20 = Betweenlands, 111 = Lost Cities, 66 = Erebus, 33 = Wizardry (Underworld)"})
        public String[] fractureDimList = new String[]{"0=35", "-1=15", "1=10", "7=5", "17=5", "20=5", "111=5", "66=5"};
        @Config.Name(value="FractureLocatorUpdateInterval")
        @Config.Comment(value={"How often the location pointed to by the Fracture Locator should be updated, in milliseconds.", "This is a server-side setting."})
        public int fractureLocatorUpdateInterval = 2000;
        @Config.Name(value="ValidFracturesAlwaysTeleport")
        @Config.Comment(value={"If this is set, fractures that previously found a valid location will always teleport the player, even if it is now invalid.", "Normally, fractures check if there is a fracture at the destination to make sure players can get back.", "This is a server-side setting."})
        public boolean fracturesAlwaysTeleport = false;
        @Config.Name(value="DisableEmptinessDimension")
        @Config.Comment(value={"Completely disables the Emptiness dimension, *including* all fracture generation.", "This is not the intended way to experience the mod but is included here for modpack authors.", "This is a server-side setting, but will probably cause problems if the client does not have the same value."})
        @Config.RequiresMcRestart
        public boolean disableEmptiness = false;
        @Config.Name(value="GenerateEldritchSpires")
        @Config.Comment(value={"Allows the Eldritch Spire structure to generate in the Emptiness.", "The spire is intended to be a part of the research progression, so removing it is not recommended.", "The structure will never generate if the Emptiness itself is disabled, or if the structure generation world option is disabled."})
        public boolean generateSpires = true;
        @Config.Name(value="SpireMinDist")
        @Config.Comment(value={"The absolute minimum distance, in chunks, between generated Eldritch Spires."})
        public int spireMinDist = 10;
        @Config.Name(value="SpireSpacing")
        @Config.Comment(value={"The approximate distance, in chunks, between generated Eldritch Spires."})
        public int spireSpacing = 30;
    }

    public static class GameplayOptions {
        @Config.LangKey(value="thaumicaugmentation.text.config.ward")
        public WardOptions ward = new WardOptions();
        @Config.LangKey(value="thaumicaugmentation.text.config.impetus")
        public Impetus impetus = new Impetus();
        @Config.LangKey(value="thaumicaugmentation.text.config.augment")
        public Augment augment = new Augment();
        @Config.Name(value="GauntletVisDiscounts")
        @Config.Comment(value={"The discounts that will be applied to the vis cost of foci used in the thaumium and void metal caster gauntlets."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double[] gauntletVisDiscounts = new double[]{0.1, 0.3};
        @Config.Name(value="GauntletCooldownModifiers")
        @Config.Comment(value={"The multipliers that will be applied to the use cooldowns of the Thaumium and Void Metal caster gauntlets."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double[] gauntletCooldownModifiers = new double[]{0.8, 0.9};
        @Config.Name(value="VoidseerExtraArea")
        @Config.Comment(value={"The extra square area for the voidseer gauntlet, in chunks.", "An area of 3, for example, will mean vis will be taken in a 3x3 chunk area around the caster.", "Note that chunks still need to be loaded to take Vis from them, so the chunk load distance for your", "singleplayer/server is another limiting factor."})
        @Config.RangeInt(min=1, max=32)
        public int voidseerArea = 3;
        @Config.Name(value="VoidBootsLandSpeedBoost")
        @Config.Comment(value={"The boost applied while the wearer is on the ground, and on dry land.", "This is added to the base movement of the player per tick."})
        @Config.RangeDouble(min=0.0, max=10.0)
        public double voidBootsLandSpeedBoost = 0.09;
        @Config.Name(value="VoidBootsWaterSpeedBoost")
        @Config.Comment(value={"The boost applied while the wearer is in water.", "This is added to the base movement of the player per tick."})
        @Config.RangeDouble(min=0.0, max=10.0)
        public double voidBootsWaterSpeedBoost = 0.045;
        @Config.Name(value="VoidBootsJumpBoost")
        @Config.Comment(value={"The boost applied when the wearer jumps.", "This is added to the base jump height of the player."})
        @Config.RangeDouble(min=0.0, max=10.0)
        public double voidBootsJumpBoost = 0.4;
        @Config.Name(value="VoidBootsJumpFactor")
        @Config.Comment(value={"The boost applied to player movement while in the air.", "This itself is a speed, so it can make movement faster in the air than on the ground.", "Note that sprinting's jump modifier uses this value as well."})
        @Config.RangeDouble(min=0.0, max=10.0)
        public double voidBootsJumpFactor = 0.03;
        @Config.Name(value="VoidBootsStepHeight")
        @Config.Comment(value={"The boost applied to the player's step height (while not sneaking).", "This is added to the vanilla default value of 0.6."})
        @Config.RangeDouble(min=0.0, max=10.0)
        public double voidBootsStepHeight = 0.47;
        @Config.Name(value="VoidBootsSneakReduction")
        @Config.Comment(value={"Any speed boosts (not jump) will be divided by this value while sneaking."})
        @Config.RangeDouble(min=1.0, max=10.0)
        public double voidBootsSneakReduction = 4.0;
        @Config.Name(value="ServerSideMovementCalculation")
        @Config.Comment(value={"Makes the server calculate positions and velocities from the Boots of the Riftstrider in addition to the client.", "Normally the client is left to update their position, and the server just takes it from the client.", "Unless your server needs accurate position/velocity info for some reason, don't enable this."})
        public boolean serverMovementCalculation = false;
        @Config.Name(value="DefaultCastingGauntletColors")
        @Config.Comment(value={"The default dye colors for the thaumium and void gauntlets when crafted, in that order.", "The dyed color is multiplied with the color of the texture.", "This is a server-side setting."})
        public int[] defaultGauntletColors = new int[]{8022208, 2498903};
        @Config.Name(value="DefaultVoidBootsColor")
        @Config.Comment(value={"The default dye color for the Boots of the Riftstrider when crafted.", "The dyed color is multiplied with the color of the texture.", "This is a server-side setting."})
        public int defaultVoidBootsColor = 6961280;
        @Config.Name(value="PrimalCutterDamage")
        @Config.Comment(value={"The damage done by the Primal Cutter's material, NOT including the base damage.", "In other words, its total damage will be this number + 4 (3 for being a \"sword\", and 1 as the minimum)"})
        @Config.RequiresMcRestart
        public float primalCutterDamage = 6.0f;
        @Config.Name(value="DeniedResearchCategories")
        @Config.Comment(value={"The list of research categories that Thaumic Augmentation will never willingly give research in.", "Sadly Thaumcraft makes all addons have a research category, even if they don't intend on using it.", "This is why cards like \"experiment\" can give categories that never appear otherwise.", "If you are a TC addon author and you want your mod included/removed from this list, message TheCodex6824 or open an issue/PR on Github."})
        public String[] deniedCategories = new String[]{"THAUMIC_AUGMENTATION", "THAUMIC_TINKERER", "THAUMIC_WONDERS", "RUSTIC_THAUMATURGY", "PERIPHERY", "ENGINEERED_GOLEMS", "EXPANDEDARCANUM", "MECHANICS"};
        @Config.Name(value="AllowWussRiftSeed")
        @Config.Comment(value={"Allows rift seeds to create Flux Rifts, even if Thaumcraft's wuss mode is enabled."})
        public boolean allowWussRiftSeed = false;

        public static class Augment {
            @Config.Name(value="ExperienceModifierCap")
            @Config.Comment(value={"The maximum benefit the Experience Modifier can provide."})
            public double experienceModifierCap = 2.0;
            @Config.Name(value="ExperienceModifierBase")
            @Config.Comment(value={"The minimum benefit the Experience Modifier can provide.", "1.0 is no benefit, and lower values will reduce effectiveness."})
            public double experienceModifierBase = 1.0;
            @Config.Name(value="ExperienceModifierScaleFactor")
            @Config.Comment(value={"The number the player's level is multiplied by, before being clamped.", "In other words, this controls how many levels it takes to reach the maximum value."})
            public double experienceModifierScale = 0.04;
            @Config.Name(value="ElementalModifierPostiveFactor")
            @Config.Comment(value={"The number to be multiplied into the total effectiveness of the Elemental Modifier for a postive aspect."})
            public double elementalModifierPositiveFactor = 1.75;
            @Config.Name(value="ElementalModifierNegativeFactor")
            @Config.Comment(value={"The number to be multiplied into the total effectiveness of the Elemental Modifier for a postive aspect."})
            public double elementalModifierNegativeFactor = 0.75;
            @Config.Name(value="DimensionalModifierOverworldPostiveFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the correct dimension."})
            public double dimensionalModifierOverworldPositiveFactor = 1.25;
            @Config.Name(value="DimensionalModifierOverworldNegativeFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the incorrect dimension."})
            public double dimensionalModifierOverworldNegativeFactor = 1.0;
            @Config.Name(value="DimensionalModifierOverworldDims")
            @Config.Comment(value={"The list of dimensions that should count as being in the Overworld for the overworld modifier."})
            public Integer[] dimensionalModifierOverworldDims = new Integer[]{0};
            @Config.Name(value="DimensionalModifierNetherPostiveFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the correct dimension."})
            public double dimensionalModifierNetherPositiveFactor = 1.5;
            @Config.Name(value="DimensionalModifierNetherNegativeFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the incorrect dimension."})
            public double dimensionalModifierNetherNegativeFactor = 1.0;
            @Config.Name(value="DimensionalModifierNetherDims")
            @Config.Comment(value={"The list of dimensions that should count as being in the Nether for the overworld modifier."})
            public Integer[] dimensionalModifierNetherDims = new Integer[]{-1};
            @Config.Name(value="DimensionalModifierEndPostiveFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the correct dimension."})
            public double dimensionalModifierEndPositiveFactor = 1.5;
            @Config.Name(value="DimensionalModifierEndNegativeFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the incorrect dimension."})
            public double dimensionalModifierEndNegativeFactor = 1.0;
            @Config.Name(value="DimensionalModifierEndDims")
            @Config.Comment(value={"The list of dimensions that should count as being in the End for the overworld modifier."})
            public Integer[] dimensionalModifierEndDims = new Integer[]{1};
            @Config.Name(value="DimensionalModifierEmptinessPostiveFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the correct dimension."})
            public double dimensionalModifierEmptinessPositiveFactor = 1.5;
            @Config.Name(value="DimensionalModifierEmptinessNegativeFactor")
            @Config.Comment(value={"The strength of the dimensional modifier in the incorrect dimension."})
            public double dimensionalModifierEmptinessNegativeFactor = 1.0;
            @Config.Name(value="DimensionalModifierEmptinessDims")
            @Config.Comment(value={"The list of dimensions that should count as being in the Emptiness for the overworld modifier.", "If the game automatically changes the Emptiness dim ID, it will be updated here,", "otherwise, you will need to specify it manually if changed."})
            public Integer[] dimensionalModifierEmptinessDims = new Integer[]{14676};
            @Config.Name(value="FrenzyModifierCooldown")
            @Config.Comment(value={"The amount of ticks without hurting things until the frenzy boost wears off."})
            public int frenzyModifierCooldown = 100;
            @Config.Name(value="FrenzyModifierScaleFactor")
            @Config.Comment(value={"The number the player's frenzy level is multiplied by, before being clamped.", "In other words, this controls how many levels it takes to reach the maximum value,", "and what that maximum value is."})
            public double frenzyModifierScale = 0.05;
            @Config.Name(value="FrenzyModifierMaxLevel")
            @Config.Comment(value={"The maximum frenzy level allowed."})
            public int frenzyModifierMaxLevel = 15;
            @Config.Name(value="ImpetusConductorFactor")
            @Config.Comment(value={"The amount the focus power is multiplied by when the gauntlet has a charged Impetus Conductor."})
            public double impetusConductorFactor = 1.1;
        }

        public static class Impetus {
            @Config.LangKey(value="thaumicaugmentation.text.config.impulse_cannon")
            public ImpulseCannon cannon = new ImpulseCannon();
            @Config.Name(value="TerraformerCost")
            @Config.Comment(value={"The amount of Impetus the Arcane Terraformer consumes per block terraformed."})
            public int terraformerCost = 5;
            @Config.Name(value="ShieldFocusCost")
            @Config.Comment(value={"The amount of Impetus the Void Shield focus effect consumes to create the shield.", "Note that a proportion of this amount will be consumed to heal a damaged shield."})
            public int shieldFocusCost = 10;

            public static class ImpulseCannon {
                @Config.Name(value="BeamDamage")
                @Config.Comment(value={"The amount of damage that the Impulse Cannon's beam attack does.", "The beam attack is the default attack with no augments.", "The beam does not reset the damage cooldowns of entities damaged by it,", "so while this damage can theoretically be seen per tick, in practice this is", "extremely unlikely and would take a large crowd and good aim to achieve."})
                public float beamDamage = 7.0f;
                @Config.Name(value="BeamCost")
                @Config.Comment(value={"The amount of Impetus used by the Impulse Cannon's beam attack per tick.", "This cost is paid even if nothing is being hit by the beam."})
                public int beamCost = 1;
                @Config.Name(value="BeamRange")
                @Config.Comment(value={"The range in meters of the Impulse Cannon's beam attack."})
                public double beamRange = 32.0;
                @Config.Name(value="RailgunDamage")
                @Config.Comment(value={"The amount of damage that the Impulse Cannon's railgun attack does.", "Note that the beam can pierce through multiple entities, but not blocks."})
                public float railgunDamage = 30.0f;
                @Config.Name(value="RailgunCost")
                @Config.Comment(value={"The amount of Impetus used by the Impulse Cannon's railgun attack per shot.", "This cost is paid even if nothing is being hit by the shot."})
                public int railgunCost = 5;
                @Config.Name(value="RailgunCooldown")
                @Config.Comment(value={"The cooldown in ticks between shots of the Impulse Cannon in railgun mode.", "Note that this will lock the player out of all Impulse Cannons in their inventory for", "this duration."})
                public int railgunCooldown = 100;
                @Config.Name(value="RailgunRange")
                @Config.Comment(value={"The range in meters of the Impulse Cannon's railgun attack."})
                public double railgunRange = 64.0;
                @Config.Name(value="BurstDamage")
                @Config.Comment(value={"The amount of damage that the Impulse Cannon's burst attack does per shot.", "Note that the damage cooldown of an entity hit by the first 2 rounds of the burst is reset", "to allow the other rounds to do damage.", "Since there are three shots fired by the burst, the effective damage is three times this value."})
                public float burstDamage = 8.0f;
                @Config.Name(value="BurstCost")
                @Config.Comment(value={"The amount of Impetus used by the Impulse Cannon's burst attack per burst.", "This cost is paid even if nothing is being hit by the shot."})
                public int burstCost = 4;
                @Config.Name(value="BurstCooldown")
                @Config.Comment(value={"The cooldown in ticks between shots of the Impulse Cannon in burst mode.", "Note that this will lock the player out of all Impulse Cannons in their inventory for", "this duration."})
                public int burstCooldown = 26;
                @Config.Name(value="BurstRange")
                @Config.Comment(value={"The range in meters of the Impulse Cannon's burst attack."})
                public double burstRange = 24.0;
            }
        }

        public static class WardOptions {
            @Config.Name(value="AllowSingleplayerWardOverride")
            @Config.Comment(value={"Allows you to always be able to interact with or destroy any warded block/tile while in singleplayer.", "For multiplayer see AllowOPWardOverride."})
            public boolean singlePlayerWardOverride = false;
            @Config.Name(value="AllowOPWardOverride")
            @Config.Comment(value={"Allow server operators to always be able to interact with or destroy any warded block/tile.", "For singleplayer see AllowSingleplayerWardOverride."})
            public boolean opWardOverride = false;
            @Config.Name(value="DisableWardFocus")
            @Config.Comment(value={"Disables the ward focus. This will remove the research entry, disable existing wards, and make existing foci do nothing.", "This is a server-side setting, although the ward research may not sync properly if the value is not the same on both sides."})
            @Config.RequiresMcRestart
            public boolean disableWardFocus = false;
            @Config.Name(value="WardTileMode")
            @Config.Comment(value={"Optionally allows tile entities to be warded in addition to normal blocks.", "While \"all\" and \"none\" should be self explanatory, \"notick\" will", "only allow tiles that do not tick (aka do not implement ITickable).", "Allowing all tiles may be very overpowered - use at your own risk!"})
            public TAConfig.TileWardMode tileWardMode = TAConfig.TileWardMode.NOTICK;
        }
    }

    public static class GeneralOptions {
        @Config.Name(value="DisableCoremod")
        @Config.Comment(value={"Completely disables the Thaumic Augmentation coremod.", "It will still appear in the list of loaded coremods, but won't do anything.", "The coremod is a neccessary evil to get warded blocks to behave properly with other mods,", "as well as work around other vanilla and Thaumcraft issues."})
        @Config.RequiresMcRestart
        public boolean disableCoremod = false;
        @Config.Name(value="DisabledTransformers")
        @Config.Comment(value={"An optional list of coremod class transformers to disable.", "For advanced users / modpack makers that encounter issues with only a subset of the coremod.", "This takes the fully qualified class name of THE TRANSFORMER CLASS ITSELF, and only does anything if the coremod itself is enabled.", "An example would be adding \"thecodex6824.thaumicaugmentation.core.transformer.TransformerBipedRotationCustomTCArmor\" without quotes", "to disable the modifications to Thaumcraft's ModelCustomArmor.", "If you do have to add exclusions here, reporting the issues as well would be greatly appreciated."})
        @Config.RequiresMcRestart
        public String[] disabledTransformers = new String[0];
    }
}

