/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.block.property.door.IArcaneDoorHalf;
import thecodex6824.thaumicaugmentation.api.block.property.door.IArcaneDoorOpen;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileArcaneTrapdoor;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockArcaneTrapdoor
extends BlockTABase
implements IHorizontallyDirectionalBlock,
IArcaneDoorHalf,
IArcaneDoorOpen,
IItemBlockProvider,
IUnwardableBlock,
IWardParticles {
    protected static final AxisAlignedBB EAST_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_OPEN_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    public BlockArcaneTrapdoor(Material type) {
        super(type);
        this.func_149722_s();
        this.func_149752_b(2.1267647E37f);
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)IArcaneDoorHalf.ArcaneDoorHalf.LOWER));
        state = state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(false));
        state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.SOUTH);
        this.func_180632_j(state);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ARCANE;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IArcaneDoorHalf.DOOR_HALF, IHorizontallyDirectionalBlock.DIRECTION, IArcaneDoorOpen.DOOR_OPEN});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)) {
                default: {
                    return NORTH_OPEN_AABB;
                }
                case SOUTH: {
                    return SOUTH_OPEN_AABB;
                }
                case WEST: {
                    return WEST_OPEN_AABB;
                }
                case EAST: 
            }
            return EAST_OPEN_AABB;
        }
        if (state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.UPPER) {
            return TOP_AABB;
        }
        return BOTTOM_AABB;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) == false;
    }

    protected SoundEvent getOpenSound(IBlockState state) {
        return this.field_149764_J == Material.field_151573_f ? SoundEvents.field_187617_cK : SoundEvents.field_187879_gP;
    }

    protected SoundEvent getCloseSound(IBlockState state) {
        return this.field_149764_J == Material.field_151573_f ? SoundEvents.field_187614_cJ : SoundEvents.field_187877_gO;
    }

    public SoundType func_185467_w() {
        return this.field_149764_J == Material.field_151573_f ? SoundType.field_185852_e : SoundType.field_185848_a;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IWardedTile warded;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && warded.hasPermission((EntityLivingBase)player)) {
            state = state.func_177231_a((IProperty)IArcaneDoorOpen.DOOR_OPEN);
            world.func_180501_a(pos, state, 10);
            world.func_175704_b(pos, pos);
            world.func_184133_a(null, pos, (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN) != false ? this.getOpenSound(state) : this.getCloseSound(state), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)(!BitUtil.isBitSet(meta, 0) ? IArcaneDoorHalf.ArcaneDoorHalf.LOWER : IArcaneDoorHalf.ArcaneDoorHalf.UPPER)));
        state = state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 1)));
        state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_176731_b((int)BitUtil.getBits(meta, 2, 4)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta = BitUtil.setBit(meta, 0, state.func_177229_b(IArcaneDoorHalf.DOOR_HALF) == IArcaneDoorHalf.ArcaneDoorHalf.UPPER);
        meta = BitUtil.setBit(meta, 1, (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN));
        meta = BitUtil.setBits(meta, 2, 4, ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_176736_b());
        return meta;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P();
        if (facing.func_176740_k().func_176722_c()) {
            state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)facing).func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(false));
            state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)(hitY > 0.5f ? IArcaneDoorHalf.ArcaneDoorHalf.UPPER : IArcaneDoorHalf.ArcaneDoorHalf.LOWER)));
        } else {
            state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(false));
            state = state.func_177226_a(IArcaneDoorHalf.DOOR_HALF, (Comparable)((Object)(facing == EnumFacing.UP ? IArcaneDoorHalf.ArcaneDoorHalf.LOWER : IArcaneDoorHalf.ArcaneDoorHalf.UPPER)));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IWardedTile warded;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            warded.setOwner(placer.func_110124_au());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean shouldOpen;
        TileArcaneTrapdoor trapdoor;
        IWardedTile warded;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileArcaneTrapdoor && (warded = (trapdoor = (TileArcaneTrapdoor)tile).getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && (shouldOpen = WardHelper.isOpenedByWardOpeningBlock(world, pos, warded.getOwner())) != trapdoor.isPowered()) {
            trapdoor.setPowered(shouldOpen);
            if (shouldOpen != (Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)IArcaneDoorOpen.DOOR_OPEN, (Comparable)Boolean.valueOf(shouldOpen)), 2);
                world.func_184133_a(null, pos, shouldOpen ? this.getOpenSound(state) : this.getCloseSound(state), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        IBlockState down;
        if (((Boolean)state.func_177229_b((IProperty)IArcaneDoorOpen.DOOR_OPEN)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c().isLadder(down, world, pos.func_177977_b(), entity) && down.func_177227_a().contains(BlockLadder.field_176382_a)) {
            return down.func_177229_b((IProperty)BlockLadder.field_176382_a) == state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
        }
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileArcaneTrapdoor();
    }
}

