/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import thaumcraft.api.blocks.BlocksTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.block.property.IImpetusCellInfo;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.item.block.ItemBlockNoImpetusNodeNBT;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMatrix;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;

public class BlockImpetusMatrix
extends BlockTABase
implements IItemBlockProvider {
    public BlockImpetusMatrix() {
        super(Material.field_151576_e);
        this.func_149711_c(7.5f);
        this.func_149752_b(500.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockNoImpetusNodeNBT(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ELDRITCH;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{Properties.AnimationProperty}).build();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileImpetusMatrix) {
            return ((TileImpetusMatrix)tile).getComparatorOutput();
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileImpetusMatrix();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(BlocksTC.infusionMatrix));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity t;
        int cellCount;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX_BASE) {
            cellCount = IImpetusCellInfo.getNumberOfCells((Integer)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
            if (cellCount > 0) {
                BlockImpetusMatrix.func_180635_a((World)world, (BlockPos)pos.func_177977_b(), (ItemStack)new ItemStack(TAItems.MATERIAL, cellCount, 3));
            }
            world.func_175656_a(pos.func_177977_b(), BlocksTC.pedestalEldritch.func_176223_P());
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == TABlocks.IMPETUS_MATRIX_BASE) {
            cellCount = IImpetusCellInfo.getNumberOfCells((Integer)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
            if (cellCount > 0) {
                BlockImpetusMatrix.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)new ItemStack(TAItems.MATERIAL, cellCount, 3));
            }
            world.func_175656_a(pos.func_177984_a(), BlocksTC.pedestalEldritch.func_176223_P());
        }
        if ((t = world.func_175625_s(pos)) instanceof IBreakCallback) {
            ((IBreakCallback)t).onBlockBroken();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

