/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import thaumcraft.api.blocks.BlocksTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.block.property.IImpetusCellInfo;
import thecodex6824.thaumicaugmentation.api.block.property.IVerticallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMatrix;

public class BlockImpetusMatrixBase
extends BlockTABase
implements IImpetusCellInfo,
IItemBlockProvider {
    public BlockImpetusMatrixBase() {
        super(Material.field_151576_e);
        this.func_149711_c(7.5f);
        this.func_149752_b(500.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ELDRITCH;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{IImpetusCellInfo.CELL_INFO}).add(new IProperty[]{IVerticallyDirectionalBlock.DIRECTION}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)IVerticallyDirectionalBlock.DIRECTION, (Comparable)(world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX ? EnumFacing.DOWN : EnumFacing.UP));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX) {
            TileEntity tile2 = world.func_175625_s(pos.func_177977_b());
            if (tile2 instanceof TileImpetusMatrix) {
                return ((TileImpetusMatrix)tile2).getComparatorOutput();
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == TABlocks.IMPETUS_MATRIX && (tile = world.func_175625_s(pos.func_177984_a())) instanceof TileImpetusMatrix) {
            return ((TileImpetusMatrix)tile).getComparatorOutput();
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (facing.func_176736_b() > -1) {
            int value = (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
            EnumFacing enumFacing = facing = facing.func_176740_k() == EnumFacing.Axis.Z && world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX ? facing.func_176734_d() : facing;
            if (!IImpetusCellInfo.isCellPresent((Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO), facing) && hand != null && !player.func_184586_b(hand).func_190926_b()) {
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() == TAItems.MATERIAL && stack.func_77960_j() == 3) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    world.func_175656_a(pos, state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(value, facing, true))));
                    world.func_184133_a(null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else if (IImpetusCellInfo.isCellPresent((Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO), facing) && hand != null && (player.func_184586_b(hand).func_190926_b() || ItemStack.func_179545_c((ItemStack)player.func_184586_b(hand), (ItemStack)new ItemStack(TAItems.MATERIAL, 1, 3)))) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(value, facing, false))));
                world.func_184133_a(null, pos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(TAItems.MATERIAL, 1, 3));
                } else if (player.func_184586_b(hand).func_190916_E() < player.func_184586_b(hand).func_77976_d()) {
                    player.func_184586_b(hand).func_190917_f(1);
                } else {
                    world.func_72838_d(TAItems.MATERIAL.createEntity(world, (Entity)player, new ItemStack(TAItems.MATERIAL, 1, 3)));
                }
                return true;
            }
        }
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(BlocksTC.pedestalEldritch));
        int cells = IImpetusCellInfo.getNumberOfCells((Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
        if (cells > 0) {
            drops.add((Object)new ItemStack(TAItems.MATERIAL, cells, 3));
        }
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX) {
            world.func_175656_a(pos.func_177977_b(), BlocksTC.infusionMatrix.func_176223_P());
            if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this) {
                int cellCount = IImpetusCellInfo.getNumberOfCells((Integer)world.func_180495_p(pos.func_177979_c(2)).func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
                if (cellCount > 0) {
                    BlockImpetusMatrixBase.func_180635_a((World)world, (BlockPos)pos.func_177979_c(2), (ItemStack)new ItemStack(TAItems.MATERIAL, cellCount, 3));
                }
                world.func_175656_a(pos.func_177979_c(2), BlocksTC.pedestalEldritch.func_176223_P());
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == TABlocks.IMPETUS_MATRIX) {
            world.func_175656_a(pos.func_177984_a(), BlocksTC.infusionMatrix.func_176223_P());
            if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this) {
                int cellCount = IImpetusCellInfo.getNumberOfCells((Integer)world.func_180495_p(pos.func_177981_b(2)).func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
                if (cellCount > 0) {
                    BlockImpetusMatrixBase.func_180635_a((World)world, (BlockPos)pos.func_177981_b(2), (ItemStack)new ItemStack(TAItems.MATERIAL, cellCount, 3));
                }
                world.func_175656_a(pos.func_177981_b(2), BlocksTC.pedestalEldritch.func_176223_P());
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP && world.func_180495_p(pos.func_177977_b()).func_177230_c() == TABlocks.IMPETUS_MATRIX) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c() == TABlocks.IMPETUS_MATRIX) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

