/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.block.property.IConnected;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMirror;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockImpetusMirror
extends BlockTABase
implements IDirectionalBlock {
    protected static final AxisAlignedBB DOWN_BOX = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB UP_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockImpetusMirror() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundsTC.JAR);
        this.func_149711_c(0.1f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.UP));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IDirectionalBlock.DIRECTION, IConnected.CONNECTED});
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundsTC.JAR;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_82600_a((int)BitUtil.getBits(meta, 0, 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176745_a();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)facing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean value = false;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileImpetusMirror) {
            value = ((TileImpetusMirror)tile).shouldShowOpenMirror();
        }
        return state.func_177226_a((IProperty)IConnected.CONNECTED, (Comparable)Boolean.valueOf(value));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing dir = ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d();
        if (!world.func_180495_p(pos.func_177972_a(dir)).isSideSolid((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof IBreakCallback) {
            ((IBreakCallback)t).onBlockBroken();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos test = pos.func_177972_a(side.func_176734_d());
        return world.func_180495_p(test).isSideSolid((IBlockAccess)world, test, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            case DOWN: {
                return DOWN_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case NORTH: {
                return NORTH_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
        }
        return UP_BOX;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileImpetusMirror();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

