/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftFeeder;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockRiftFeeder
extends BlockTABase
implements IDirectionalBlock,
IEnabledBlock,
IItemBlockProvider {
    public BlockRiftFeeder() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(15.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)IEnabledBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ELDRITCH;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IDirectionalBlock.DIRECTION, IEnabledBlock.ENABLED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_82600_a((int)BitUtil.getBits(meta, 0, 3))).func_177226_a((IProperty)IEnabledBlock.ENABLED, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 3)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176745_a();
        meta = BitUtil.setBit(meta, 3, (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED));
        return meta;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing direction = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        if (placer.func_70093_af()) {
            direction = direction.func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)direction);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    protected void update(IBlockState state, World world, BlockPos pos) {
        boolean powered = world.func_175640_z(pos);
        if (powered == (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED)) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)IEnabledBlock.ENABLED), 3);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.update(state, world, pos);
        super.func_176213_c(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.update(state, world, pos);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileRiftFeeder();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

