/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpeningBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileWardedPressurePlate;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockWardedPressurePlate
extends BlockTABase
implements IWardOpeningBlock,
IItemBlockProvider,
IUnwardableBlock,
IWardParticles {
    protected static final AxisAlignedBB PRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    protected static final AxisAlignedBB UNPRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    protected static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    protected final BlockPressurePlate.Sensitivity sens;

    public BlockWardedPressurePlate(Material material, BlockPressurePlate.Sensitivity sensitivity, SoundType sound) {
        super(material);
        this.sens = sensitivity;
        this.func_149672_a(sound);
        this.func_149722_s();
        this.func_149752_b(2.1267647E37f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ARCANE;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IWardOpeningBlock.WARD_OPENING});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING) != false ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    protected void playPressSound(World world, BlockPos pos) {
        if (this.field_149764_J == Material.field_151575_d) {
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void playReleaseSound(World world, BlockPos pos) {
        if (this.field_149764_J == Material.field_151575_d) {
            world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    protected boolean isEntityValid(Entity firstEntity, IWardedTile owner) {
        HashSet<Entity> visited = new HashSet<Entity>();
        ArrayDeque<Object> toCheck = new ArrayDeque<Object>();
        toCheck.add(firstEntity);
        do {
            Entity e;
            if (visited.contains(e = (Entity)toCheck.pop())) continue;
            visited.add(e);
            if (e instanceof EntityLivingBase && owner.hasPermission((EntityLivingBase)e)) {
                return true;
            }
            if (e instanceof EntityArrow && ((EntityArrow)e).field_70250_c != null) {
                toCheck.add(((EntityArrow)e).field_70250_c);
                continue;
            }
            if (e instanceof EntityThrowable && ((EntityThrowable)e).field_70192_c != null) {
                toCheck.add(((EntityThrowable)e).field_70192_c);
                continue;
            }
            if (!(e instanceof EntityFireball) || ((EntityFireball)e).field_70235_a == null) continue;
            toCheck.add(((EntityFireball)e).field_70235_a);
        } while (!toCheck.isEmpty());
        return false;
    }

    protected boolean shouldBePressed(World world, BlockPos pos, IBlockState state) {
        IWardedTile warded;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            List list = null;
            list = this.sens == BlockPressurePlate.Sensitivity.EVERYTHING ? world.func_175647_a(Entity.class, PRESSURE_AABB.func_186670_a(pos), e -> this.isEntityValid((Entity)e, warded)) : world.func_175647_a(EntityLivingBase.class, PRESSURE_AABB.func_186670_a(pos), e -> this.isEntityValid((Entity)e, warded));
            for (Entity e2 : list) {
                if (e2.func_145773_az()) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateState(World world, BlockPos pos, IBlockState state) {
        boolean isPressed;
        boolean wasPressed = (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING);
        if (wasPressed != (isPressed = this.shouldBePressed(world, pos, state))) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(isPressed)), 2);
            world.func_175685_c(pos, (Block)this, false);
            world.func_175704_b(pos, pos);
        }
        if (!isPressed && wasPressed) {
            this.playReleaseSound(world, pos);
        } else if (isPressed && !wasPressed) {
            this.playPressSound(world, pos);
        }
        if (isPressed) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            this.updateState(world, pos, state);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            this.updateState(world, pos, state);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            world.func_175685_c(pos, (Block)this, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING) != false ? 15 : 0;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IWardedTile warded;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            warded.setOwner(placer.func_110124_au());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWardedPressurePlate();
    }
}

