/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.capability;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.ICaster;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.Augment;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;

public class AugmentCasterVisBattery
extends Augment {
    protected boolean syncNeeded;
    protected float vis;

    public float getMaxVis() {
        return 40.0f;
    }

    public float getVis() {
        return this.vis;
    }

    public void setVis(float newVis) {
        this.vis = newVis;
        this.syncNeeded = true;
    }

    @Override
    public boolean canBeAppliedToItem(ItemStack augmentable) {
        return augmentable.func_77973_b() instanceof ICaster;
    }

    @Override
    public boolean isCompatible(ItemStack otherAugment) {
        return otherAugment.func_77973_b() != TAItems.AUGMENT_VIS_BATTERY;
    }

    @Override
    public boolean onCastPre(ItemStack caster, FocusWrapper focusPackage, Entity user) {
        float difference = AuraHelper.getVis((World)user.func_130014_f_(), (BlockPos)user.func_180425_c()) - focusPackage.getVisCost();
        if (difference < 0.0f) {
            float extract = Math.min(-difference, this.vis);
            this.vis -= extract;
            focusPackage.setVisCost(focusPackage.getVisCost() - extract);
            this.syncNeeded = true;
        }
        return false;
    }

    @Override
    public boolean onTick(Entity user) {
        float inAura;
        float max = this.getMaxVis();
        if (!user.func_130014_f_().field_72995_K && user.func_130014_f_().func_82737_E() % 10L == 0L && this.vis < max && (inAura = AuraHelper.getVis((World)user.func_130014_f_(), (BlockPos)user.func_180425_c())) > (float)AuraHelper.getAuraBase((World)user.func_130014_f_(), (BlockPos)user.func_180425_c()) * 0.75f) {
            float input = Math.min(max - this.vis, Math.min(inAura, 1.0f));
            this.vis += AuraHelper.drainVis((World)user.func_130014_f_(), (BlockPos)user.func_180425_c(), (float)input, (boolean)false);
            this.syncNeeded = true;
        }
        return false;
    }

    @Override
    public boolean shouldSync() {
        boolean sync = this.syncNeeded;
        this.syncNeeded = false;
        return sync;
    }

    @Override
    public boolean hasAdditionalAugmentTooltip() {
        return true;
    }

    @Override
    public void appendAdditionalAugmentTooltip(List<String> tooltip) {
        tooltip.add(new TextComponentString(new TextComponentTranslation("tc.charge", new Object[0]).func_150254_d() + " " + Math.round(this.vis)).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150254_d());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("vis", this.vis);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.vis = nbt.func_74760_g("vis");
    }
}

