/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import thaumcraft.api.casters.FocusMediumRoot;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.casters.foci.FocusEffectAir;
import thaumcraft.common.items.casters.foci.FocusEffectCurse;
import thaumcraft.common.items.casters.foci.FocusEffectEarth;
import thaumcraft.common.items.casters.foci.FocusEffectFire;
import thaumcraft.common.items.casters.foci.FocusEffectFlux;
import thaumcraft.common.items.casters.foci.FocusEffectFrost;
import thaumcraft.common.items.casters.foci.FocusMediumBolt;
import thaumcraft.common.items.casters.foci.FocusMediumProjectile;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocasterBase;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectWater;
import thecodex6824.thaumicaugmentation.common.util.WeightedRandom;

public class EntityAutocasterEldritch
extends EntityAutocasterBase
implements IMob,
IEldritchMob {
    protected static final ImmutableList<Integer> FOCUS_RANGE = ImmutableList.copyOf((Collection)IntStream.range(0, 7).boxed().collect(Collectors.toList()));
    protected static final String[] PREFIXES = new String[]{"c", "f'", "h'", "na", "nafl", "ng", "nnn", "ph'", "y"};
    protected static final String[] SUFFIXES = new String[]{"agl", "nyth", "og", "oth"};
    protected static final String[] CONJUNCTIONS = new String[]{"mg"};
    protected static final String[] WORDS = new String[]{"ah", "'ai", "athg", "'bthnk", "bug", "ch'", "chtenff", "ebumna", "ee", "ehye", "ep", "'fhalma", "fhtagn", "fm'latgh", "ftaghu", "geb", "gnaiih", "gof'nn", "goka", "gotha", "grah'n", "hafh'drn", "hai", "hlirgh", "hrii", "hupadgh", "ilyaa", "k'yarnak", "kadishtu", "kn'a", "li'hee", "llll", "lloig", "lw'nafh", "mnahn'", "n'gha", "n'ghft", "nglui", "nilgh'ri", "nog", "nw", "ooboshu", "orr'e", "phlegeth", "r'luh", "ron", "s'uhn", "sgn'wahl", "shagg", "shogg", "shtunggli", "shugg", "sll'ha", "stell'bsna", "syha'h", "tharanak", "throd", "uaaah", "uh'e", "uln", "vulgtlagln", "vulgtm", "wgah'n", "y'hah", "ya", "zhro"};

    public EntityAutocasterEldritch(World world) {
        super(world);
        this.field_70728_aV = 15;
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.01f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAutocasterBase.EntityAIWatchTarget());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityEldritchWarden.class, 12.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityEldritchGolem.class, 12.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityEldritchGuardian.class, 12.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistLeader.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalGreater.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalLesser.class, true));
    }

    protected void addWord(Random rand, StringBuilder builder) {
        if (rand.nextInt(5) == 0) {
            builder.append(PREFIXES[rand.nextInt(PREFIXES.length)]);
        }
        builder.append(WORDS[rand.nextInt(WORDS.length)]);
        if (rand.nextInt(5) == 0) {
            builder.append(SUFFIXES[rand.nextInt(SUFFIXES.length)]);
        }
    }

    protected String getRandomFocusName(Random rand) {
        int words = rand.nextInt(10);
        words = words == 9 ? 3 : (words >= 2 ? 2 : 1);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < words; ++i) {
            this.addWord(rand, str);
            if (i == words - 1) continue;
            str.append(" ");
            if (rand.nextInt(5) != 0) continue;
            str.append(CONJUNCTIONS[rand.nextInt(CONJUNCTIONS.length)] + " ");
        }
        return str.toString();
    }

    protected FocusNode generateEffectForDifficulty(DifficultyInstance difficulty, Random rand, FocusNode medium) {
        ImmutableList weights = ImmutableList.of((Object)2, (Object)2, (Object)2, (Object)2, (Object)1, (Object)1, (Object)this.field_70170_p.func_175659_aa().func_151525_a());
        WeightedRandom<Integer> picker = new WeightedRandom<Integer>((List<Integer>)FOCUS_RANGE, (List<Integer>)weights);
        Object effect = null;
        switch (picker.get(rand)) {
            case 0: {
                effect = new FocusEffectAir();
                effect.getSetting("power").setValue(5);
                break;
            }
            case 1: {
                effect = new FocusEffectEarth();
                effect.getSetting("power").setValue(5);
                break;
            }
            case 2: {
                effect = new FocusEffectFire();
                effect.getSetting("power").setValue(5);
                effect.getSetting("duration").setValue(rand.nextInt(3) + 3);
                break;
            }
            case 3: {
                effect = new FocusEffectFrost();
                effect.getSetting("power").setValue(5);
                effect.getSetting("duration").setValue(rand.nextInt(6) + 5);
                break;
            }
            case 4: {
                effect = new FocusEffectWater();
                effect.getSetting("power").setValue(5);
                break;
            }
            case 5: {
                FocusMediumProjectile p;
                effect = new FocusEffectCurse();
                effect.getSetting("power").setValue(5);
                int durationOffset = 5;
                if (medium instanceof FocusMediumProjectile && (p = (FocusMediumProjectile)medium).getSetting("speed").getValue() == 5 && p.getSetting("option").getValue() == 2) {
                    durationOffset = 4;
                }
                effect.getSetting("duration").setValue(rand.nextInt(6) + durationOffset);
                break;
            }
            default: {
                effect = new FocusEffectFlux();
                effect.getSetting("power").setValue(5);
            }
        }
        return effect;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return this.onInitialSpawn(difficulty, livingdata, false);
    }

    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata, boolean randomFocus) {
        if (!this.field_70170_p.field_72995_K) {
            Random random = null;
            if (!randomFocus) {
                random = new Random(this.field_70170_p.func_72905_C());
                long xSeed = random.nextLong();
                long ySeed = random.nextLong();
                long zSeed = random.nextLong();
                random.setSeed(xSeed * (long)((int)this.field_70165_t) + ySeed * (long)((int)this.field_70163_u) + zSeed * (long)((int)this.field_70161_v) ^ this.field_70170_p.func_72905_C());
            } else {
                random = this.field_70146_Z;
            }
            ItemStack focus = new ItemStack(TAItems.FOCUS_ANCIENT);
            FocusPackage core = new FocusPackage();
            FocusMediumRoot root = new FocusMediumRoot();
            core.addNode((IFocusElement)root);
            FocusMediumBolt medium = null;
            if (random.nextBoolean()) {
                medium = new FocusMediumBolt();
            } else {
                medium = new FocusMediumProjectile();
                medium.getSetting("speed").setValue(random.nextInt(3) + 3);
                int special = random.nextInt(10);
                if (special >= 8) {
                    medium.getSetting("option").setValue(2);
                } else if (special >= 6) {
                    medium.getSetting("option").setValue(1);
                }
            }
            medium.setParent((FocusNode)root);
            core.addNode((IFocusElement)medium);
            FocusNode effect = this.generateEffectForDifficulty(difficulty, random, (FocusNode)medium);
            effect.setParent((FocusNode)medium);
            core.addNode((IFocusElement)effect);
            focus.func_151001_c(this.getRandomFocusName(random));
            int complexity = 0;
            Object2IntOpenHashMap nodeCounts = new Object2IntOpenHashMap(core.nodes.size());
            for (IFocusElement node : core.nodes) {
                if (!(node instanceof FocusNode)) continue;
                int count = (Integer)nodeCounts.getOrDefault((Object)node.getKey(), (Object)0) + 2;
                double complexityMultiplier = 0.5 * (double)count;
                nodeCounts.addTo((Object)node.getKey(), 1);
                complexity = (int)((double)complexity + (double)((FocusNode)node).getComplexity() * complexityMultiplier);
            }
            core.setComplexity(complexity);
            ItemFocus.setPackage((ItemStack)focus, (FocusPackage)core);
            this.func_184611_a(EnumHand.MAIN_HAND, focus);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
    }

    public int func_70658_aO() {
        return 8;
    }

    public boolean func_184191_r(Entity entity) {
        if (this.func_96124_cp() != null) {
            return super.func_184191_r(entity);
        }
        return entity instanceof IEldritchMob;
    }

    @Override
    protected void dropItemFromPlacement() {
    }

    @Override
    protected int getHealRate() {
        return 80;
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(TAItems.AUTOCASTER_PLACER, 1, 1);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return TALootTables.AUTOCASTER_ELDRITCH;
    }
}

