/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.common.entities.projectile.EntityFocusCloud;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.fx.PacketFXShield;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.entity.ICastedEntity;
import thecodex6824.thaumicaugmentation.api.entity.IStopRailgunBeam;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class EntityFocusShield
extends EntityLivingBase
implements IEntityOwnable,
ICastedEntity,
IStopRailgunBeam {
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> CASTER_ID = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LIFESPAN = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> YAW_OFFSET = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> ROTATE = EntityDataManager.func_187226_a(EntityFocusShield.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final Field CLOUD_FOCUS;
    protected int timeAlive;
    protected boolean reflect;
    protected int aloneTicks;
    protected WeakReference<Entity> ownerRef = new WeakReference<Object>(null);

    public EntityFocusShield(World world) {
        super(world);
        this.field_70771_an = 0;
        this.func_70105_a(1.8f, 1.8f);
        this.setMaxHealth(5.0f);
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(5.0);
    }

    public void setMaxHealth(float newMax) {
        this.setMaxHealth(newMax, true);
    }

    public void setMaxHealth(float newMax, boolean updateLifespan) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)newMax);
        if (updateLifespan) {
            this.field_70180_af.func_187227_b(LIFESPAN, (Object)((int)(newMax * 150.0f)));
        }
    }

    public void setInfiniteLifespan() {
        this.field_70180_af.func_187227_b(LIFESPAN, (Object)-1);
    }

    public void resetTimeAlive() {
        this.timeAlive = 0;
    }

    public int getTimeAlive() {
        return this.timeAlive;
    }

    public int getTotalLifespan() {
        return (Integer)this.field_70180_af.func_187225_a(LIFESPAN);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int newColor) {
        this.field_70180_af.func_187227_b(COLOR, (Object)newColor);
    }

    public void setYawOffset(float yaw) {
        this.field_70180_af.func_187227_b(YAW_OFFSET, (Object)Float.valueOf(yaw));
    }

    public float getYawOffset() {
        return ((Float)this.field_70180_af.func_187225_a(YAW_OFFSET)).floatValue();
    }

    public void setRotate(boolean shouldRotate) {
        this.field_70180_af.func_187227_b(ROTATE, (Object)shouldRotate);
    }

    public boolean getRotate() {
        return (Boolean)this.field_70180_af.func_187225_a(ROTATE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(CASTER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(COLOR, (Object)5243080);
        this.field_70180_af.func_187214_a(LIFESPAN, (Object)1500);
        this.field_70180_af.func_187214_a(YAW_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATE, (Object)false);
    }

    @Nullable
    public Entity func_70902_q() {
        return (Entity)this.ownerRef.get();
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get();
    }

    public void setOwner(@Nullable Entity newOwner) {
        if (newOwner != null) {
            this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.of((Object)newOwner.getPersistentID()));
            this.ownerRef = new WeakReference<Entity>(newOwner);
            float lYaw = 0.0f;
            if (newOwner instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)newOwner;
                lYaw = living.field_70759_as + this.getYawOffset();
            } else {
                lYaw = newOwner.field_70177_z + this.getYawOffset();
            }
            Vec3d lookVec = this.getEntityLookVector(lYaw, newOwner.field_70125_A).func_186678_a(1.5);
            this.func_70012_b(newOwner.field_70165_t + lookVec.field_72450_a, newOwner.field_70163_u + lookVec.field_72448_b + (double)newOwner.field_70131_O / 2.0 - (double)this.field_70131_O / 2.0, newOwner.field_70161_v + lookVec.field_72449_c, lYaw, newOwner.field_70125_A);
        } else {
            this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.absent());
            this.ownerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    @Nullable
    public UUID getCasterID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(CASTER_ID)).get();
    }

    @Override
    public void setCasterID(@Nullable UUID newCaster) {
        this.field_70180_af.func_187227_b(CASTER_ID, (Object)Optional.fromNullable((Object)newCaster));
    }

    public void setReflect(boolean ref) {
        this.reflect = ref;
    }

    public boolean canReflect() {
        return this.reflect;
    }

    @Override
    public boolean shouldStopRailgunBeam(EntityLivingBase beamShooter) {
        return this.canReflect();
    }

    protected float getCloudPower(EntityFocusCloud cloud) {
        FocusPackage p = null;
        try {
            p = (FocusPackage)CLOUD_FOCUS.get(cloud);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        float power = 0.0f;
        for (IFocusElement node : p.nodes) {
            if (!(node instanceof FocusEffect)) continue;
            power += ((FocusEffect)node).getDamageForDisplay(1.0f);
        }
        return power;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity newEntity;
        Entity entity;
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (this.reflect && !this.field_70170_p.field_72995_K && ((entity = source.func_76364_f()) instanceof IProjectile || entity instanceof EntityFireball) && entity.func_70089_S() && (newEntity = EntityList.func_191304_a(entity.getClass(), (World)entity.field_70170_p)) != null) {
            NBTTagCompound toCopy = entity.serializeNBT();
            toCopy.func_186854_a("UUID", newEntity.func_110124_au());
            newEntity.deserializeNBT(toCopy);
            newEntity.func_70012_b(entity.field_70165_t - entity.field_70159_w, entity.field_70163_u - entity.field_70181_x, entity.field_70161_v - entity.field_70179_y, -entity.field_70177_z, -entity.field_70125_A);
            newEntity.field_70159_w = -entity.field_70159_w;
            newEntity.field_70181_x = -entity.field_70181_x;
            newEntity.field_70179_y = -entity.field_70179_y;
            int attempts = 0;
            while (newEntity.func_174813_aQ().func_72326_a(this.func_174813_aQ()) && attempts++ < 10) {
                newEntity.func_70107_b(newEntity.field_70165_t + newEntity.field_70159_w, newEntity.field_70163_u + newEntity.field_70181_x, newEntity.field_70161_v + newEntity.field_70179_y);
            }
            if (entity instanceof EntityFireball && newEntity instanceof EntityFireball) {
                EntityFireball original = (EntityFireball)entity;
                EntityFireball fireball = (EntityFireball)newEntity;
                fireball.field_70232_b = -original.field_70232_b;
                fireball.field_70233_c = -original.field_70233_c;
                fireball.field_70230_d = -original.field_70230_d;
            } else if (newEntity instanceof EntityTippedArrow) {
                ((EntityTippedArrow)newEntity).func_184555_a(entity instanceof EntityTippedArrow ? ((EntityTippedArrow)entity).func_184550_j() : new ItemStack(Items.field_151032_g));
            }
            newEntity.field_70133_I = true;
            if (newEntity.field_70170_p.func_72838_d(newEntity)) {
                entity.func_70106_y();
            }
        }
        if (super.func_70097_a(source, amount)) {
            if (!this.field_70170_p.field_72995_K) {
                int targetID = -1;
                if (source.func_76346_g() != null) {
                    targetID = source.func_76346_g().func_145782_y();
                } else if (source == DamageSource.field_82729_p) {
                    targetID = -3;
                } else if (source.func_76364_f() != null) {
                    targetID = source.func_76364_f().func_145782_y();
                }
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketFXShield(this.func_145782_y(), targetID), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        StackTraceElement[] trace;
        if (this.field_70170_p.field_72995_K && ThaumicAugmentation.proxy.isEntityClientPlayer((Entity)this.ownerRef.get()) && (trace = Thread.currentThread().getStackTrace()).length >= 3 && trace[2].getClassName().equals("net.minecraft.client.renderer.EntityRenderer$1")) {
            return false;
        }
        return super.func_70067_L();
    }

    protected void func_82167_n(Entity entity) {
        Entity owner = (Entity)this.ownerRef.get();
        if (owner != null) {
            if (entity.equals((Object)owner)) {
                return;
            }
            if (entity instanceof EntityThrowable && owner.equals((Object)((EntityThrowable)entity).func_85052_h())) {
                return;
            }
            if (entity instanceof EntityArrow && owner.equals((Object)((EntityArrow)entity).field_70250_c)) {
                return;
            }
            if (entity instanceof EntityFireball && owner.equals((Object)((EntityFireball)entity).field_70235_a)) {
                return;
            }
        }
        super.func_82167_n(entity);
    }

    public void func_70100_b_(EntityPlayer entity) {
        Entity owner = (Entity)this.ownerRef.get();
        if (owner != null && entity.equals((Object)owner)) {
            return;
        }
        super.func_70100_b_(entity);
    }

    public void func_70108_f(Entity entity) {
        Entity owner = (Entity)this.ownerRef.get();
        if (owner != null) {
            if (entity.equals((Object)owner)) {
                return;
            }
            if (entity instanceof IEntityOwnable && owner.equals((Object)((IEntityOwnable)entity).func_70902_q())) {
                return;
            }
            if (entity instanceof EntityThrowable && owner.equals((Object)((EntityThrowable)entity).func_85052_h())) {
                return;
            }
            if (entity instanceof EntityArrow && owner.equals((Object)((EntityArrow)entity).field_70250_c)) {
                return;
            }
            if (entity instanceof EntityFireball && owner.equals((Object)((EntityFireball)entity).field_70235_a)) {
                return;
            }
        }
        super.func_70108_f(entity);
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        Entity owner = (Entity)this.ownerRef.get();
        if (owner != null) {
            if (entity.equals((Object)owner)) {
                return null;
            }
            if (entity instanceof IEntityOwnable && owner.equals((Object)((IEntityOwnable)entity).func_70902_q())) {
                return null;
            }
            if (entity instanceof EntityThrowable && owner.equals((Object)((EntityThrowable)entity).func_85052_h())) {
                return null;
            }
            if (entity instanceof EntityArrow && owner.equals((Object)((EntityArrow)entity).field_70250_c)) {
                return null;
            }
            if (entity instanceof EntityFireball && owner.equals((Object)((EntityFireball)entity).field_70235_a)) {
                return null;
            }
        }
        return this.func_174813_aQ();
    }

    public void resetBoundingBoxes() {
        double heightOffset = (double)Math.abs(this.field_70125_A) / 90.0;
        Vec3d pos1 = new Vec3d((double)(-this.field_70130_N) / 2.0, -heightOffset, -0.0625);
        Vec3d pos2 = new Vec3d((double)this.field_70130_N / 2.0, (double)this.field_70131_O - heightOffset, 0.0625);
        pos1 = pos1.func_178789_a((float)Math.toRadians(this.field_70125_A)).func_178785_b((float)Math.toRadians(this.field_70177_z)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        pos2 = pos2.func_178789_a((float)Math.toRadians(this.field_70125_A)).func_178785_b((float)Math.toRadians(this.field_70177_z)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_174826_a(new AxisAlignedBB(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c));
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.field_70169_q = this.field_70142_S = this.field_70165_t;
        this.field_70167_r = this.field_70137_T = this.field_70163_u;
        this.field_70166_s = this.field_70136_U = this.field_70161_v;
        this.field_70126_B = this.field_70758_at = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.func_70101_b(yaw, pitch);
        this.field_70759_as = this.field_70177_z;
    }

    protected Vec3d getEntityLookVector(float yaw, float pitch) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public void func_70636_d() {
        Entity owner;
        int lifespan = this.getTotalLifespan();
        if (lifespan > 0) {
            ++this.timeAlive;
            if (!this.field_70170_p.field_72995_K && this.timeAlive > lifespan && this.func_70089_S()) {
                this.func_70097_a(DamageSource.field_76380_i, 100000.0f);
                return;
            }
        }
        if (this.ownerRef.get() == null && ((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent() && this.ownerRef.get() == null) {
            List entities = this.field_70170_p.func_175644_a(Entity.class, entity -> entity != null && entity.getPersistentID().equals(((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get()));
            if (!entities.isEmpty()) {
                this.ownerRef = new WeakReference(entities.get(0));
            } else {
                ++this.aloneTicks;
            }
        }
        if ((owner = (Entity)this.ownerRef.get()) != null) {
            if (!owner.func_70089_S()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                } else {
                    this.ownerRef.clear();
                }
            } else {
                if (this.getRotate()) {
                    this.setYawOffset(this.getYawOffset() + 2.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (owner.field_71093_bK != this.field_71093_bK) {
                        this.func_184204_a(owner.field_71093_bK);
                        return;
                    }
                    float lYaw = 0.0f;
                    if (owner instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)owner;
                        lYaw = living.field_70759_as + this.getYawOffset();
                    } else {
                        lYaw = owner.field_70177_z + this.getYawOffset();
                    }
                    Vec3d lookVec = this.getEntityLookVector(lYaw, owner.field_70125_A).func_186678_a(1.5);
                    this.func_70012_b(owner.field_70165_t + lookVec.field_72450_a, owner.field_70163_u + lookVec.field_72448_b + (double)owner.field_70131_O / 1.5 - (double)this.field_70131_O / 2.0, owner.field_70161_v + lookVec.field_72449_c, lYaw, owner.field_70125_A);
                    this.field_70159_w = owner.field_70159_w;
                    this.field_70181_x = owner.field_70181_x;
                    this.field_70179_y = owner.field_70179_y;
                    this.resetBoundingBoxes();
                    this.func_85033_bc();
                    if (this.canReflect()) {
                        for (EntityFocusCloud e : this.field_70170_p.func_72872_a(EntityFocusCloud.class, owner.func_174813_aQ().func_186662_g(1.0))) {
                            this.func_70665_d(DamageSource.func_188403_a((Entity)e, (EntityLivingBase)e.getOwner()), this.getCloudPower(e) / 4.0f);
                            float radius = e.getRadius();
                            if (radius > 1.0f) {
                                e.setRadius(radius - 1.0f);
                                continue;
                            }
                            e.func_70106_y();
                        }
                    }
                } else {
                    float pt = ThaumicAugmentation.proxy.getPartialTicks();
                    float lPitch = owner.field_70127_C + (owner.field_70125_A - owner.field_70127_C) * pt;
                    float lYaw = 0.0f;
                    if (owner instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)owner;
                        lYaw = living.field_70758_at + (living.field_70759_as - living.field_70758_at) * pt + this.getYawOffset();
                    } else {
                        lYaw = owner.field_70126_B + (owner.field_70177_z - owner.field_70126_B) * pt + this.getYawOffset();
                    }
                    Vec3d lookVec = this.getEntityLookVector(lYaw, lPitch).func_186678_a(1.5);
                    this.func_70012_b(owner.field_70165_t + lookVec.field_72450_a, owner.field_70163_u + lookVec.field_72448_b + (double)owner.field_70131_O / 1.5 - (double)this.field_70131_O / 2.0, owner.field_70161_v + lookVec.field_72449_c, lYaw, lPitch);
                    this.field_70159_w = owner.field_70159_w;
                    this.field_70181_x = owner.field_70181_x;
                    this.field_70179_y = owner.field_70179_y;
                    this.resetBoundingBoxes();
                    AxisAlignedBB box = this.func_174813_aQ();
                    double xDiff = box.field_72336_d - box.field_72340_a;
                    double yDiff = box.field_72337_e - box.field_72338_b;
                    double zDiff = box.field_72334_f - box.field_72339_c;
                    int color = (Integer)this.field_70180_af.func_187225_a(COLOR);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 2; ++i) {
                        ThaumicAugmentation.proxy.getRenderHelper().renderFireMote(this.field_70170_p, (float)(box.field_72340_a + (double)this.field_70146_Z.nextFloat() * xDiff), (float)(box.field_72338_b + (double)this.field_70146_Z.nextFloat() * yDiff), (float)(box.field_72339_c + (double)this.field_70146_Z.nextFloat() * zDiff), (float)this.field_70159_w, 0.05f, (float)this.field_70179_y, r, g, b, 0.35f, 1.5f);
                    }
                }
            }
        } else if (!this.field_70170_p.field_72995_K && this.aloneTicks >= 20) {
            this.func_70106_y();
        }
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.FIRE_EXPLOSION, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue()), (Entity)this);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == OWNER_ID) {
            this.ownerRef.clear();
        }
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsTC.craftfail;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsTC.runicShieldEffect;
    }

    public SoundCategory func_184176_by() {
        Entity owner = (Entity)this.ownerRef.get();
        return owner != null ? owner.func_184176_by() : super.func_184176_by();
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("timeAlive", this.timeAlive);
        compound.func_74768_a("lifespan", ((Integer)this.field_70180_af.func_187225_a(LIFESPAN)).intValue());
        compound.func_74757_a("reflect", this.reflect);
        Entity owner = (Entity)this.ownerRef.get();
        if (owner != null) {
            compound.func_186854_a("owner", owner.getPersistentID());
        }
        if (this.getCasterID() != null) {
            compound.func_186854_a("caster", this.getCasterID());
        }
        compound.func_74768_a("color", this.getColor());
        compound.func_74776_a("offset", this.getYawOffset());
        compound.func_74757_a("rotate", this.getRotate());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timeAlive = compound.func_74762_e("timeAlive");
        this.field_70180_af.func_187227_b(LIFESPAN, (Object)compound.func_74762_e("lifespan"));
        this.reflect = compound.func_74767_n("reflect");
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.fromNullable((Object)compound.func_186857_a("owner")));
        this.setCasterID(compound.func_186857_a("caster"));
        this.setColor(compound.func_74762_e("color"));
        this.setYawOffset(compound.func_74760_g("offset"));
        this.setRotate(compound.func_74767_n("rotate"));
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (type == MoverType.SELF) {
            super.func_70091_d(type, x, y, z);
        }
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70094_T() {
        return false;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public void func_70015_d(int seconds) {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    static {
        try {
            CLOUD_FOCUS = EntityFocusCloud.class.getDeclaredField("focusPackage");
            CLOUD_FOCUS.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

