/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.entities.projectile.EntityEldritchOrb;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXSonic;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;

public class EntityTAEldritchGuardian
extends EntityEldritchGuardian {
    protected static final DataParameter<Boolean> TRANSPARENT = EntityDataManager.func_187226_a(EntityTAEldritchGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final Field LAST_BLAST;

    public EntityTAEldritchGuardian(World world) {
        super(world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILongRangeAttack((IRangedAttackMob)this, 3.0, 1.0, 20, 40, 24.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistLeader.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalGreater.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalLesser.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRANSPARENT, (Object)true);
    }

    public boolean isTransparent() {
        return (Boolean)this.field_70180_af.func_187225_a(TRANSPARENT);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, @Nullable IEntityLivingData data) {
        IEntityLivingData d = super.func_180482_a(diff, data);
        EntityInOuterLandsEvent event = new EntityInOuterLandsEvent((Entity)this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && this.field_70170_p.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            this.field_70180_af.func_187227_b(TRANSPARENT, (Object)false);
            float difficultyMod = (float)this.field_70170_p.func_175659_aa().func_151525_a() / 3.0f;
            if (difficultyMod > 0.0f) {
                float absorbAmount = (float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() / 2.0f * difficultyMod;
                this.func_110149_m(this.func_110139_bj() + absorbAmount);
            }
        } else {
            this.field_70180_af.func_187227_b(TRANSPARENT, (Object)true);
        }
        return d;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70172_ad <= 0 && this.field_70173_aa % 25 == 0) {
            EntityInOuterLandsEvent event = new EntityInOuterLandsEvent((Entity)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && this.field_70170_p.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
                double bh = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() / 2.0;
                if ((double)this.func_110139_bj() < bh) {
                    this.func_110149_m(this.func_110139_bj() + 1.0f);
                }
            }
        }
    }

    protected void setLastBlast(boolean newValue) {
        try {
            LAST_BLAST.setBoolean((Object)this, newValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean getLastBlast() {
        try {
            return LAST_BLAST.getBoolean((Object)this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.field_70146_Z.nextFloat() > 0.15f) {
            EntityEldritchOrb blast = new EntityEldritchOrb(this.field_70170_p, (EntityLivingBase)this);
            blast.field_184539_c = this;
            boolean newBlast = !this.getLastBlast();
            this.setLastBlast(newBlast);
            this.field_70170_p.func_72960_a((Entity)this, (byte)(newBlast ? 16 : 15));
            int rr = newBlast ? 90 : 180;
            double xx = Math.cos((double)(this.field_70177_z + (float)rr) % 360.0 / 180.0 * Math.PI) * 0.5;
            double zz = Math.sin((double)(this.field_70177_z + (float)rr) % 360.0 / 180.0 * Math.PI) * 0.5;
            blast.func_70107_b(blast.field_70165_t - xx, blast.field_70163_u, blast.field_70161_v - zz);
            Vec3d v = target.func_174791_d().func_72441_c(target.field_70159_w * 10.0, target.field_70181_x * 10.0, target.field_70179_y * 10.0).func_178788_d(this.func_174791_d()).func_72432_b();
            blast.func_70186_c(v.field_72450_a, v.field_72448_b, v.field_72449_c, 1.25f, 1.5f);
            this.func_184185_a(SoundsTC.egattack, 2.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)blast);
        } else if (this.func_70685_l((Entity)target)) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400, 0));
            if (target instanceof EntityPlayer) {
                ThaumcraftApi.internalMethods.addWarpToPlayer((EntityPlayer)target, 1 + this.field_70146_Z.nextInt(3), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
            this.func_184185_a(SoundsTC.egscreech, 3.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new PacketFXSonic(this.func_145782_y()), (Entity)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        if (!this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_189884_a((Entity)this)) return false;
        return true;
    }

    public boolean func_184191_r(Entity entity) {
        if (this.func_96124_cp() != null) {
            return this.func_184194_a(entity.func_96124_cp());
        }
        return entity instanceof IEldritchMob;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return TALootTables.ELDRITCH_GUARDIAN;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("transparent", ((Boolean)this.field_70180_af.func_187225_a(TRANSPARENT)).booleanValue());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(TRANSPARENT, (Object)nbt.func_74767_n("transparent"));
    }

    protected Item func_146068_u() {
        return null;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    static {
        try {
            LAST_BLAST = EntityEldritchGuardian.class.getDeclaredField("lastBlast");
            LAST_BLAST.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

