/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityEldritchOrb;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXSonic;
import thaumcraft.common.lib.utils.EntityUtils;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.api.ward.WardSyncManager;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;
import thecodex6824.thaumicaugmentation.common.entity.IEldritchSpireWardHolder;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

public class EntityTAEldritchWarden
extends EntityEldritchWarden
implements IEldritchSpireWardHolder {
    protected static final DataParameter<Boolean> TRANSPARENT = EntityDataManager.func_187226_a(EntityTAEldritchWarden.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final Field LAST_BLAST;
    protected static final Field FRENZY_COUNTER;
    protected static final String[] NAMES;
    protected DimensionalBlockPos structurePos;

    protected static String generateName(Random rng) {
        return NAMES[rng.nextInt(NAMES.length)];
    }

    public EntityTAEldritchWarden(World world) {
        super(world);
        this.func_70105_a(0.8f, 2.25f);
        this.structurePos = DimensionalBlockPos.INVALID;
    }

    @Override
    public void setStructurePos(DimensionalBlockPos pos) {
        this.structurePos = pos;
    }

    public float func_70047_e() {
        return 2.1f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILongRangeAttack((IRangedAttackMob)this, 2.5, 1.0, 20, 40, 24.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.1, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistLeader.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalGreater.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultistPortalLesser.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRANSPARENT, (Object)true);
    }

    public boolean isTransparent() {
        return (Boolean)this.field_70180_af.func_187225_a(TRANSPARENT);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, @Nullable IEntityLivingData data) {
        EntityUtils.makeChampion((EntityMob)this, (boolean)true);
        IEntityLivingData d = super.func_180482_a(diff, data);
        this.bossInfo.func_186739_a(this.func_145748_c_());
        EntityInOuterLandsEvent event = new EntityInOuterLandsEvent((Entity)this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && this.field_70170_p.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            this.field_70180_af.func_187227_b(TRANSPARENT, (Object)false);
        } else {
            this.field_70180_af.func_187227_b(TRANSPARENT, (Object)true);
        }
        return d;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void generateName() {
        int cIndex = (int)this.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e();
        this.func_96094_a(new TextComponentTranslation("thaumicaugmentation.text.entity.eldritch_warden", new Object[]{EntityTAEldritchWarden.generateName(this.field_70146_Z), ChampionModifier.mods[cIndex].getModNameLocalized()}).func_150254_d());
    }

    protected void handleStructureWard() {
        WorldServer structureDim;
        if (!this.field_70170_p.field_72995_K && !this.structurePos.isInvalid() && (structureDim = DimensionManager.getWorld((int)this.structurePos.getDimension())) != null) {
            MapGenStructureData data = (MapGenStructureData)structureDim.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "EldritchSpire");
            if (data != null) {
                NBTTagCompound nbt = data.func_143041_a();
                for (String s : nbt.func_150296_c()) {
                    StructureStart start;
                    NBTTagCompound tag = nbt.func_74775_l(s);
                    if (!tag.func_150297_b("ChunkX", 3) || !tag.func_150297_b("ChunkZ", 3)) continue;
                    int testX = tag.func_74762_e("ChunkX");
                    int testZ = tag.func_74762_e("ChunkZ");
                    if (testX != this.structurePos.getPos().func_177958_n() >> 4 || testZ != this.structurePos.getPos().func_177952_p() >> 4 || !((start = MapGenStructureIO.func_143035_a((NBTTagCompound)tag, (World)structureDim)) instanceof MapGenEldritchSpire.Start)) continue;
                    UUID ward = ((MapGenEldritchSpire.Start)start).getWard();
                    StructureBoundingBox bb = start.func_75071_a();
                    for (int z = bb.field_78896_c >> 4; z <= bb.field_78892_f >> 4; ++z) {
                        for (int x = bb.field_78897_a >> 4; x <= bb.field_78893_d >> 4; ++x) {
                            IWardStorage storage = (IWardStorage)this.field_70170_p.func_72964_e(x, z).getCapability(CapabilityWardStorage.WARD_STORAGE, null);
                            if (!(storage instanceof IWardStorageServer)) continue;
                            ((IWardStorageServer)storage).removeOwner(ward);
                            WardSyncManager.markChunkForFullSync(this.field_70170_p, new BlockPos(x << 4, 0, z << 4));
                        }
                    }
                }
            }
            this.structurePos = DimensionalBlockPos.INVALID;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70729_aU) {
            this.handleStructureWard();
        }
        if (!this.field_70170_p.field_72995_K && this.getSpawnTimer() == 1) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                for (int i = 0; i < 3; ++i) {
                    EntityFocusShield shield = new EntityFocusShield(this.field_70170_p);
                    shield.setOwner((Entity)this);
                    shield.setCasterID(this.getPersistentID());
                    shield.setColor(0x606060);
                    shield.setMaxHealth(150.0f, false);
                    shield.setInfiniteLifespan();
                    shield.setReflect(true);
                    shield.setYawOffset((float)i * 120.0f);
                    shield.setRotate(true);
                    shield.func_70606_j(shield.func_110138_aP());
                    this.field_70170_p.func_72838_d((Entity)shield);
                    this.field_70170_p.func_184133_a(null, shield.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.HOSTILE, 0.75f, 1.2f);
                }
            } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                EntityFocusShield shield = new EntityFocusShield(this.field_70170_p);
                shield.setOwner((Entity)this);
                shield.setCasterID(this.getPersistentID());
                shield.setColor(0x606060);
                shield.setMaxHealth(100.0f, false);
                shield.setInfiniteLifespan();
                shield.setReflect(true);
                shield.func_70606_j(shield.func_110138_aP());
                this.field_70170_p.func_72838_d((Entity)shield);
                this.field_70170_p.func_184133_a(null, shield.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.HOSTILE, 1.0f, 1.2f);
            } else {
                EntityFocusShield shield = new EntityFocusShield(this.field_70170_p);
                shield.setOwner((Entity)this);
                shield.setCasterID(this.getPersistentID());
                shield.setColor(0x606060);
                shield.setMaxHealth(50.0f, false);
                shield.setInfiniteLifespan();
                shield.func_70606_j(shield.func_110138_aP());
                this.field_70170_p.func_72838_d((Entity)shield);
                this.field_70170_p.func_184133_a(null, shield.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.HOSTILE, 1.0f, 1.2f);
            }
        }
    }

    protected int getFieldFrenzyCounter() {
        try {
            return FRENZY_COUNTER.getInt(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void func_70626_be() {
        if (this.getSpawnTimer() == 0 && this.getFieldFrenzyCounter() == 0) {
            super.func_70626_be();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo2.func_186735_a(Math.min(this.bossInfo2.func_186738_f(), 1.0f));
    }

    protected void setLastBlast(boolean newValue) {
        try {
            LAST_BLAST.setBoolean(this, newValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean getLastBlast() {
        try {
            return LAST_BLAST.getBoolean(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.field_70146_Z.nextFloat() > 0.2f) {
            EntityEldritchOrb blast = new EntityEldritchOrb(this.field_70170_p, (EntityLivingBase)this);
            blast.field_184539_c = this;
            boolean newBlast = !this.getLastBlast();
            this.setLastBlast(newBlast);
            this.field_70170_p.func_72960_a((Entity)this, (byte)(newBlast ? 16 : 15));
            int rr = newBlast ? 90 : 180;
            double xx = Math.cos((double)(this.field_70177_z + (float)rr) % 360.0 / 180.0 * Math.PI) * 0.5;
            double zz = Math.sin((double)(this.field_70177_z + (float)rr) % 360.0 / 180.0 * Math.PI) * 0.5;
            blast.func_70107_b(blast.field_70165_t - xx, blast.field_70163_u, blast.field_70161_v - zz);
            double x = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double y = target.field_70163_u + target.field_70181_x - this.field_70163_u - (double)(target.field_70131_O / 2.0f);
            double z = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            blast.func_70186_c(x, y, z, 2.0f, 0.25f);
            this.func_184185_a(SoundsTC.egattack, 2.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)blast);
        } else if (this.func_70685_l((Entity)target)) {
            target.func_70024_g(-Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 1.5, 0.1, Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 1.5);
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400, 0));
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 400, 0));
            if (target instanceof EntityPlayer) {
                ThaumcraftApi.internalMethods.addWarpToPlayer((EntityPlayer)target, 3 + this.field_70146_Z.nextInt(3), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
            this.func_184185_a(SoundsTC.egscreech, 4.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new PacketFXSonic(this.func_145782_y()), (Entity)this);
        }
    }

    public boolean func_184191_r(Entity entity) {
        if (this.func_96124_cp() != null) {
            return this.func_184194_a(entity.func_96124_cp());
        }
        return entity instanceof IEldritchMob;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.handleStructureWard();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("transparent", ((Boolean)this.field_70180_af.func_187225_a(TRANSPARENT)).booleanValue());
        if (!this.structurePos.isInvalid()) {
            nbt.func_74783_a("structure", this.structurePos.toArray());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(TRANSPARENT, (Object)nbt.func_74767_n("transparent"));
        if (nbt.func_150297_b("structure", 11)) {
            this.structurePos = new DimensionalBlockPos(nbt.func_74759_k("structure"));
        }
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return TALootTables.ELDRITCH_WARDEN;
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntitySpecialItem entity = null;
        if (stack.func_77973_b() == ItemsTC.primordialPearl) {
            entity = new EntitySpecialItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.1;
            entity.field_70179_y = 0.0;
        } else {
            entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
        }
        entity.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entity);
        } else {
            this.field_70170_p.func_72838_d((Entity)entity);
        }
        return entity;
    }

    static {
        try {
            LAST_BLAST = EntityEldritchWarden.class.getDeclaredField("lastBlast");
            LAST_BLAST.setAccessible(true);
            FRENZY_COUNTER = EntityEldritchWarden.class.getDeclaredField("fieldFrenzyCounter");
            FRENZY_COUNTER.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        NAMES = new String[]{"Aphoom-Zhah", "Basatan", "Chaugnar Faugn", "Mnomquah", "Nyogtha", "Oorn", "Shaikorth", "Rhan-Tegoth", "Rhogog", "Shudde M'ell", "Vulthoom", "Yag-Kosha", "Yibb-Tstll", "Zathog", "Zushakon"};
    }
}

