/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.entity.CapabilityPortalState;
import thecodex6824.thaumicaugmentation.api.entity.IPortalState;
import thecodex6824.thaumicaugmentation.api.entity.PortalStateManager;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;
import thecodex6824.thaumicaugmentation.common.network.PacketLivingEquipmentChange;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public class EntityEventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IPortalState state = (IPortalState)event.getEntity().getCapability(CapabilityPortalState.PORTAL_STATE, null);
        if (state != null && state.isInPortal()) {
            PortalStateManager.markEntityInPortal(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onProjectileCollide(ProjectileImpactEvent event) {
        EntityFocusShield s;
        if (event.getRayTraceResult().field_72308_g instanceof EntityFocusShield && (s = (EntityFocusShield)event.getRayTraceResult().field_72308_g).func_70902_q() != null) {
            Entity projectile = event.getEntity();
            if (projectile instanceof EntityThrowable && s.func_70902_q().equals((Object)((EntityThrowable)projectile).func_85052_h())) {
                event.setCanceled(true);
                return;
            }
            if (projectile instanceof EntityArrow && s.func_70902_q().equals((Object)((EntityArrow)projectile).field_70250_c)) {
                event.setCanceled(true);
                return;
            }
            if (projectile instanceof EntityFireball && s.func_70902_q().equals((Object)((EntityFireball)projectile).field_70235_a)) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PortalStateManager.tick();
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.func_130014_f_().field_72995_K) {
            PacketLivingEquipmentChange packet = new PacketLivingEquipmentChange(entity.func_145782_y(), event.getSlot(), event.getTo());
            TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)entity);
            if (entity instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)entity);
            }
        }
    }
}

