/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.internal;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.items.ItemsTC;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.event.AugmentEventHandler;
import thecodex6824.thaumicaugmentation.common.item.trait.IElytraCompat;
import thecodex6824.thaumicaugmentation.common.network.PacketBaubleChange;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;

public final class TAHooksCommon {
    private TAHooksCommon() {
    }

    private static boolean hasWard(World world, BlockPos pos) {
        IWardStorage ward;
        Chunk chunk;
        if (world != null && pos != null && world.func_72863_F() != null && world.func_175667_e(pos) && (chunk = world.func_175726_f(pos)) != null && (ward = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null)) != null) {
            return ward.hasWard(pos);
        }
        return false;
    }

    public static float checkWardHardness(float oldHardness, World world, BlockPos pos) {
        return TAHooksCommon.hasWard(world, pos) ? -1.0f : oldHardness;
    }

    public static float checkWardResistance(float oldResistance, World world, BlockPos pos) {
        return TAHooksCommon.hasWard(world, pos) ? 6000000.0f : oldResistance;
    }

    public static int checkWardFlammability(int oldFlammability, IBlockAccess access, BlockPos pos) {
        if (oldFlammability == 0) {
            return 0;
        }
        if (access instanceof World) {
            return TAHooksCommon.hasWard((World)access, pos) ? 0 : oldFlammability;
        }
        return oldFlammability;
    }

    public static int checkWardFireEncouragement(int oldEncouragement, IBlockAccess access, BlockPos pos) {
        if (oldEncouragement == 0) {
            return 0;
        }
        if (access instanceof World) {
            return TAHooksCommon.hasWard((World)access, pos) ? 0 : oldEncouragement;
        }
        return oldEncouragement;
    }

    public static boolean checkWardRandomTick(WorldServer world, BlockPos pos, IBlockState state, Random rand) {
        return !TAHooksCommon.hasWard((World)world, pos);
    }

    public static boolean checkWardGeneric(World world, BlockPos pos) {
        return !TAHooksCommon.hasWard(world, pos);
    }

    public static void checkElytra(ItemStack chestArmorStack, EntityPlayerMP player) {
        ItemStack stack;
        IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        if (baubles != null && (stack = baubles.getStackInSlot(BaubleType.BODY.getValidSlots()[0])).func_77973_b() instanceof IElytraCompat && ((IElytraCompat)stack.func_77973_b()).allowElytraFlight((EntityPlayer)player, stack)) {
            player.func_184847_M();
        }
    }

    public static boolean updateElytraFlag(EntityLivingBase entity, boolean flag) {
        ItemStack stack;
        EntityPlayer player;
        IBaublesItemHandler baubles;
        if (flag) {
            return true;
        }
        if (entity instanceof EntityPlayer && (baubles = (IBaublesItemHandler)(player = (EntityPlayer)entity).getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) != null && (stack = baubles.getStackInSlot(BaubleType.BODY.getValidSlots()[0])).func_77973_b() instanceof IElytraCompat) {
            return ((IElytraCompat)stack.func_77973_b()).allowElytraFlight(player, stack);
        }
        return false;
    }

    public static ItemStack getLeftoverInfusionIngredientStack(ItemStack input, Object output) {
        if (output instanceof ItemStack && input.func_77973_b() != ItemsTC.primordialPearl) {
            if (((ItemStack)output).func_77973_b() == TAItems.MORPHIC_TOOL) {
                return ItemStack.field_190927_a;
            }
            if (MorphicArmorHelper.hasMorphicArmor((ItemStack)output)) {
                return ItemStack.field_190927_a;
            }
        }
        return input;
    }

    public static void onBaubleChanged(@Nullable EntityLivingBase entity) {
        if (entity != null && !entity.func_130014_f_().field_72995_K) {
            AugmentEventHandler.onEquipmentChange(entity);
            PacketBaubleChange pkt = new PacketBaubleChange(entity.func_145782_y());
            TANetwork.INSTANCE.sendToAllTracking((IMessage)pkt, (Entity)entity);
            if (entity instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)pkt, (EntityPlayerMP)entity);
            }
        }
    }

    public static boolean isInOuterLands(Entity entity) {
        EntityInOuterLandsEvent event = new EntityInOuterLandsEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && entity.func_130014_f_().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a();
    }

    public static boolean shouldAllowRunicShield(ItemStack stack) {
        return stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
    }
}

