/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.CasterAugmentBuilder;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.common.capability.AugmentCasterCustom;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterEffectProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;

public class ItemCustomCasterAugment
extends ItemTABase {
    public ItemCustomCasterAugment() {
        super(new String[0]);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        AugmentCasterCustom augment = new AugmentCasterCustom();
        SimpleCapabilityProvider<IAugment> provider = new SimpleCapabilityProvider<IAugment>(augment, CapabilityAugment.AUGMENT);
        if (nbt != null) {
            NBTTagCompound data = nbt.func_74775_l("Parent");
            if (data.func_82582_d() || !data.func_150297_b("strength", 10) || !data.func_150297_b("effect", 10)) {
                if (data.func_82582_d() || !data.func_150297_b("strength", 10)) {
                    augment.setStrengthProvider(CasterAugmentBuilder.createStackForStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_elemental")));
                    if (stack.func_77942_o()) {
                        augment.getStrengthProvider().func_77978_p().func_74778_a("aspect", stack.func_77978_p().func_74779_i("aspect"));
                    }
                }
                if (data.func_82582_d() || !data.func_150297_b("effect", 10)) {
                    augment.setEffectProvider(CasterAugmentBuilder.createStackForEffectProvider(new ResourceLocation("thaumicaugmentation", "effect_power")));
                }
            }
            if (!data.func_82582_d()) {
                provider.deserializeNBT(nbt);
            }
        }
        return provider;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p());
        }
        tag.func_74782_a("cap", (NBTBase)((AugmentCasterCustom)stack.getCapability(CapabilityAugment.AUGMENT, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((AugmentCasterCustom)stack.getCapability(CapabilityAugment.AUGMENT, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.getCapability(CapabilityAugment.AUGMENT, null) instanceof ICustomCasterAugment) {
            ICustomCasterAugment aug = (ICustomCasterAugment)stack.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug.getStrengthProvider().func_190926_b() && aug.getEffectProvider().func_190926_b()) {
                tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.strength_provider_any", new Object[0]).func_150254_d());
                tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.effect_provider_any", new Object[0]).func_150254_d());
            } else {
                tooltip.add(new TextComponentTranslation(aug.getStrengthProvider().func_77977_a(), new Object[0]).func_150254_d());
                CasterAugmentBuilder.getStrengthProvider(ItemCustomCasterStrengthProvider.getProviderID(aug.getStrengthProvider())).appendAdditionalTooltip(aug.getStrengthProvider(), tooltip);
                tooltip.add(new TextComponentTranslation(aug.getEffectProvider().func_77977_a(), new Object[0]).func_150254_d());
                CasterAugmentBuilder.getEffectProvider(ItemCustomCasterEffectProvider.getProviderID(aug.getEffectProvider())).appendAdditionalTooltip(aug.getEffectProvider(), tooltip);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("ta_special:custom_caster_augment", "inventory"));
    }
}

