/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.network.PacketFractureLocatorUpdate;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.FractureLocatorSearchManager;

public class ItemFractureLocator
extends ItemTABase {
    public ItemFractureLocator() {
        super(new String[0]);
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && FractureLocatorSearchManager.canPlayerRequestLocation((EntityPlayer)entity)) {
            BlockPos nearest = FractureLocatorSearchManager.findNearestFracture(world, entity.func_180425_c());
            if (nearest != null) {
                TANetwork.INSTANCE.sendTo((IMessage)new PacketFractureLocatorUpdate(nearest), (EntityPlayerMP)entity);
            } else {
                TANetwork.INSTANCE.sendTo((IMessage)new PacketFractureLocatorUpdate(), (EntityPlayerMP)entity);
            }
            FractureLocatorSearchManager.resetPlayerLocationTime((EntityPlayer)entity);
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ARCANE;
    }

    @SideOnly(value=Side.CLIENT)
    private double getLookYaw(Entity entity) {
        double yaw = 0.0;
        yaw = entity instanceof EntityLivingBase ? (double)((EntityLivingBase)entity).field_70759_as : (double)entity.field_70177_z;
        return Math.floorMod((long)yaw + 90L, 360L);
    }

    @SideOnly(value=Side.CLIENT)
    private double normalize(double input) {
        if ((input = (input + Math.PI) % (Math.PI * 2)) < 0.0) {
            input += Math.PI * 2;
        }
        return input - Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    private double angleDifference(double a1, double a2) {
        return this.normalize(a2 - a1);
    }

    @SideOnly(value=Side.CLIENT)
    private double calcError(double value, double expected) {
        return Math.abs(this.angleDifference(expected, value)) / Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTintColor(ItemStack stack) {
        int[] pos;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("found") && (pos = stack.func_77978_p().func_74759_k("pos")).length == 3) {
            Vec3d fracture = new Vec3d((double)pos[0], (double)pos[1], (double)pos[2]);
            EntityItemFrame entity = stack.func_82836_z() != null ? stack.func_82836_z() : Minecraft.func_71410_x().field_71439_g;
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            Vec3d playerPos = entity.func_174824_e(partialTicks);
            double optimalAngle = this.normalize(Math.atan2(fracture.field_72449_c + 0.5 - playerPos.field_72449_c, fracture.field_72450_a + 0.5 - playerPos.field_72450_a));
            double currentYaw = this.getLookYaw((Entity)entity) * Math.PI / 180.0;
            int factor = (int)((1.0 - MathHelper.func_151237_a((double)this.calcError(currentYaw, optimalAngle), (double)0.0, (double)0.85)) * 255.0);
            return factor | factor << 8 | factor << 16;
        }
        return 0;
    }
}

