/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.augment.AugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.builder.IImpulseCannonAugment;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusStorage;
import thecodex6824.thaumicaugmentation.api.util.RaytraceHelper;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderImpulseCannon;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseBeam;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class ItemImpulseCannon
extends ItemTABase {
    public ItemImpulseCannon() {
        super(new String[0]);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("thaumicaugmentation", "arm"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity != null) {
                    if (entity.func_184614_ca().equals(stack) && entity.func_184592_cb().func_190926_b()) {
                        return 1.0f;
                    }
                    if (entity.func_184592_cb().equals(stack) && entity.func_184614_ca().func_190926_b()) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityProviderImpulseCannon provider = new CapabilityProviderImpulseCannon(new AugmentableItem(1){

            @Override
            public boolean isAugmentAcceptable(ItemStack augment, int slot) {
                return augment.getCapability(CapabilityAugment.AUGMENT, null) instanceof IImpulseCannonAugment;
            }
        }, new ImpetusStorage(1000L, 100L, 1000L));
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    @Nullable
    protected IImpulseCannonAugment getAugment(ItemStack stack) {
        IAugment aug;
        IAugmentableItem augments = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (augments != null && augments.isAugmented() && (aug = (IAugment)augments.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IImpulseCannonAugment) {
            return (IImpulseCannonAugment)aug;
        }
        return null;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IImpetusStorage buffer = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        IImpulseCannonAugment aug = this.getAugment(stack);
        if (!world.field_72995_K) {
            if (aug != null && !aug.isTickable((EntityLivingBase)player) && buffer != null) {
                long cost = aug.getImpetusCostPerUsage((EntityLivingBase)player);
                if (ImpetusAPI.tryExtractFully(buffer, cost, (Entity)player)) {
                    aug.onCannonUsage((EntityLivingBase)player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if ((aug != null && aug.isTickable((EntityLivingBase)player) || aug == null) && buffer != null) {
                long cost;
                long l = cost = aug != null ? aug.getImpetusCostPerTick((EntityLivingBase)player, -1) : TAConfig.cannonBeamCost.getValue().longValue();
                if (buffer.canExtract() && buffer.getEnergyStored() >= cost) {
                    player.func_184598_c(hand);
                    if (aug == null) {
                        Random rand = player.func_70681_au();
                        player.func_130014_f_().func_184133_a(null, new BlockPos(player.func_174824_e(1.0f)), TASounds.IMPULSE_CANNON_BEAM_START, SoundCategory.PLAYERS, 1.0f, (rand.nextFloat() - rand.nextFloat()) / 4.0f + 1.0f);
                        PacketImpulseBeam packet = new PacketImpulseBeam(player.func_145782_y(), false);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)player);
                        if (player instanceof EntityPlayerMP) {
                            TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                        }
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        IImpetusStorage buffer = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        IImpulseCannonAugment aug = this.getAugment(stack);
        if (!player.func_130014_f_().field_72995_K) {
            if (aug != null && buffer != null) {
                if (ImpetusAPI.tryExtractFully(buffer, aug.getImpetusCostPerTick(player, count), (Entity)player)) {
                    aug.onCannonTick(player, count);
                } else {
                    player.func_184597_cx();
                    aug.onStopCannonTick(player, count);
                }
            } else if (buffer != null) {
                if (ImpetusAPI.tryExtractFully(buffer, TAConfig.cannonBeamCost.getValue(), (Entity)player)) {
                    Entity e = RaytraceHelper.raytraceEntity(player, TAConfig.cannonBeamRange.getValue());
                    if (e != null) {
                        ImpetusAPI.causeImpetusDamage((Entity)player, e, TAConfig.cannonBeamDamage.getValue().floatValue());
                    }
                    if (player.field_70173_aa % 20 == 0) {
                        PacketImpulseBeam packet = new PacketImpulseBeam(player.func_145782_y(), false);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)player);
                        if (player instanceof EntityPlayerMP) {
                            TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                        }
                    }
                } else {
                    player.func_184597_cx();
                    Random rand = player.func_70681_au();
                    player.func_130014_f_().func_184133_a(null, new BlockPos(player.func_174824_e(1.0f)), TASounds.IMPULSE_CANNON_BEAM_END, SoundCategory.PLAYERS, 1.0f, (rand.nextFloat() - rand.nextFloat()) / 4.0f + 1.0f);
                    PacketImpulseBeam packet = new PacketImpulseBeam(player.func_145782_y(), true);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)player);
                    if (player instanceof EntityPlayerMP) {
                        TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                    }
                }
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            IImpulseCannonAugment aug = this.getAugment(stack);
            if (aug == null) {
                Random rand = entity.func_70681_au();
                entity.func_130014_f_().func_184133_a(null, new BlockPos(entity.func_174824_e(1.0f)), TASounds.IMPULSE_CANNON_BEAM_END, SoundCategory.PLAYERS, (rand.nextFloat() - rand.nextFloat()) / 2.0f + 0.5f, (rand.nextFloat() - rand.nextFloat()) / 4.0f + 1.0f);
                PacketImpulseBeam packet = new PacketImpulseBeam(entity.func_145782_y(), true);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)entity);
                if (entity instanceof EntityPlayerMP) {
                    TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)entity);
                }
            } else if (aug.isTickable(entity)) {
                aug.onStopCannonTick(entity, timeLeft);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        IImpulseCannonAugment aug = this.getAugment(stack);
        if (aug != null) {
            return aug.getMaxUsageDuration();
        }
        return 72000;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p().func_74737_b());
        }
        tag.func_74782_a("cap", (NBTBase)new NBTTagCompound());
        tag.func_74775_l("cap").func_74782_a("augmentable", (NBTBase)((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).serializeNBT());
        tag.func_74775_l("cap").func_74782_a("energy", (NBTBase)((ImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).deserializeNBT(nbt.func_74775_l("cap").func_74775_l("augmentable"));
                ((ImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)).deserializeNBT(nbt.func_74775_l("cap").func_74775_l("energy"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ELDRITCH;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        if (energy != null) {
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.stored_energy", new Object[]{ImpetusAPI.getSuggestedChatColorForDescriptor(energy) + new TextComponentTranslation(ImpetusAPI.getEnergyAmountDescriptor(energy), new Object[0]).func_150254_d()}).func_150254_d());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        final ModelResourceLocation LENS_BEAM = new ModelResourceLocation("thaumicaugmentation:impulse_cannon_beam", "inventory");
        final ModelResourceLocation LENS_RAILGUN = new ModelResourceLocation("thaumicaugmentation:impulse_cannon_railgun", "inventory");
        final ModelResourceLocation LENS_BURST = new ModelResourceLocation("thaumicaugmentation:impulse_cannon_burst", "inventory");
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                IAugment aug;
                IAugmentableItem augments = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
                if (augments != null && augments.isAugmented() && (aug = (IAugment)augments.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IImpulseCannonAugment) {
                    switch (((IImpulseCannonAugment)aug).getLensModel()) {
                        case RAILGUN: {
                            return LENS_RAILGUN;
                        }
                        case BURST: {
                            return LENS_BURST;
                        }
                    }
                    return LENS_BEAM;
                }
                return LENS_BEAM;
            }
        });
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{LENS_BEAM, LENS_RAILGUN, LENS_BURST});
    }
}

