/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import baubles.api.BaubleType;
import baubles.api.cap.BaubleItem;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.augment.AugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.builder.IThaumostaticHarnessAugment;
import thecodex6824.thaumicaugmentation.api.entity.PlayerMovementAbilityManager;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderHarness;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import vazkii.botania.api.item.IPhantomInkable;

@Optional.Interface(iface="vazkii.botania.api.item.IPhantomInkable", modid="botania")
public class ItemThaumostaticHarness
extends ItemTABase
implements IRechargable,
IPhantomInkable {
    protected static final int DEFAULT_VIS_CAPACITY = 200;
    protected static final int DEFAULT_VIS_COST = 2;
    protected static final float DEFAULT_FLY_SPEED = 0.05f;

    public ItemThaumostaticHarness() {
        super(new String[0]);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected static int getHarnessVisCapacity(ItemStack stack) {
        IAugment aug;
        IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (item != null && (aug = (IAugment)item.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IThaumostaticHarnessAugment) {
            return ((IThaumostaticHarnessAugment)aug).getVisCapacity();
        }
        return 200;
    }

    protected static int getHarnessVisCost(ItemStack stack, EntityPlayer player) {
        IAugment aug;
        IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (item != null && (aug = (IAugment)item.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IThaumostaticHarnessAugment) {
            return ((IThaumostaticHarnessAugment)aug).getVisCostPerThreeSeconds(player);
        }
        return 2;
    }

    protected static float getHarnessFlySpeed(ItemStack stack, EntityPlayer player) {
        IAugment aug;
        IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (item != null && (aug = (IAugment)item.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IThaumostaticHarnessAugment) {
            return ((IThaumostaticHarnessAugment)aug).getFlySpeed(player);
        }
        return 0.05f;
    }

    protected static void applyHarnessDrift(ItemStack stack, EntityPlayer player) {
        IAugment aug;
        IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (item != null && (aug = (IAugment)item.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IThaumostaticHarnessAugment) {
            ((IThaumostaticHarnessAugment)aug).applyDrift(player);
            return;
        }
        player.field_70159_w *= (double)1.015f;
        player.field_70181_x *= (double)1.015f;
        player.field_70179_y *= (double)1.015f;
    }

    protected static boolean allowSprintFlying(ItemStack stack, EntityPlayer player) {
        IAugment aug;
        IAugmentableItem item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null);
        if (item != null && (aug = (IAugment)item.getAugment(0).getCapability(CapabilityAugment.AUGMENT, null)) instanceof IThaumostaticHarnessAugment) {
            return ((IThaumostaticHarnessAugment)aug).shouldAllowSprintFly(player);
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityProviderHarness provider = new CapabilityProviderHarness(new AugmentableItem(1){

            @Override
            public boolean isAugmentAcceptable(ItemStack augment, int slot) {
                return augment.getCapability(CapabilityAugment.AUGMENT, null) instanceof IThaumostaticHarnessAugment;
            }

            @Override
            public void setAugment(ItemStack augment, int slot) {
                super.setAugment(augment, slot);
                int difference = RechargeHelper.getCharge((ItemStack)stack) - ItemThaumostaticHarness.getHarnessVisCapacity(stack);
                if (difference > 0) {
                    RechargeHelper.consumeCharge((ItemStack)stack, null, (int)difference);
                }
            }

            @Override
            public ItemStack[] setAllAugments(ItemStack[] augs) {
                ItemStack[] ret = super.setAllAugments(augs);
                int difference = RechargeHelper.getCharge((ItemStack)stack) - ItemThaumostaticHarness.getHarnessVisCapacity(stack);
                if (difference > 0) {
                    RechargeHelper.consumeCharge((ItemStack)stack, null, (int)difference);
                }
                return ret;
            }
        }, new BaubleItem(BaubleType.BODY){

            public void onEquipped(ItemStack itemstack, EntityLivingBase entity) {
                if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    int cost = ItemThaumostaticHarness.getHarnessVisCost(itemstack, player);
                    float speed = ItemThaumostaticHarness.getHarnessFlySpeed(itemstack, player);
                    if (RechargeHelper.getCharge((ItemStack)itemstack) >= cost) {
                        PlayerMovementAbilityManager.recordFlyState(player);
                        player.field_71075_bZ.field_75101_c = true;
                        if (player.field_70170_p.field_72995_K) {
                            player.field_71075_bZ.field_75096_f = speed;
                        }
                        player.func_71016_p();
                    }
                }
            }

            public void onWornTick(ItemStack itemstack, EntityLivingBase entity) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    int cost = ItemThaumostaticHarness.getHarnessVisCost(itemstack, player);
                    if (player.field_71075_bZ.field_75100_b) {
                        int current = 0;
                        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("energyRemaining", 3)) {
                            current = stack.func_77978_p().func_74762_e("energyRemaining");
                        } else if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        if (current > 0) {
                            --current;
                        }
                        if (current <= 0 && RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)cost)) {
                            current = 60;
                        } else if (current <= 0 && !player.field_70170_p.field_72995_K && !PlayerMovementAbilityManager.popAndApplyFlyState(player)) {
                            if (!player.func_184812_l_() && !player.func_175149_v()) {
                                player.field_71075_bZ.field_75101_c = false;
                                player.field_71075_bZ.field_75100_b = false;
                            }
                            player.field_71075_bZ.field_75096_f = 0.05f;
                            player.func_71016_p();
                        }
                        stack.func_77978_p().func_74768_a("energyRemaining", current);
                        if (player.field_71075_bZ.field_75100_b && player.func_70051_ag() && !ItemThaumostaticHarness.allowSprintFlying(stack, player)) {
                            player.func_70031_b(false);
                        }
                        if (player.field_71075_bZ.field_75100_b) {
                            ItemThaumostaticHarness.applyHarnessDrift(stack, player);
                        }
                    } else if (!player.field_70170_p.field_72995_K && RechargeHelper.getCharge((ItemStack)itemstack) < cost) {
                        if (!PlayerMovementAbilityManager.popAndApplyFlyState(player)) {
                            if (!player.func_184812_l_() && !player.func_175149_v()) {
                                player.field_71075_bZ.field_75101_c = false;
                                player.field_71075_bZ.field_75100_b = false;
                            }
                            player.field_71075_bZ.field_75096_f = 0.05f;
                            player.func_71016_p();
                        }
                    } else if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75101_c) {
                        PlayerMovementAbilityManager.recordFlyState(player);
                        player.field_71075_bZ.field_75101_c = true;
                        player.field_71075_bZ.field_75096_f = ItemThaumostaticHarness.getHarnessFlySpeed(itemstack, player);
                        player.func_71016_p();
                    }
                }
            }

            public void onUnequipped(ItemStack itemstack, EntityLivingBase entity) {
                EntityPlayer player;
                if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !PlayerMovementAbilityManager.popAndApplyFlyState(player = (EntityPlayer)entity)) {
                    if (!player.func_184812_l_() && !player.func_175149_v()) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                    }
                    player.field_71075_bZ.field_75096_f = 0.05f;
                    player.func_71016_p();
                }
            }
        });
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
            return RechargeHelper.getCharge((ItemStack)stack);
        }
        return ItemThaumostaticHarness.getHarnessVisCapacity(stack);
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack arg0, EntityLivingBase arg1) {
        return IRechargable.EnumChargeDisplay.PERIODIC;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ARCANE;
    }

    @Optional.Method(modid="botania")
    public boolean hasPhantomInk(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("phantomInk");
        }
        return false;
    }

    @Optional.Method(modid="botania")
    public void setPhantomInk(ItemStack stack, boolean ink) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("phantomInk", ink);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            NBTTagCompound item = stack.func_77978_p().func_74737_b();
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                item.func_82580_o("cap");
            }
            tag.func_74782_a("item", (NBTBase)item);
        }
        tag.func_74782_a("cap", (NBTBase)((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }
}

