/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import com.google.common.math.DoubleMath;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.IThaumostaticHarnessAugment;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProviderNoSave;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;

public class ItemThaumostaticHarnessAugment
extends ItemTABase {
    public ItemThaumostaticHarnessAugment() {
        super("gyroscope", "girdle");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected IThaumostaticHarnessAugment createAugmentForStack(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return new HarnessAugment(){

                @Override
                public boolean shouldAllowSprintFly(EntityPlayer wearer) {
                    return false;
                }

                @Override
                public int getVisCostPerThreeSeconds(EntityPlayer wearer) {
                    return 1;
                }

                @Override
                public int getVisCapacity() {
                    return 150;
                }

                @Override
                public float getFlySpeed(EntityPlayer wearer) {
                    return 0.035f;
                }

                @Override
                public void applyDrift(EntityPlayer wearer) {
                    double factor = 1.0;
                    if (DoubleMath.fuzzyEquals((double)wearer.field_191988_bg, (double)0.0, (double)0.001) && DoubleMath.fuzzyEquals((double)wearer.field_70702_br, (double)0.0, (double)0.001)) {
                        factor = 0.75;
                    }
                    wearer.field_70159_w *= factor;
                    wearer.field_70181_x *= factor;
                    wearer.field_70179_y *= factor;
                }
            };
        }
        if (stack.func_77960_j() == 1) {
            return new HarnessAugment(){

                @Override
                public boolean shouldAllowSprintFly(EntityPlayer wearer) {
                    return true;
                }

                @Override
                public int getVisCostPerThreeSeconds(EntityPlayer wearer) {
                    return 3;
                }

                @Override
                public int getVisCapacity() {
                    return 250;
                }

                @Override
                public float getFlySpeed(EntityPlayer wearer) {
                    return 0.075f;
                }

                @Override
                public void applyDrift(EntityPlayer wearer) {
                    if (wearer.field_191988_bg == 0.0f && wearer.field_70702_br == 0.0f) {
                        wearer.field_70159_w *= 1.0199998617172241;
                        wearer.field_70181_x *= 1.0199998617172241;
                        wearer.field_70179_y *= 1.0199998617172241;
                    }
                }
            };
        }
        return new HarnessAugment(){

            @Override
            public boolean shouldAllowSprintFly(EntityPlayer wearer) {
                return false;
            }

            @Override
            public int getVisCostPerThreeSeconds(EntityPlayer wearer) {
                return 100000;
            }

            @Override
            public int getVisCapacity() {
                return 0;
            }

            @Override
            public float getFlySpeed(EntityPlayer wearer) {
                return 0.0f;
            }

            @Override
            public void applyDrift(EntityPlayer wearer) {
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        SimpleCapabilityProviderNoSave<IAugment> provider = new SimpleCapabilityProviderNoSave<IAugment>(this.createAugmentForStack(stack), CapabilityAugment.AUGMENT);
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    protected static abstract class HarnessAugment
    implements IThaumostaticHarnessAugment {
        protected HarnessAugment() {
        }

        @Override
        public boolean canBeAppliedToItem(ItemStack augmentable) {
            return augmentable.func_77973_b() == TAItems.THAUMOSTATIC_HARNESS;
        }

        @Override
        public boolean isCompatible(ItemStack otherAugment) {
            return !(otherAugment.getCapability(CapabilityAugment.AUGMENT, null) instanceof HarnessAugment);
        }
    }
}

