/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.api.items.RechargeHelper;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.entity.PlayerMovementAbilityManager;
import thecodex6824.thaumicaugmentation.api.item.IArmorReduceFallDamage;
import thecodex6824.thaumicaugmentation.api.item.IDyeableItem;
import thecodex6824.thaumicaugmentation.common.util.IModelProvider;

public class ItemVoidBoots
extends ItemArmor
implements IDyeableItem,
IModelProvider<Item>,
IArmorReduceFallDamage,
IRechargable,
IVisDiscountGear,
ISpecialArmor,
IWarpingGear {
    protected static final String TEXTURE_PATH = new ResourceLocation("thaumicaugmentation", "textures/models/armor/boots_void.png").toString();
    protected static final String TEXTURE_PATH_OVERLAY = new ResourceLocation("thaumicaugmentation", "textures/models/armor/boots_void_overlay.png").toString();
    protected static final BiFunction<EntityPlayer, PlayerMovementAbilityManager.MovementType, Float> MOVEMENT_FUNC = new BiFunction<EntityPlayer, PlayerMovementAbilityManager.MovementType, Float>(){

        @Override
        public Float apply(EntityPlayer player, PlayerMovementAbilityManager.MovementType type) {
            switch (type) {
                case DRY_GROUND: {
                    float boost = TAConfig.voidBootsLandSpeedBoost.getValue().floatValue();
                    return Float.valueOf(player.func_70093_af() ? boost / TAConfig.voidBootsSneakReduction.getValue().floatValue() : boost);
                }
                case JUMP_BEGIN: {
                    return Float.valueOf(TAConfig.voidBootsJumpBoost.getValue().floatValue());
                }
                case JUMP_FACTOR: {
                    return Float.valueOf(TAConfig.voidBootsJumpFactor.getValue().floatValue());
                }
                case STEP_HEIGHT: {
                    return Float.valueOf(!player.func_70093_af() ? TAConfig.voidBootsStepHeight.getValue().floatValue() : 0.0f);
                }
                case WATER_GROUND: {
                    float boost = Math.max(TAConfig.voidBootsLandSpeedBoost.getValue().floatValue() / 4.0f, TAConfig.voidBootsWaterSpeedBoost.getValue().floatValue());
                    return Float.valueOf(player.func_70093_af() ? boost / TAConfig.voidBootsSneakReduction.getValue().floatValue() : boost);
                }
                case WATER_SWIM: {
                    float boost = TAConfig.voidBootsWaterSpeedBoost.getValue().floatValue();
                    return Float.valueOf(player.func_70093_af() ? boost / TAConfig.voidBootsSneakReduction.getValue().floatValue() : boost);
                }
            }
            return Float.valueOf(0.0f);
        }
    };
    protected static final Predicate<EntityPlayer> CONTINUE_FUNC = new Predicate<EntityPlayer>(){

        @Override
        public boolean test(EntityPlayer player) {
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_77973_b() != TAItems.VOID_BOOTS) continue;
                return true;
            }
            return false;
        }
    };

    public ItemVoidBoots() {
        super(TAMaterials.VOID_BOOTS, 0, EntityEquipmentSlot.FEET);
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76379_h) {
            stack.func_77972_a(damage, entity);
        }
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        int priority = 0;
        double ratio = 0.04;
        if (source.func_82725_o()) {
            priority = 1;
            ratio = 0.028571428571429;
        } else if (source.func_76363_c()) {
            priority = 0;
            ratio = 0.0;
        }
        return new ISpecialArmor.ArmorProperties(priority, ratio, armor.func_77958_k() + 1 - armor.func_77952_i());
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return 5;
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return 3;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type == null ? TEXTURE_PATH : TEXTURE_PATH_OVERLAY;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            ItemStack base = new ItemStack((Item)this, 1, 0);
            items.add((Object)base);
            ItemStack charged = base.func_77946_l();
            RechargeHelper.rechargeItemBlindly((ItemStack)charged, null, (int)this.getMaxCharge(charged, null));
            items.add((Object)charged);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase entity) {
        return 480;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack arg0, EntityLivingBase arg1) {
        return IRechargable.EnumChargeDisplay.PERIODIC;
    }

    @Override
    public int getDefaultDyedColorForMeta(int meta) {
        return meta == 0 ? TAConfig.defaultVoidBootsColor.getValue() : 0;
    }

    @Override
    public int getDyedColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("color", 3)) {
            stack.func_77978_p().func_74768_a("color", this.getDefaultDyedColorForMeta(stack.func_77960_j()));
        }
        return stack.func_77978_p().func_74762_e("color");
    }

    @Override
    public void setDyedColor(ItemStack stack, int color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color);
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        return this.getDyedColor(stack);
    }

    public void func_82815_c(ItemStack stack) {
        this.setDyedColor(stack, this.getDefaultDyedColorForMeta(stack.func_77960_j()));
    }

    public void func_82813_b(ItemStack stack, int color) {
        this.setDyedColor(stack, color);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0 && this.getDyedColor(stack) != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            this.setDyedColor(stack, this.getDefaultDyedColorForMeta(stack.func_77960_j()));
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) - 1)));
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ELDRITCH;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == this.func_82812_d().repairMaterial.func_77973_b();
    }

    @Override
    public float getNewFallDamage(ItemStack stack, float origDamage, float distance) {
        if (RechargeHelper.getCharge((ItemStack)stack) > 0) {
            return origDamage / 6.0f - 1.0f;
        }
        return origDamage;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && player.field_70173_aa % 20 == 0) {
            if (stack.func_77952_i() > 0) {
                stack.func_96631_a(-1, player.func_70681_au(), player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null);
            }
            int current = 0;
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("energyRemaining", 3)) {
                current = stack.func_77978_p().func_74762_e("energyRemaining");
            } else if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (current > 0) {
                --current;
            }
            if (current <= 0 && RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)3)) {
                current = 60;
            }
            stack.func_77978_p().func_74768_a("energyRemaining", current);
        }
        if (PlayerMovementAbilityManager.isValidSideForMovement(player)) {
            boolean apply;
            boolean bl = apply = !player.field_71075_bZ.field_75100_b && !player.func_184613_cA() && RechargeHelper.getCharge((ItemStack)stack) > 0;
            if (apply && !PlayerMovementAbilityManager.playerHasAbility(player, MOVEMENT_FUNC, CONTINUE_FUNC)) {
                PlayerMovementAbilityManager.put(player, MOVEMENT_FUNC, CONTINUE_FUNC);
            } else if (!apply && PlayerMovementAbilityManager.playerHasAbility(player, MOVEMENT_FUNC, CONTINUE_FUNC)) {
                PlayerMovementAbilityManager.remove(player, MOVEMENT_FUNC, CONTINUE_FUNC);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int color = this.getDyedColor(stack);
        if (color != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            if (flag.func_194127_a()) {
                tooltip.add(new TextComponentTranslation("item.color", new Object[]{TextFormatting.GRAY + String.format("#%06X", color)}).func_150254_d());
            } else {
                tooltip.add(TextFormatting.ITALIC + new TextComponentTranslation("item.dyed", new Object[0]).func_150254_d());
            }
        }
    }
}

