/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusGraph;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.item.block.ItemBlockNoImpetusNodeNBT;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMirror;
import thecodex6824.thaumicaugmentation.common.util.IModelProvider;

public class ItemBlockImpetusMirror
extends ItemBlockNoImpetusNodeNBT
implements IModelProvider<Item> {
    public ItemBlockImpetusMirror() {
        super(TABlocks.IMPETUS_MIRROR);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("thaumicaugmentation", "linked"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 11) ? 1.0f : 0.0f;
            }
        });
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ELDRITCH;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity target;
        if (world.field_72995_K) {
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        if (world.func_175660_a(player, pos) && (target = world.func_175625_s(pos)) instanceof TileImpetusMirror) {
            TileImpetusMirror mirror = (TileImpetusMirror)target;
            IImpetusNode node = mirror.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null);
            DimensionalBlockPos ourPos = new DimensionalBlockPos(mirror.func_174877_v(), mirror.func_145831_w().field_73011_w.getDimension());
            if (mirror.getLink().isInvalid() || ((IImpetusGraph)node.getGraph()).findNodeByPosition(mirror.getLink()) == null) {
                ItemStack copy = player.func_184586_b(hand).func_77946_l();
                copy.func_190920_e(1);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74783_a("link", ourPos.toArray());
                copy.func_77982_d(tag);
                world.func_184133_a(null, pos, SoundsTC.jar, SoundCategory.BLOCKS, 1.0f, 2.0f);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                if (!player.field_71071_by.func_70441_a(copy)) {
                    world.func_72838_d(copy.func_77973_b().createEntity(world, (Entity)player, copy));
                }
                return EnumActionResult.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.mirror_already_linked", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity tile;
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (placed && !world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileImpetusMirror && stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 11)) {
            ((TileImpetusMirror)tile).setLink(new DimensionalBlockPos(stack.func_77978_p().func_74759_k("link")));
        }
        return placed;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(stack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, stack) && world.func_190527_a(this.field_150939_a, pos, false, facing, (Entity)player)) {
            int meta = this.func_77647_b(stack.func_77960_j());
            IBlockState placedState = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, placedState)) {
                placedState = world.func_180495_p(pos);
                SoundType soundtype = placedState.func_177230_c().getSoundType(placedState, world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        int[] data;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 11) && (data = stack.func_77978_p().func_74759_k("link")).length == 4) {
            String dimName;
            try {
                dimName = DimensionManager.getProviderType((int)data[3]).func_186065_b();
            }
            catch (IllegalArgumentException ex) {
                dimName = "Unknown";
            }
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.mirror_link", new Object[]{data[0], data[1], data[2], dimName}).func_150254_d());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }
}

