/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketParticleEffect
implements IMessage {
    public static int maxPacketData = 256;
    private double[] data;
    private ParticleEffect effect;

    public PacketParticleEffect() {
    }

    public PacketParticleEffect(ParticleEffect particle, double ... d) {
        this.effect = particle;
        this.data = d;
    }

    public void fromBytes(ByteBuf buf) {
        this.effect = ParticleEffect.fromID(buf.readInt());
        int length = buf.readInt();
        this.data = new double[length > maxPacketData ? maxPacketData : length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readDouble();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.effect.getID());
        buf.writeInt(this.data.length > maxPacketData ? maxPacketData : this.data.length);
        for (int i = 0; i < Math.min(this.data.length, maxPacketData); ++i) {
            buf.writeDouble(this.data[i]);
        }
    }

    public double[] getData() {
        return this.data;
    }

    public ParticleEffect getEffect() {
        return this.effect;
    }

    public static enum ParticleEffect {
        VIS_REGENERATOR(0),
        VOID_STREAKS(1),
        WARD(2),
        POOF(3),
        SMOKE_SPIRAL(4),
        CURLY_WISP(5),
        ESSENTIA_TRAIL(6),
        EXPLOSION(7),
        SPARK(8),
        FIRE(9),
        FIRE_EXPLOSION(10),
        GENERIC_SPHERE(11),
        SPLASH_BATCH(12),
        SMOKE_LARGE(13),
        FIRE_MULTIPLE_RAND(14),
        BLOCK_RUNES(15),
        FLUX(16),
        FLUX_BATCH(17),
        ARC(18);

        private int id;

        private ParticleEffect(int i) {
            this.id = i;
        }

        public int getID() {
            return this.id;
        }

        @Nullable
        public static ParticleEffect fromID(int id) {
            for (ParticleEffect effect : ParticleEffect.values()) {
                if (effect.getID() != id) continue;
                return effect;
            }
            return null;
        }
    }
}

