/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import thaumcraft.api.aspects.Aspect;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;

public class TileImpetusGenerator
extends TileEntity
implements ITickable,
IBreakCallback {
    protected SimpleImpetusConsumer node = new SimpleImpetusConsumer(1, 0){

        @Override
        public Vec3d getBeamEndpoint() {
            Vec3d position = new Vec3d((double)TileImpetusGenerator.this.field_174879_c.func_177958_n(), (double)TileImpetusGenerator.this.field_174879_c.func_177956_o(), (double)TileImpetusGenerator.this.field_174879_c.func_177952_p());
            IBlockState state = TileImpetusGenerator.this.field_145850_b.func_180495_p(TileImpetusGenerator.this.field_174879_c);
            if (state.func_177227_a().contains(IDirectionalBlock.DIRECTION)) {
                switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
                    case DOWN: {
                        return position.func_72441_c(0.5, 0.9, 0.5);
                    }
                    case EAST: {
                        return position.func_72441_c(0.1, 0.5, 0.5);
                    }
                    case NORTH: {
                        return position.func_72441_c(0.5, 0.5, 0.9);
                    }
                    case SOUTH: {
                        return position.func_72441_c(0.5, 0.5, 0.1);
                    }
                    case WEST: {
                        return position.func_72441_c(0.9, 0.5, 0.5);
                    }
                }
                return position.func_72441_c(0.5, 0.1, 0.5);
            }
            return position.func_72441_c(0.5, 0.4375, 0.5);
        }
    };
    protected CustomEnergyStorage forgeEnergy = new CustomEnergyStorage(3000, 1500, 30, 0);
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    public void func_73660_a() {
        IEnergyStorage other;
        EnumFacing facing;
        TileEntity neighbor;
        IBlockState state;
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 10 == 0 && ((Boolean)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue() && this.forgeEnergy.getEnergyStored() < this.forgeEnergy.getMaxEnergyStored() - 1500) {
            ConsumeResult result = this.node.consume(1L, false);
            if (result.energyConsumed == 1L) {
                this.forgeEnergy.receiveEnergy(1500, false);
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 6);
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                NodeHelper.syncAllImpetusTransactions(result.paths.keySet());
                for (Map.Entry<Deque<IImpetusNode>, Long> entry : result.paths.entrySet()) {
                    NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && (neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)))) != null && (other = (IEnergyStorage)neighbor.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) != null && other.canReceive()) {
            int extract = Math.min(this.forgeEnergy.getEnergyStored(), 50);
            if ((extract = other.receiveEnergy(extract, false)) > 0) {
                this.forgeEnergy.extractEnergy(extract, false);
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 6);
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            }
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.node.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.node);
    }

    @Override
    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
    }

    public void onChunkUnload() {
        this.node.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
    }

    public boolean func_145842_c(int id, int type) {
        ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 1.5f, Aspect.ELDRITCH.getColor(), false);
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        tag.func_74768_a("energy", this.forgeEnergy.getEnergyStored());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.node.deserializeNBT(nbt.func_74775_l("node"));
        this.forgeEnergy.setEnergy(nbt.func_74762_e("energy"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        tag.func_74768_a("energy", this.forgeEnergy.getEnergyStored());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.node.init(this.field_145850_b);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("energy", this.forgeEnergy.getEnergyStored());
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.forgeEnergy.setEnergy(pkt.func_148857_g().func_74762_e("energy"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY && facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        if (capability == CapabilityEnergy.ENERGY && facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.forgeEnergy);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected static class CustomEnergyStorage
    extends EnergyStorage {
        public CustomEnergyStorage(int capacity, int in, int out, int initial) {
            super(capacity, in, out, initial);
        }

        public void setEnergy(int newEnergy) {
            this.energy = newEnergy;
        }
    }
}

