/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.api.crafting.IInfusionStabiliserExt;
import thaumcraft.api.items.IGogglesDisplayExtended;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.IImpetusCellInfo;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.BufferedImpetusProsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;

public class TileImpetusMatrix
extends TileEntity
implements ITickable,
IBreakCallback,
IAnimatedTile,
IGogglesDisplayExtended {
    protected static final long CELL_CAPACITY = 500L;
    protected static final float MIN_STABILITY = -100.0f;
    protected static final float MAX_STABILITY = 25.0f;
    protected static final DecimalFormat STAB_FORMATTER = new DecimalFormat("#######.##");
    protected MatrixImpetusStorage buffer = new MatrixImpetusStorage();
    protected BufferedImpetusProsumer prosumer = new BufferedImpetusProsumer(1, 1, (IImpetusStorage)this.buffer){

        @Override
        public long onTransaction(Deque<IImpetusNode> path, long energy, boolean simulate) {
            if (!simulate) {
                TileImpetusMatrix.this.func_70296_d();
            }
            return energy;
        }
    };
    protected IAnimationStateMachine asm;
    protected float stability;
    protected float gain = -1.0f;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected int lastResult = -1;

    public TileImpetusMatrix() {
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/impetus_matrix.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)new TimeValues.VariableValue(20.0f), (Object)"delay", (Object)new TimeValues.VariableValue((float)this.ticks)));
    }

    protected float calculateStabilityGain() {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                check.func_181079_c(x + this.field_174879_c.func_177958_n(), 0, z + this.field_174879_c.func_177952_p());
                for (int y = -3; y < 4; ++y) {
                    Block b1;
                    check.func_185336_p(y + this.field_174879_c.func_177956_o());
                    if (!this.field_145850_b.func_175667_e((BlockPos)check) || !this.field_145850_b.func_175667_e(new BlockPos(-x + this.field_174879_c.func_177958_n(), y + this.field_174879_c.func_177956_o(), -z + this.field_174879_c.func_177952_p())) || (b1 = this.field_145850_b.func_180495_p((BlockPos)check).func_177230_c()) != Blocks.field_150465_bP && (!(b1 instanceof IInfusionStabiliser) || !((IInfusionStabiliser)b1).canStabaliseInfusion(this.field_145850_b, (BlockPos)check))) continue;
                    positions.add(check.func_185334_h());
                }
            }
        }
        float result = 0.0f;
        ArrayList<BlockPos> issues = new ArrayList<BlockPos>();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos negative = new BlockPos.MutableBlockPos();
        for (BlockPos positive : positions) {
            if (visited.contains(positive)) continue;
            negative.func_181079_c(-(positive.func_177958_n() - this.field_174879_c.func_177958_n()) + this.field_174879_c.func_177958_n(), positive.func_177956_o(), -(positive.func_177952_p() - this.field_174879_c.func_177952_p()) + this.field_174879_c.func_177952_p());
            float stab1 = 0.0f;
            float stab2 = 0.0f;
            Block b1 = this.field_145850_b.func_180495_p(positive).func_177230_c();
            Block b2 = this.field_145850_b.func_180495_p((BlockPos)negative).func_177230_c();
            if (b1 instanceof IInfusionStabiliserExt) {
                stab1 = ((IInfusionStabiliserExt)b1).getStabilizationAmount(this.field_145850_b, positive);
            } else if (b1 == Blocks.field_150465_bP || b1 instanceof IInfusionStabiliser) {
                stab1 = 0.1f;
            }
            if (b2 instanceof IInfusionStabiliserExt) {
                stab2 = ((IInfusionStabiliserExt)b2).getStabilizationAmount(this.field_145850_b, (BlockPos)negative);
            } else if (b2 == Blocks.field_150465_bP || b2 instanceof IInfusionStabiliser) {
                stab2 = 0.1f;
            }
            if (b1 == b2 && b1 != null && stab1 > 0.0f && DoubleMath.fuzzyEquals((double)stab1, (double)stab2, (double)1.0E-5f)) {
                if (b1 instanceof IInfusionStabiliserExt && ((IInfusionStabiliserExt)b1).hasSymmetryPenalty(this.field_145850_b, positive, (BlockPos)negative)) {
                    result -= ((IInfusionStabiliserExt)b1).getSymmetryPenalty(this.field_145850_b, positive);
                    issues.add(positive);
                } else {
                    int current = counts.getInt((Object)b1);
                    result = (float)((double)result + (current > 0 ? (double)stab1 * Math.pow(0.75, current) : (double)stab1));
                    counts.addTo((Object)b1, 1);
                }
            } else {
                result -= Math.max(stab1, stab2);
                issues.add(positive);
                issues.add(negative.func_185334_h());
            }
            visited.add(positive);
            visited.add(negative.func_185334_h());
        }
        for (BlockPos p : issues) {
            if (this.field_145850_b.field_73012_v.nextInt(25) != 0) continue;
            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 5.0, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 64.0));
        }
        return result;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.ticks % 10 == 0) {
            int level;
            if (this.ticks % 20 == 0) {
                NodeHelper.validateOutputs(this.field_145850_b, this.prosumer);
                this.buffer.validateEnergy();
                ConsumeResult result = this.prosumer.consume((long)this.getTotalCells() * 500L, false);
                if (result.energyConsumed > 0L) {
                    NodeHelper.syncAllImpetusTransactions(result.paths.keySet());
                    for (Map.Entry<Deque<IImpetusNode>, Long> entry : result.paths.entrySet()) {
                        NodeHelper.damageEntitiesFromTransaction(entry.getKey(), entry.getValue());
                    }
                }
            }
            float oldGain = this.gain;
            this.gain = this.calculateStabilityGain();
            float oldStab = this.stability;
            this.stability -= this.field_145850_b.field_73012_v.nextFloat() * this.getStabilityLossPerSecond();
            this.stability += this.gain;
            this.stability = Math.max(Math.min(this.stability, 25.0f), -100.0f);
            if (this.stability < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(1500) <= Math.abs(this.stability)) {
                if (this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                    IBlockState state;
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
                        int info = (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
                        if (IImpetusCellInfo.getNumberOfCells(info) > 0) {
                            ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>(IImpetusCellInfo.getCellDirections(info));
                            EnumFacing selected = dirs.get(this.field_145850_b.field_73012_v.nextInt(dirs.size()));
                            this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(info, selected, false))));
                            EntityItem drop = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 * (1.0 - (double)Math.abs(selected.func_82601_c())) + (double)selected.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 1.0 + 0.5 * (1.0 - (double)Math.abs(selected.func_96559_d())) + (double)selected.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 * (1.0 - (double)Math.abs(selected.func_82599_e())) + (double)selected.func_82599_e(), new ItemStack(TAItems.MATERIAL, 1, 3));
                            drop.field_70159_w = (double)selected.func_82601_c() * 0.05;
                            drop.field_70181_x = (double)selected.func_96559_d() * 0.05;
                            drop.field_70179_y = (double)selected.func_82599_e() * 0.05;
                            this.field_145850_b.func_72838_d((Entity)drop);
                        } else {
                            state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                            info = (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
                            if (IImpetusCellInfo.getNumberOfCells(info) > 0) {
                                ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>(IImpetusCellInfo.getCellDirections(info));
                                EnumFacing selected = dirs.get(this.field_145850_b.field_73012_v.nextInt(dirs.size()));
                                this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(info, selected, false))));
                                EntityItem drop = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 * (1.0 - (double)Math.abs(selected.func_82601_c())) + (double)selected.func_82601_c(), (double)this.field_174879_c.func_177956_o() - 1.0 + 0.5 * (1.0 - (double)Math.abs(selected.func_96559_d())) + (double)selected.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 * (1.0 - (double)Math.abs(selected.func_82599_e())) + (double)selected.func_82599_e(), new ItemStack(TAItems.MATERIAL, 1, 3));
                                drop.field_70159_w = (double)selected.func_82601_c() * 0.05;
                                drop.field_70181_x = (double)selected.func_96559_d() * 0.05;
                                drop.field_70179_y = (double)selected.func_82599_e() * 0.05;
                                this.field_145850_b.func_72838_d((Entity)drop);
                            }
                        }
                    } else {
                        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                        int info = (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
                        if (IImpetusCellInfo.getNumberOfCells(info) > 0) {
                            ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>(IImpetusCellInfo.getCellDirections(info));
                            EnumFacing selected = dirs.get(this.field_145850_b.field_73012_v.nextInt(dirs.size()));
                            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(info, selected, false))));
                            EntityItem drop = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 * (1.0 - (double)Math.abs(selected.func_82601_c())) + (double)selected.func_82601_c(), (double)this.field_174879_c.func_177956_o() - 1.0 + 0.5 * (1.0 - (double)Math.abs(selected.func_96559_d())) + (double)selected.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 * (1.0 - (double)Math.abs(selected.func_82599_e())) + (double)selected.func_82599_e(), new ItemStack(TAItems.MATERIAL, 1, 3));
                            drop.field_70159_w = (double)selected.func_82601_c() * 0.05;
                            drop.field_70181_x = (double)selected.func_96559_d() * 0.05;
                            drop.field_70179_y = (double)selected.func_82599_e() * 0.05;
                            this.field_145850_b.func_72838_d((Entity)drop);
                        } else {
                            state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
                            info = (Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO);
                            if (IImpetusCellInfo.getNumberOfCells(info) > 0) {
                                ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>(IImpetusCellInfo.getCellDirections(info));
                                EnumFacing selected = dirs.get(this.field_145850_b.field_73012_v.nextInt(dirs.size()));
                                this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), state.func_177226_a((IProperty)IImpetusCellInfo.CELL_INFO, (Comparable)Integer.valueOf(IImpetusCellInfo.setCellPresent(info, selected, false))));
                                EntityItem drop = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 * (1.0 - (double)Math.abs(selected.func_82601_c())) + (double)selected.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 1.0 + 0.5 * (1.0 - (double)Math.abs(selected.func_96559_d())) + (double)selected.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 * (1.0 - (double)Math.abs(selected.func_82599_e())) + (double)selected.func_82599_e(), new ItemStack(TAItems.MATERIAL, 1, 3));
                                drop.field_70159_w = (double)selected.func_82601_c() * 0.05;
                                drop.field_70181_x = (double)selected.func_96559_d() * 0.05;
                                drop.field_70179_y = (double)selected.func_82599_e() * 0.05;
                                this.field_145850_b.func_72838_d((Entity)drop);
                            }
                        }
                    }
                    this.buffer.validateEnergy();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.grind, SoundCategory.BLOCKS, 0.6f, 1.0f);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.shock, SoundCategory.BLOCKS, 0.6f, 1.0f);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 25.0, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                } else {
                    long discharge = (long)((float)this.getTotalCells() * this.field_145850_b.field_73012_v.nextFloat() * 50.0f);
                    discharge = this.buffer.extractEnergy(discharge, false);
                    for (Entity e : this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(2.5))) {
                        ImpetusAPI.causeImpetusDamage(new Vec3d((Vec3i)this.field_174879_c), e, Math.max((float)discharge / 10.0f, 1.0f));
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.ARC, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, Aspect.ELDRITCH.getColor(), e.field_70131_O), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.shock, SoundCategory.BLOCKS, 0.6f, 1.0f);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 15.0, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                }
            }
            if ((level = this.getComparatorOutput()) != this.lastResult) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.field_145850_b.func_175666_e(this.field_174879_c.func_177977_b(), this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c());
                this.field_145850_b.func_175666_e(this.field_174879_c.func_177984_a(), this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c());
                this.lastResult = level;
            }
            if (!DoubleMath.fuzzyEquals((double)this.gain, (double)oldGain, (double)1.0E-5) || !DoubleMath.fuzzyEquals((double)this.stability, (double)oldStab, (double)1.0E-5)) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public int getTotalCells() {
        int total = 0;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (state.func_177227_a().contains(IImpetusCellInfo.CELL_INFO)) {
            total += IImpetusCellInfo.getNumberOfCells((Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
        }
        if ((state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_177227_a().contains(IImpetusCellInfo.CELL_INFO)) {
            total += IImpetusCellInfo.getNumberOfCells((Integer)state.func_177229_b((IProperty)IImpetusCellInfo.CELL_INFO));
        }
        return total;
    }

    public int getComparatorOutput() {
        return (int)((double)this.buffer.getEnergyStored() / (double)this.buffer.getMaxEnergyStored() * 15.0);
    }

    protected float getStabilityLossPerSecond() {
        long max = this.buffer.getMaxEnergyStored();
        if (max <= 0L) {
            return -0.05f;
        }
        return (float)((double)this.buffer.getEnergyStored() / (double)((long)this.getTotalCells() * 500L));
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.prosumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.prosumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.prosumer.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.prosumer);
    }

    @Override
    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.prosumer);
        }
        this.prosumer.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.prosumer);
    }

    public void onChunkUnload() {
        this.prosumer.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.prosumer);
    }

    public String[] getIGogglesText() {
        String stabName = null;
        stabName = this.stability > 12.5f ? "stability.VERY_STABLE" : (this.stability >= 0.0f ? "stability.STABLE" : (this.stability > -25.0f ? "stability.UNSTABLE" : "stability.VERY_UNSTABLE"));
        float loss = this.getStabilityLossPerSecond();
        if (loss > 0.0f) {
            return new String[]{TextFormatting.BOLD + new TextComponentTranslation(stabName, new Object[0]).func_150254_d(), TextFormatting.GOLD + "" + TextFormatting.ITALIC + STAB_FORMATTER.format(this.gain) + " " + new TextComponentTranslation("stability.gain", new Object[0]).func_150254_d(), TextFormatting.RED + "" + TextFormatting.ITALIC + new TextComponentTranslation("stability.range", new Object[0]).func_150254_d() + TextFormatting.RED + TextFormatting.ITALIC + STAB_FORMATTER.format(loss) + " " + new TextComponentTranslation("stability.loss", new Object[0]).func_150254_d()};
        }
        return new String[]{TextFormatting.BOLD + new TextComponentTranslation(stabName, new Object[0]).func_150254_d(), TextFormatting.GOLD + "" + TextFormatting.ITALIC + STAB_FORMATTER.format(this.gain) + " " + new TextComponentTranslation("stability.gain", new Object[0]).func_150254_d()};
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.prosumer.serializeNBT());
        tag.func_74776_a("gain", this.gain);
        tag.func_74776_a("stab", this.stability);
        tag.func_74772_a("energy", this.buffer.energy);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.gain = tag.func_74760_g("gain");
        this.prosumer.init(this.field_145850_b);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("gain", this.gain);
        tag.func_74776_a("stab", this.stability);
        tag.func_74772_a("energy", this.buffer.getEnergyStored());
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.gain = pkt.func_148857_g().func_74760_g("gain");
        this.stability = pkt.func_148857_g().func_74760_g("stab");
        this.buffer.energy = pkt.func_148857_g().func_74763_f("energy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.prosumer.serializeNBT());
        tag.func_74772_a("energy", this.buffer.energy);
        tag.func_74776_a("stab", this.stability);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.buffer.energy = nbt.func_74763_f("energy");
        this.prosumer.deserializeNBT(nbt.func_74775_l("node"));
        this.stability = nbt.func_74760_g("stab");
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE || capability == CapabilityImpetusStorage.IMPETUS_STORAGE || capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.prosumer);
        }
        if (capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return (T)CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.buffer);
        }
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected class MatrixImpetusStorage
    implements IImpetusStorage {
        protected long energy;

        protected MatrixImpetusStorage() {
        }

        @Override
        public boolean canExtract() {
            return true;
        }

        @Override
        public boolean canReceive() {
            return true;
        }

        @Override
        public long getEnergyStored() {
            return this.energy;
        }

        @Override
        public long getMaxEnergyStored() {
            return (long)TileImpetusMatrix.this.getTotalCells() * 500L;
        }

        @Override
        public long extractEnergy(long maxEnergy, boolean simulate) {
            if (this.canExtract()) {
                long amount = Math.min((long)(5 * TileImpetusMatrix.this.getTotalCells()), Math.min(this.energy, Math.min((long)TileImpetusMatrix.this.getTotalCells() * 500L, maxEnergy)));
                if (!simulate) {
                    this.energy -= amount;
                    this.onEnergyChanged();
                }
                return amount;
            }
            return 0L;
        }

        @Override
        public long receiveEnergy(long maxEnergy, boolean simulate) {
            if (this.canReceive()) {
                long amount = Math.min(Math.min((long)TileImpetusMatrix.this.getTotalCells() * 500L, maxEnergy), this.getMaxEnergyStored() - this.energy);
                if (!simulate) {
                    this.energy += amount;
                    this.onEnergyChanged();
                }
                return amount;
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged() {
            TileImpetusMatrix.this.func_70296_d();
            TileImpetusMatrix.this.field_145850_b.func_184138_a(TileImpetusMatrix.this.field_174879_c, TileImpetusMatrix.this.field_145850_b.func_180495_p(TileImpetusMatrix.this.field_174879_c), TileImpetusMatrix.this.field_145850_b.func_180495_p(TileImpetusMatrix.this.field_174879_c), 3);
        }

        public void validateEnergy() {
            long old = this.energy;
            this.energy = Math.max(Math.min(this.energy, (long)TileImpetusMatrix.this.getTotalCells() * 500L), 0L);
            if (old != this.energy) {
                this.onEnergyChanged();
            }
        }
    }
}

