/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.tile.CapabilityRiftJar;
import thecodex6824.thaumicaugmentation.api.tile.IRiftJar;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;
import thecodex6824.thaumicaugmentation.api.util.RiftHelper;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;

public class TileRiftMoverInput
extends TileEntity
implements ITickable,
IInteractWithCaster,
IBreakCallback {
    protected boolean operating;
    protected int oldSize;
    protected int oldSeed;
    protected float oldStability;
    protected EntityFluxRift rift;
    protected UUID loadedRiftUUID;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected ISoundHandle loop;

    protected EntityFluxRift findRift() {
        BlockPos pos1 = this.field_174879_c.func_177982_a(-1, 1, -1);
        BlockPos pos2 = this.field_174879_c.func_177982_a(1, 6, 1);
        List rifts = this.field_145850_b.func_72872_a(EntityFluxRift.class, new AxisAlignedBB((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p(), (double)(pos2.func_177958_n() + 1), (double)(pos2.func_177956_o() + 1), (double)(pos2.func_177952_p() + 1)));
        if (!rifts.isEmpty()) {
            rifts.sort((rift1, rift2) -> (int)(rift1.func_180425_c().func_177951_i((Vec3i)this.field_174879_c) - rift2.func_180425_c().func_177951_i((Vec3i)this.field_174879_c)));
            for (EntityFluxRift maybe : rifts) {
                RayTraceResult trace = this.field_145850_b.func_72933_a(new Vec3d((Vec3i)this.field_174879_c.func_177982_a(0, 1, 0)), new Vec3d((Vec3i)maybe.func_180425_c()));
                if (trace != null && trace.field_72307_f != null) continue;
                return maybe;
            }
        }
        return null;
    }

    public boolean onCasterRightClick(World w, ItemStack stack, EntityPlayer player, BlockPos position, EnumFacing face, EnumHand hand) {
        if (!this.field_145850_b.field_72995_K && !this.operating) {
            IRiftJar jar;
            TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (below != null && (jar = (IRiftJar)below.getCapability(CapabilityRiftJar.RIFT_JAR, null)) != null) {
                this.rift = this.findRift();
                if (this.rift != null && !this.rift.field_70128_L && this.rift.getRiftSize() > 0 && !this.rift.getCollapse()) {
                    this.operating = true;
                    this.oldSize = this.rift.getRiftSize();
                    this.oldSeed = this.rift.getRiftSeed();
                    this.oldStability = this.rift.getRiftStability();
                    this.func_70296_d();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftstart, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                } else {
                    this.rift = null;
                }
            }
            return true;
        }
        return this.field_145850_b.field_72995_K && !this.operating;
    }

    public void onLoad() {
        if (this.operating && this.loadedRiftUUID != null) {
            EntityFluxRift check = this.findRift();
            if (check != null && check.func_110124_au().equals(this.loadedRiftUUID)) {
                this.rift = check;
            }
            this.loadedRiftUUID = null;
        }
    }

    protected int getParticleDelay(int size) {
        if (size < 11) {
            return 20;
        }
        if (size < 30) {
            return 10;
        }
        return 5;
    }

    public void func_73660_a() {
        if (this.operating) {
            if (!this.field_145850_b.field_72995_K && this.ticks++ % 10 == 0) {
                TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (this.rift == null || this.rift.field_70128_L || this.rift.getRiftSize() < 1 || this.rift.getCollapse() || below == null || !below.hasCapability(CapabilityRiftJar.RIFT_JAR, null) || ((IRiftJar)below.getCapability(CapabilityRiftJar.RIFT_JAR, null)).hasRift()) {
                    if (this.rift == null || this.rift.field_70128_L) {
                        AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.oldSize, (boolean)true);
                    } else {
                        if (this.rift.getCollapse()) {
                            this.rift.setCollapse(false);
                        }
                        this.rift.setRiftStability(-150.0f);
                        this.rift.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 0.75f);
                        Vec3d riftCenter = RiftHelper.getRiftCenter(this.rift);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.EXPLOSION, riftCenter.field_72450_a, riftCenter.field_72448_b, riftCenter.field_72449_c), (Entity)this.rift);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, riftCenter.field_72450_a, riftCenter.field_72448_b, riftCenter.field_72449_c, 5.0, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                        this.rift = null;
                    }
                    this.operating = false;
                    this.func_70296_d();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                } else if ((double)AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.25f, (boolean)false) >= 0.2499) {
                    this.rift.setRiftSize(this.rift.getRiftSize() - 1);
                    this.rift.setRiftStability(this.rift.getRiftStability() - 0.5f);
                    if (this.rift.getRiftSize() == 0) {
                        ((IRiftJar)below.getCapability(CapabilityRiftJar.RIFT_JAR, null)).setRift(new FluxRiftReconstructor(this.oldSeed, this.oldSize));
                        this.rift = null;
                        this.operating = false;
                        this.func_70296_d();
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    }
                }
            } else if (this.field_145850_b.field_72995_K) {
                if (this.loadedRiftUUID != null) {
                    this.rift = this.findRift();
                    if (!this.rift.func_110124_au().equals(this.loadedRiftUUID)) {
                        this.rift = null;
                    } else if (this.rift != null) {
                        if (this.loop != null) {
                            this.loop.stop();
                        }
                        this.loop = ThaumicAugmentation.proxy.playSpecialSound(TASounds.RIFT_MOVER_INPUT_LOOP, SoundCategory.BLOCKS, old -> this.operating && this.rift != null ? old : null, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 4.0f, 1.0f, true, 0);
                    }
                    this.loadedRiftUUID = null;
                }
                if (this.rift != null && this.ticks % this.getParticleDelay(this.rift.getRiftSize()) == 0) {
                    Vec3d particlePos = RiftHelper.pickRandomPointOnRift(this.rift).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                    Vec3d dir = particlePos.func_178788_d(new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5)).func_72432_b();
                    ThaumicAugmentation.proxy.getRenderHelper().renderRiftMoverParticle(this.field_145850_b, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, -dir.field_72450_a * 0.25, -dir.field_72448_b * 0.25, -dir.field_72449_c * 0.25);
                    if (!TAConfig.reducedEffects.getValue().booleanValue()) {
                        particlePos = RiftHelper.pickRandomPointOnRift(this.rift).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                        ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 5.0f + this.field_145850_b.field_73012_v.nextFloat() * 7.5f, Aspect.ELDRITCH.getColor(), false);
                        if (this.field_145850_b.field_73012_v.nextBoolean()) {
                            particlePos = RiftHelper.pickRandomPointOnRiftWithInstability(this.rift, Minecraft.func_71410_x().field_71439_g.field_70173_aa, Minecraft.func_71410_x().func_184121_ak()).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                            ThaumicAugmentation.proxy.getRenderHelper().renderArc(this.field_145850_b, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, Aspect.ELDRITCH.getColor(), this.rift.field_70131_O / 2.0f);
                        }
                    }
                }
                ++this.ticks;
            }
        }
    }

    @Override
    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K && this.operating) {
            if (this.rift == null || this.rift.field_70128_L) {
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.oldSize, (boolean)true);
            } else {
                if (this.rift.getCollapse()) {
                    this.rift.setCollapse(false);
                }
                this.rift.setRiftStability(-150.0f);
                this.rift.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 0.75f);
                Vec3d riftCenter = RiftHelper.getRiftCenter(this.rift);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.EXPLOSION, riftCenter.field_72450_a, riftCenter.field_72448_b, riftCenter.field_72449_c), (Entity)this.rift);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, riftCenter.field_72450_a, riftCenter.field_72448_b, riftCenter.field_72449_c, 5.0, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                this.rift = null;
            }
            this.operating = false;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
        } else if (this.field_145850_b.field_72995_K && this.loop != null) {
            this.loop.stop();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loop != null) {
            this.loop.stop();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("operating", this.operating);
        if (this.operating && this.rift != null) {
            tag.func_186854_a("rift", this.rift.func_110124_au());
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        EntityFluxRift check;
        this.operating = pkt.func_148857_g().func_74767_n("operating");
        if (this.operating && (check = this.findRift()) != null && check.func_110124_au().equals(pkt.func_148857_g().func_186857_a("rift"))) {
            this.rift = check;
            if (this.loop != null) {
                this.loop.stop();
            }
            this.loop = ThaumicAugmentation.proxy.playSpecialSound(TASounds.RIFT_MOVER_INPUT_LOOP, SoundCategory.BLOCKS, old -> this.operating && this.rift != null ? old : null, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 4.0f, 1.0f, true, 0);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("operating", this.operating);
        if (this.operating && (this.rift != null || this.loadedRiftUUID != null)) {
            tag.func_186854_a("rift", this.rift != null ? this.rift.func_110124_au() : this.loadedRiftUUID);
        }
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("operating", this.operating);
        if (this.operating) {
            compound.func_74768_a("size", this.oldSize);
            compound.func_74768_a("seed", this.oldSeed);
            compound.func_74776_a("stab", this.oldStability);
            if (this.rift != null) {
                compound.func_186854_a("rift", this.rift.func_110124_au());
            }
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.operating = compound.func_74767_n("operating");
        if (this.operating) {
            this.oldSize = compound.func_74762_e("size");
            this.oldSeed = compound.func_74762_e("seed");
            this.oldStability = compound.func_74760_g("stab");
            this.loadedRiftUUID = compound.func_186857_a("rift");
        }
    }
}

