/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.beams.FXBeamBore;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.util.RiftHelper;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileStabilityFieldGenerator
extends TileEntity
implements ITickable,
IBreakCallback,
IAnimatedTile {
    protected static final float MAX_STABILITY = 4.0f;
    protected UUID serverLoadedID;
    protected WeakReference<EntityFluxRift> targetedRift = new WeakReference<Object>(null);
    protected CustomEnergyStorage energy = new CustomEnergyStorage(1000, 1000, 1000, 0);
    protected float maxStabilityPerOperation = 4.0f;
    protected int ticks;
    protected int clientLoadedID;
    protected boolean lastEnabledState;
    protected Object beam;
    protected IAnimationStateMachine asm;
    protected TimeValues.VariableValue cycleLength = new TimeValues.VariableValue(1.0f);
    protected TimeValues.VariableValue actionTime = new TimeValues.VariableValue(-1.0f);

    public TileStabilityFieldGenerator() {
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/stability_field_generator.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)this.cycleLength, (Object)"act_time", (Object)this.actionTime));
        this.ticks = ThreadLocalRandom.current().nextInt(20);
    }

    protected double getDistForFace(EnumFacing face, Entity entity) {
        return this.getDistForFace(face, entity.func_174791_d());
    }

    protected double getDistForFace(EnumFacing face, Vec3d vec) {
        if (face.func_176740_k() == EnumFacing.Axis.X) {
            return Math.abs((double)this.field_174879_c.func_177958_n() - vec.field_72450_a);
        }
        if (face.func_176740_k() == EnumFacing.Axis.Y) {
            return Math.abs((double)this.field_174879_c.func_177956_o() - vec.field_72448_b);
        }
        return Math.abs((double)this.field_174879_c.func_177952_p() - vec.field_72449_c);
    }

    @Nullable
    protected EntityFluxRift findClosestRift(EnumFacing face) {
        BlockPos pos1 = this.field_174879_c.func_177972_a(face).func_177963_a(1.0 - (double)face.func_82601_c(), 1.0 - (double)face.func_96559_d(), 1.0 - (double)face.func_82599_e());
        BlockPos pos2 = this.field_174879_c.func_177967_a(face, 8).func_177963_a(1.0 + (double)face.func_82601_c(), 1.0 + (double)face.func_96559_d(), 1.0 + (double)face.func_82599_e());
        List rifts = this.field_145850_b.func_175647_a(EntityFluxRift.class, new AxisAlignedBB((double)(pos1.func_177958_n() - 1), (double)(pos1.func_177956_o() - 1), (double)(pos1.func_177952_p() - 1), (double)(pos2.func_177958_n() + 2), (double)(pos2.func_177956_o() + 2), (double)(pos2.func_177952_p() + 2)), rift -> rift != null && !rift.getCollapse());
        if (!rifts.isEmpty()) {
            rifts.sort((rift1, rift2) -> Double.compare(this.getDistForFace(face, (Entity)rift1), this.getDistForFace(face, (Entity)rift2)));
            RayTraceResult trace = this.field_145850_b.func_72933_a(new Vec3d((Vec3i)this.field_174879_c.func_177972_a(face)), new Vec3d((Vec3i)this.field_174879_c.func_177967_a(face, 8)));
            EntityFluxRift chosenOne = (EntityFluxRift)rifts.get(0);
            if (trace == null || trace.field_72307_f == null || this.getDistForFace(face, (Entity)chosenOne) < this.getDistForFace(face, trace.field_72307_f)) {
                return chosenOne;
            }
        }
        return null;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.lastEnabledState = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED);
        }
    }

    protected void loadTargetFromID() {
        if (!this.field_145850_b.field_72995_K) {
            List test = this.field_145850_b.func_175644_a(EntityFluxRift.class, e -> e != null && e.func_110124_au().equals(this.serverLoadedID));
            if (!test.isEmpty()) {
                this.targetedRift = new WeakReference(test.get(0));
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 1);
            }
        } else {
            List test = this.field_145850_b.func_175644_a(EntityFluxRift.class, e -> e != null && e.func_145782_y() == this.clientLoadedID);
            if (!test.isEmpty()) {
                this.targetedRift = new WeakReference(test.get(0));
                this.updateBeam();
                this.clientLoadedID = -1;
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 5 == 0) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue()) {
                int result = this.energy.extractEnergy(5, true);
                if (result == 5) {
                    this.energy.extractEnergy(5, false);
                    EntityFluxRift rift = (EntityFluxRift)this.targetedRift.get();
                    if (rift == null || rift.field_70128_L) {
                        if (this.serverLoadedID != null) {
                            this.loadTargetFromID();
                        }
                        if ((rift = (EntityFluxRift)this.targetedRift.get()) == null || rift.field_70128_L) {
                            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION);
                            rift = this.findClosestRift(face);
                            if (rift != null) {
                                this.targetedRift = new WeakReference<EntityFluxRift>(rift);
                                this.serverLoadedID = rift.getPersistentID();
                            } else {
                                this.targetedRift.clear();
                                this.serverLoadedID = null;
                            }
                            this.func_70296_d();
                            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                        } else {
                            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                        }
                    }
                    if (rift != null && !rift.field_70128_L) {
                        boolean update = false;
                        if (rift.getCollapse()) {
                            BlockPos boom = this.field_174879_c.func_177972_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION));
                            this.field_145850_b.func_72876_a(null, (double)boom.func_177958_n(), (double)boom.func_177956_o(), (double)boom.func_177952_p(), 2.0f, true);
                            this.targetedRift.clear();
                            this.serverLoadedID = null;
                            this.func_70296_d();
                            update = true;
                        } else if (rift.getRiftStability() < 100.0f && this.energy.extractEnergy(20, true) == 20) {
                            this.energy.extractEnergy(20, false);
                            rift.setRiftStability(rift.getRiftStability() + this.maxStabilityPerOperation);
                            this.func_70296_d();
                            update = true;
                        }
                        float old = this.maxStabilityPerOperation;
                        this.maxStabilityPerOperation = Math.max(this.maxStabilityPerOperation * 0.95f, 0.05f);
                        if (!DoubleMath.fuzzyEquals((double)old, (double)this.maxStabilityPerOperation, (double)1.0E-5f)) {
                            this.func_70296_d();
                            update = true;
                        }
                        if (update) {
                            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                        }
                    }
                } else if (this.targetedRift.get() != null) {
                    this.targetedRift.clear();
                    this.serverLoadedID = null;
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                }
            } else {
                float old = this.maxStabilityPerOperation;
                this.maxStabilityPerOperation = Math.min(Math.max(0.05f, this.maxStabilityPerOperation * 1.025f), 4.0f);
                if (!DoubleMath.fuzzyEquals((double)old, (double)this.maxStabilityPerOperation, (double)1.0E-5f)) {
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                }
            }
        } else if (this.field_145850_b.field_72995_K && this.ticks++ % 5 == 0) {
            boolean on;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = on = state.func_177227_a().contains(IEnabledBlock.ENABLED) && (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED) != false;
            if (!on) {
                this.targetedRift.clear();
            }
            if (on != this.lastEnabledState) {
                this.lastEnabledState = on;
                this.updateBeam();
            }
            if (this.field_145850_b.field_73012_v.nextFloat() > this.maxStabilityPerOperation / 4.0f) {
                ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 5.0f, 0xAA0000, false);
            }
            EntityFluxRift rift = (EntityFluxRift)this.targetedRift.get();
            if (on && (rift == null || rift.field_70128_L) && this.clientLoadedID != -1) {
                this.loadTargetFromID();
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    protected void updateBeam() {
        EntityFluxRift rift = (EntityFluxRift)this.targetedRift.get();
        if (!(rift == null || rift.field_70128_L || !this.lastEnabledState || this.beam != null && ((FXBeamBore)this.beam).func_187113_k())) {
            Vec3d dest = RiftHelper.getRiftCenter(rift).func_72441_c(rift.field_70165_t, rift.field_70163_u, rift.field_70161_v);
            EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION);
            double offsetX = 0.0;
            double offsetY = 0.0;
            double offsetZ = 0.0;
            switch (face.func_176740_k()) {
                case X: {
                    offsetX = face.func_82601_c() > 0 ? 0.8125 : 0.1875;
                    offsetY = 0.5;
                    offsetZ = 0.5;
                    break;
                }
                case Y: {
                    offsetX = 0.5;
                    offsetY = face.func_96559_d() > 0 ? 0.8125 : 0.1875;
                    offsetZ = 0.5;
                    break;
                }
                case Z: {
                    offsetX = 0.5;
                    offsetY = 0.5;
                    offsetZ = face.func_82599_e() > 0 ? 0.8125 : 0.1875;
                    break;
                }
            }
            float mod = this.maxStabilityPerOperation / 10000.0f;
            int color = (int)(255.0f * (mod / 4.0f)) << 16 | (int)(191.0f * (mod / 4.0f)) << 8;
            this.beam = FXDispatcher.INSTANCE.beamBore((double)this.field_174879_c.func_177958_n() + offsetX, (double)this.field_174879_c.func_177956_o() + offsetY, (double)this.field_174879_c.func_177952_p() + offsetZ, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, 1, color, false, 0.05f, this.beam, 0);
            ((FXBeamBore)this.beam).func_187114_a(Integer.MAX_VALUE);
            this.updateBeamColor();
            this.actionTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
            AnimationHelper.transitionSafely(this.asm, "opening");
        } else if ((rift == null || rift.field_70128_L || !this.lastEnabledState) && this.beam != null) {
            if (((FXBeamBore)this.beam).func_187113_k()) {
                this.actionTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
                AnimationHelper.transitionSafely(this.asm, "closing");
            }
            ((FXBeamBore)this.beam).func_187112_i();
        }
    }

    protected void updateBeamColor() {
        if (this.beam != null && ((FXBeamBore)this.beam).func_187113_k()) {
            ((FXBeamBore)this.beam).func_70538_b(Math.max(this.maxStabilityPerOperation / 4.0f, 0.01f), Math.max(0.75f * (this.maxStabilityPerOperation / 4.0f), 0.0075f), 0.0f);
        }
    }

    @Override
    public void onBlockBroken() {
        this.targetedRift.clear();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            return true;
        }
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        Entity e = (Entity)this.targetedRift.get();
        tag.func_74768_a("riftID", e != null ? e.func_145782_y() : -1);
        tag.func_74768_a("energy", this.energy.getEnergyStored());
        tag.func_74776_a("stabRegen", this.maxStabilityPerOperation);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.clientLoadedID = tag.func_74762_e("riftID");
        if (this.clientLoadedID != -1) {
            this.loadTargetFromID();
        } else {
            this.targetedRift.clear();
            this.updateBeam();
        }
    }

    public void func_145843_s() {
        this.targetedRift.clear();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        if (this.field_145850_b.field_72995_K) {
            this.updateBeam();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        Entity e = (Entity)this.targetedRift.get();
        compound.func_74768_a("riftID", e != null ? e.func_145782_y() : -1);
        compound.func_74768_a("energy", this.energy.getEnergyStored());
        compound.func_74776_a("stabRegen", this.maxStabilityPerOperation);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.clientLoadedID = pkt.func_148857_g().func_74762_e("riftID");
        if (this.clientLoadedID != -1) {
            this.loadTargetFromID();
        } else {
            this.targetedRift.clear();
            this.updateBeam();
        }
        this.energy.setEnergy(pkt.func_148857_g().func_74762_e("energy"));
        this.maxStabilityPerOperation = pkt.func_148857_g().func_74760_g("stabRegen");
        this.updateBeamColor();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.serverLoadedID != null) {
            tag.func_186854_a("rift", this.serverLoadedID);
        }
        tag.func_74768_a("energy", this.energy.getEnergyStored());
        tag.func_74776_a("stabRegen", this.maxStabilityPerOperation);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.serverLoadedID = nbt.func_186857_a("rift");
        this.energy.setEnergy(nbt.func_74762_e("energy"));
        this.maxStabilityPerOperation = nbt.func_74760_g("stabRegen");
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    protected static class CustomEnergyStorage
    extends EnergyStorage {
        public CustomEnergyStorage(int capacity, int in, int out, int initial) {
            super(capacity, in, out, initial);
        }

        public void setEnergy(int newEnergy) {
            this.energy = newEnergy;
        }
    }
}

