/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aura.AuraHelper;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileVisRegenerator
extends TileEntity
implements ITickable,
IAnimatedTile {
    private static final int DELAY = 100;
    protected IAnimationStateMachine asm;
    protected TimeValues.VariableValue cycleLength;
    protected TimeValues.VariableValue actionTime;
    protected int delay = ThreadLocalRandom.current().nextInt(-5, 6);
    protected boolean lastState = false;
    protected int ticks;

    public TileVisRegenerator() {
        this.cycleLength = new TimeValues.VariableValue(1.0f);
        this.actionTime = new TimeValues.VariableValue(-1.0f);
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/vis_regenerator.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)this.cycleLength, (Object)"act_time", (Object)this.actionTime, (Object)"delay", (Object)new TimeValues.VariableValue((float)this.delay)));
        this.ticks = ThreadLocalRandom.current().nextInt(20);
    }

    private float getAuraOffset() {
        return Math.max(Math.min((float)Math.pow(2.0, -0.010416667f * (float)AuraHelper.getAuraBase((World)this.field_145850_b, (BlockPos)this.field_174879_c)), (float)AuraHelper.getAuraBase((World)this.field_145850_b, (BlockPos)this.field_174879_c) - AuraHelper.getVis((World)this.field_145850_b, (BlockPos)this.field_174879_c)) - AuraHelper.getFlux((World)this.field_145850_b, (BlockPos)this.field_174879_c), 0.0f);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 100 == 0 && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue() && AuraHelper.getVis((World)this.field_145850_b, (BlockPos)this.field_174879_c) + AuraHelper.getFlux((World)this.field_145850_b, (BlockPos)this.field_174879_c) < (float)AuraHelper.getAuraBase((World)this.field_145850_b, (BlockPos)this.field_174879_c)) {
            if (AuraHelper.getFlux((World)this.field_145850_b, (BlockPos)this.field_174879_c) > AuraHelper.getVis((World)this.field_145850_b, (BlockPos)this.field_174879_c)) {
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.getAuraOffset(), (boolean)true);
            } else {
                AuraHelper.addVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.getAuraOffset());
                TANetwork.INSTANCE.sendToAllAround((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VIS_REGENERATOR, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 48.0));
            }
        } else if (this.field_145850_b.field_72995_K && (this.ticks++ + this.delay) % 5 == 0) {
            boolean enabled;
            float aura = this.getAuraOffset();
            this.cycleLength.setValue(Math.min(1.0f / Math.max(aura, Float.MIN_VALUE), 15.0f));
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = enabled = state.func_177227_a().contains(IEnabledBlock.ENABLED) && (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED) != false;
            if (enabled != this.lastState) {
                this.lastState = enabled;
                this.actionTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
                AnimationHelper.transitionSafely(this.asm, this.lastState ? "starting" : "stopping");
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityAnimation.ANIMATION_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityAnimation.ANIMATION_CAPABILITY ? CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm) : super.getCapability(capability, facing));
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public boolean hasFastRenderer() {
        return true;
    }
}

