/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedInventory;
import thecodex6824.thaumicaugmentation.api.ward.tile.WardedInventory;
import thecodex6824.thaumicaugmentation.common.tile.TileWarded;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileWardedChest
extends TileWarded
implements IAnimatedTile {
    protected WardedInventory inventory = new WardedInventory(27);
    protected IAnimationStateMachine asm;
    protected TimeValues.VariableValue openTime = new TimeValues.VariableValue(-1.0f);

    public TileWardedChest() {
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/warded_chest.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"open_speed", (Object)new TimeValues.VariableValue(0.5f), (Object)"open_time", (Object)this.openTime));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onOpenInventory() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, 1.0f);
        } else {
            this.openTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
            AnimationHelper.transitionSafely(this.asm, "opening");
        }
    }

    public void onCloseInventory() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, 1.0f);
        } else {
            this.openTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
            AnimationHelper.transitionSafely(this.asm, "closing");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY || capability == CapabilityWardedInventory.WARDED_INVENTORY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        if (capability == CapabilityWardedInventory.WARDED_INVENTORY) {
            return (T)CapabilityWardedInventory.WARDED_INVENTORY.cast((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }
}

