/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core;

import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.ITransformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerBaubleSlotChanged;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerBipedRotationCustomTCArmor;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerBipedRotationVanilla;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerEldritchGuardianFog;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerElytraClientCheck;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerElytraServerCheck;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerInfusionLeftoverItems;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerRenderEntities;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerRunicShieldingAllowBaublesCap;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerTCBlueprintCrashFix;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerTCRobesElytraFlapping;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerThaumostaticHarnessSprintCheck;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerUpdateElytra;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerVoidRobesArmorBarFix;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockFireEncouragement;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockFlammability;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockHardness;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockNoEndermanPickup;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockNoRabbitSnacking;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockNoSheepGrazing;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockNoVillagerFarming;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockRandomTick;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockResistance;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerWardBlockTaintImmunity;

public class TATransformer
implements IClassTransformer {
    private static final ArrayList<ITransformer> TRANSFORMERS = new ArrayList();

    private boolean isTransformNeeded(String transformedName) {
        if (!ThaumicAugmentationCore.isEnabled()) {
            return false;
        }
        for (ITransformer t : TRANSFORMERS) {
            if (!t.isTransformationNeeded(transformedName)) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (this.isTransformNeeded(transformedName)) {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(basicClass);
            reader.accept((ClassVisitor)node, 0);
            boolean didSomething = false;
            boolean computeFrames = false;
            for (ITransformer transformer : TRANSFORMERS) {
                if (!transformer.isTransformationNeeded(transformedName)) continue;
                if (ThaumicAugmentationCore.getExcludedTransformers().contains(transformer.getClass().getName())) {
                    ThaumicAugmentationCore.getLogger().info("Excluding transformer {} due to config request", (Object)transformer.getClass().getName());
                    continue;
                }
                if (!transformer.transform(node, name, transformedName)) {
                    ThaumicAugmentationCore.getLogger().error("A class transformer has failed! This is probably very bad...");
                    ThaumicAugmentationCore.getLogger().error("Class: " + transformedName + ", Transformer: " + transformer.getClass());
                    if (transformer.getRaisedException() != null) {
                        ThaumicAugmentationCore.getLogger().error("Additional information: ", (Throwable)transformer.getRaisedException());
                        throw transformer.getRaisedException();
                    }
                    throw new RuntimeException();
                }
                didSomething = true;
                computeFrames |= transformer.needToComputeFrames();
            }
            if (didSomething) {
                ClassWriter writer = !computeFrames ? new ClassWriter(1) : new ClassWriter(2){

                    protected String getCommonSuperClass(String type1, String type2) {
                        return "java/lang/Object";
                    }
                };
                node.accept((ClassVisitor)writer);
                ThaumicAugmentationCore.getLogger().info("Successfully transformed class " + transformedName);
                return writer.toByteArray();
            }
        }
        return basicClass;
    }

    static {
        TRANSFORMERS.add(new TransformerWardBlockHardness());
        TRANSFORMERS.add(new TransformerWardBlockResistance());
        TRANSFORMERS.add(new TransformerWardBlockFlammability());
        TRANSFORMERS.add(new TransformerWardBlockFireEncouragement());
        TRANSFORMERS.add(new TransformerWardBlockRandomTick());
        TRANSFORMERS.add(new TransformerWardBlockNoEndermanPickup());
        TRANSFORMERS.add(new TransformerWardBlockNoRabbitSnacking());
        TRANSFORMERS.add(new TransformerWardBlockNoSheepGrazing());
        TRANSFORMERS.add(new TransformerWardBlockNoVillagerFarming());
        TRANSFORMERS.add(new TransformerWardBlockTaintImmunity());
        TRANSFORMERS.add(new TransformerThaumostaticHarnessSprintCheck());
        TRANSFORMERS.add(new TransformerElytraClientCheck());
        TRANSFORMERS.add(new TransformerElytraServerCheck());
        TRANSFORMERS.add(new TransformerUpdateElytra());
        TRANSFORMERS.add(new TransformerBipedRotationVanilla());
        TRANSFORMERS.add(new TransformerBipedRotationCustomTCArmor());
        TRANSFORMERS.add(new TransformerTCRobesElytraFlapping());
        TRANSFORMERS.add(new TransformerRenderEntities());
        TRANSFORMERS.add(new TransformerInfusionLeftoverItems());
        TRANSFORMERS.add(new TransformerBaubleSlotChanged());
        TRANSFORMERS.add(new TransformerEldritchGuardianFog());
        TRANSFORMERS.add(new TransformerTCBlueprintCrashFix());
        TRANSFORMERS.add(new TransformerVoidRobesArmorBarFix());
        TRANSFORMERS.add(new TransformerRunicShieldingAllowBaublesCap());
    }
}

