/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWardBlockHardness
extends Transformer {
    private static final String CLASS = "net.minecraft.block.state.BlockStateContainer$StateImplementation";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return !ThaumicAugmentationCore.getConfig().getBoolean("DisableWardFocus", "gameplay.ward", false, "") && transformedName.equals(CLASS);
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode hardness = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/block/state/BlockStateContainer$StateImplementation", "func_185887_b", Type.FLOAT_TYPE, Type.getType((String)"Lnet/minecraft/world/World;"), Type.getType((String)"Lnet/minecraft/util/math/BlockPos;")), "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)F");
            boolean found = false;
            int ret = 0;
            while ((ret = TransformUtil.findFirstInstanceOfOpcode(hardness, ret, 174)) != -1) {
                AbstractInsnNode insertAfter = hardness.instructions.get(ret).getPrevious();
                hardness.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardHardness", "(FLnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)F", false));
                hardness.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 2));
                hardness.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
                ret += 4;
                found = true;
            }
            if (!found) {
                throw new TransformerException("Could not locate required instructions");
            }
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

