/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWardBlockNoSheepGrazing
extends Transformer {
    private static final String CLASS = "net.minecraft.entity.ai.EntityAIEatGrass";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return !ThaumicAugmentationCore.getConfig().getBoolean("DisableWardFocus", "gameplay.ward", false, "") && transformedName.equals(CLASS);
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode nom = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/entity/ai/EntityAIEatGrass", "func_75250_a", Type.BOOLEAN_TYPE, new Type[0]), "()Z");
            int tallGrass = TransformUtil.findLastInstanceOfOpcode(nom, nom.instructions.size(), 153);
            int normalGrass = TransformUtil.findLastInstanceOfOpcode(nom, nom.instructions.size(), 166);
            if (tallGrass == -1 || normalGrass == -1) {
                throw new TransformerException("Could not locate required instructions, locations: " + tallGrass + ", " + normalGrass);
            }
            AbstractInsnNode insertAfter = nom.instructions.get(tallGrass);
            AbstractInsnNode grassAfter = nom.instructions.get(normalGrass);
            nom.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)insertAfter).label));
            nom.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardGeneric", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            nom.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
            nom.instructions.insert(insertAfter, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIEatGrass", TransformUtil.remapFieldName("net/minecraft/entity/ai/EntityAIEatGrass", "field_151501_c"), "Lnet/minecraft/world/World;"));
            nom.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 0));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)grassAfter).label));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardGeneric", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/math/BlockPos", TransformUtil.remapMethodName("net/minecraft/util/math/BlockPos", "func_177977_b", Type.getType((String)"Lnet/minecraft/util/math/BlockPos;"), new Type[0]), "()Lnet/minecraft/util/math/BlockPos;", false));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIEatGrass", TransformUtil.remapFieldName("net/minecraft/entity/ai/EntityAIEatGrass", "field_151501_c"), "Lnet/minecraft/world/World;"));
            nom.instructions.insert(grassAfter, (AbstractInsnNode)new VarInsnNode(25, 0));
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

