/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWardBlockNoVillagerFarming
extends Transformer {
    private static final String CLASS = "net.minecraft.entity.ai.EntityAIHarvestFarmland";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return !ThaumicAugmentationCore.getConfig().getBoolean("DisableWardFocus", "gameplay.ward", false, "") && transformedName.equals(CLASS);
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode farm = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/entity/ai/EntityAIHarvestFarmland", "func_179488_a", Type.BOOLEAN_TYPE, Type.getType((String)"Lnet/minecraft/world/World;"), Type.getType((String)"Lnet/minecraft/util/math/BlockPos;")), "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z");
            int plant = TransformUtil.findLastInstanceOfOpcode(farm, farm.instructions.size(), 156);
            int harvest = TransformUtil.findLastInstanceOfOpcode(farm, plant, 156);
            if (plant == -1 || harvest == -1) {
                throw new TransformerException("Could not locate required instructions, locations: " + plant + ", " + harvest);
            }
            AbstractInsnNode insertAfter = farm.instructions.get(plant);
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)insertAfter).label));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardGeneric", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 2));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
            insertAfter = farm.instructions.get(harvest);
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)insertAfter).label));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardGeneric", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 2));
            farm.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

