/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.init;

import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.aspect.AspectElementInteractionManager;
import thecodex6824.thaumicaugmentation.api.aspect.AspectUtil;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.CasterAugmentBuilder;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.IBuilderCasterEffectProvider;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.IBuilderCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;

public class AugmentHandler {
    public static void registerAugmentBuilderComponents() {
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_experience"), new IBuilderCasterStrengthProvider(){

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    return Math.max(Math.min((double)player.field_71068_ca * TAConfig.experienceModifierScale.getValue(), TAConfig.experienceModifierCap.getValue()), TAConfig.experienceModifierBase.getValue());
                }
                return 1.0;
            }
        });
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_elemental"), new IBuilderCasterStrengthProvider(){

            private Aspect getAspect(ItemStack stack) {
                if (!stack.func_77942_o() || Aspect.getAspect((String)stack.func_77978_p().func_74779_i("aspect")) == null) {
                    return Aspect.ORDER;
                }
                return Aspect.getAspect((String)stack.func_77978_p().func_74779_i("aspect"));
            }

            @Override
            public void appendAdditionalTooltip(ItemStack component, List<String> tooltip) {
                Aspect aspect = this.getAspect(component);
                tooltip.add("  " + new TextComponentTranslation("thaumicaugmentation.text.elemental_aspect", new Object[]{AspectUtil.getChatColorForAspect(aspect) + aspect.getName() + TextFormatting.RESET}).func_150254_d());
            }

            @Override
            public int calculateTintColor(ICustomCasterAugment augment) {
                return this.getAspect(augment.getStrengthProvider()).getColor();
            }

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                double totalMultiplier = 1.0;
                ArrayDeque nodes = new ArrayDeque(focus.getFocus().nodes);
                while (!nodes.isEmpty()) {
                    IFocusElement node = (IFocusElement)nodes.pop();
                    if (node instanceof FocusEffect && ((FocusEffect)node).getAspect() == this.getAspect(augment.getStrengthProvider())) {
                        totalMultiplier *= TAConfig.elementalModifierPositiveFactor.getValue().doubleValue();
                        continue;
                    }
                    if (node instanceof FocusModSplit) {
                        for (FocusPackage f : ((FocusModSplit)node).getSplitPackages()) {
                            nodes.addAll(f.nodes);
                        }
                        continue;
                    }
                    if (!(node instanceof FocusNode) || !AspectElementInteractionManager.getNegativeAspects(this.getAspect(augment.getStrengthProvider())).contains(((FocusNode)node).getAspect())) continue;
                    totalMultiplier *= TAConfig.elementalModifierNegativeFactor.getValue().doubleValue();
                }
                return totalMultiplier;
            }
        }, stack -> stack.func_77978_p().func_74778_a("aspect", Aspect.ORDER.getTag()));
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_overworld"), new IBuilderCasterStrengthProvider(){

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                return TAConfig.dimensionalModifierOverworldDims.getValue().contains(entity.field_71093_bK) ? TAConfig.dimensionalModifierOverworldPostiveFactor.getValue() : TAConfig.dimensionalModifierOverworldNegativeFactor.getValue();
            }
        });
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_nether"), new IBuilderCasterStrengthProvider(){

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                return TAConfig.dimensionalModifierNetherDims.getValue().contains(entity.field_71093_bK) ? TAConfig.dimensionalModifierNetherPostiveFactor.getValue() : TAConfig.dimensionalModifierNetherNegativeFactor.getValue();
            }
        });
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_end"), new IBuilderCasterStrengthProvider(){

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                return TAConfig.dimensionalModifierEndDims.getValue().contains(entity.field_71093_bK) ? TAConfig.dimensionalModifierEndPostiveFactor.getValue() : TAConfig.dimensionalModifierEndNegativeFactor.getValue();
            }
        });
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_emptiness"), new IBuilderCasterStrengthProvider(){

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity entity) {
                return TAConfig.dimensionalModifierEmptinessDims.getValue().contains(entity.field_71093_bK) ? TAConfig.dimensionalModifierEmptinessPostiveFactor.getValue() : TAConfig.dimensionalModifierEmptinessNegativeFactor.getValue();
            }
        });
        CasterAugmentBuilder.registerStrengthProvider(new ResourceLocation("thaumicaugmentation", "strength_frenzy"), new IBuilderCasterStrengthProvider(){

            @Override
            public void onTick(ICustomCasterAugment augment, Entity user) {
                ItemStack stack = augment.getStrengthProvider();
                if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("frenzyCooldown") > 0) {
                    int newCooldown = stack.func_77978_p().func_74762_e("frenzyCooldown") - 1;
                    if (newCooldown == 0) {
                        stack.func_77978_p().func_74768_a("frenzy", 0);
                        stack.func_77978_p().func_74768_a("frenzyCooldown", -1);
                    } else {
                        stack.func_77978_p().func_74768_a("frenzyCooldown", newCooldown);
                    }
                }
            }

            @Override
            public void onUnequip(ICustomCasterAugment augment, Entity user) {
                ItemStack stack = augment.getStrengthProvider();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("frenzy", 0);
                stack.func_77978_p().func_74768_a("frenzyCooldown", -1);
            }

            @Override
            public void onHurtEntity(ICustomCasterAugment augment, Entity user, Entity attacked) {
                ItemStack stack = augment.getStrengthProvider();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("frenzy", Math.min(stack.func_77978_p().func_74762_e("frenzy") + 1, TAConfig.frenzyModifierMaxLevel.getValue()));
                stack.func_77978_p().func_74768_a("frenzyCooldown", TAConfig.frenzyModifierCooldown.getValue().intValue());
            }

            @Override
            public double calculateStrength(ICustomCasterAugment augment, FocusWrapper focus, Entity user) {
                ItemStack stack = augment.getStrengthProvider();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                return 1.0 + (double)stack.func_77978_p().func_74762_e("frenzy") * TAConfig.frenzyModifierScaleFactor.getValue();
            }
        });
        CasterAugmentBuilder.registerEffectProvider(new ResourceLocation("thaumicaugmentation", "effect_power"), new IBuilderCasterEffectProvider(){

            @Override
            public void apply(ICustomCasterAugment augment, Entity entity, ItemStack caster, FocusWrapper focus, double strength) {
                focus.setFocusPower(focus.getFocusPower() + (focus.getOriginalFocusPower() * (float)strength - focus.getOriginalFocusPower()));
            }
        });
        CasterAugmentBuilder.registerEffectProvider(new ResourceLocation("thaumicaugmentation", "effect_cast_speed"), new IBuilderCasterEffectProvider(){

            @Override
            public void apply(ICustomCasterAugment augment, Entity entity, ItemStack caster, FocusWrapper focus, double strength) {
                focus.setCooldown((int)Math.ceil((double)focus.getCooldown() * (1.0 / strength)));
            }
        });
        CasterAugmentBuilder.registerEffectProvider(new ResourceLocation("thaumicaugmentation", "effect_cost"), new IBuilderCasterEffectProvider(){

            @Override
            public void apply(ICustomCasterAugment augment, Entity entity, ItemStack caster, FocusWrapper focus, double strength) {
                focus.setVisCost(focus.getVisCost() * (float)(1.0 / strength));
            }
        });
    }
}

