/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.init;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusEngine;
import thecodex6824.thaumicaugmentation.api.augment.AugmentAPI;
import thecodex6824.thaumicaugmentation.api.entity.AutocasterFocusRegistry;
import thecodex6824.thaumicaugmentation.api.entity.PrimalWispAttackRegistry;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectLight;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectVoidShield;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectWard;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectWater;

public final class MiscHandler {
    private MiscHandler() {
    }

    public static void preInit() {
    }

    public static void init() {
        FocusEngine.registerElement(FocusEffectLight.class, (ResourceLocation)new ResourceLocation("thaumicaugmentation", "textures/foci/light.png"), (int)Aspect.LIGHT.getColor());
        FocusEngine.registerElement(FocusEffectWard.class, (ResourceLocation)new ResourceLocation("thaumicaugmentation", "textures/foci/ward.png"), (int)Aspect.PROTECT.getColor());
        FocusEngine.registerElement(FocusEffectVoidShield.class, (ResourceLocation)new ResourceLocation("thaumicaugmentation", "textures/foci/shield.png"), (int)5243080);
        FocusEngine.registerElement(FocusEffectWater.class, (ResourceLocation)new ResourceLocation("thaumicaugmentation", "textures/foci/water.png"), (int)Aspect.WATER.getColor());
        AugmentAPI.addAugmentableItemSource(new ResourceLocation("thaumicaugmentation", "default"), entity -> {
            if (entity instanceof EntityLivingBase) {
                return ((EntityLivingBase)entity).func_184209_aF();
            }
            return Collections.emptyList();
        });
        AugmentAPI.addAugmentableItemSource(new ResourceLocation("thaumicaugmentation", "baubles"), entity -> {
            if (entity instanceof EntityPlayer) {
                IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Collections.nCopies(handler.getSlots(), ItemStack.field_190927_a));
                for (int i = 0; i < stacks.size(); ++i) {
                    stacks.set(i, handler.getStackInSlot(i));
                }
                return stacks;
            }
            return Collections.emptyList();
        });
        AutocasterFocusRegistry.registerMaxDistance("thaumcraft.BOLT", 16.0);
        AutocasterFocusRegistry.registerMaxDistance("thaumcraft.TOUCH", 4.0);
        MiscHandler.registerWispAttacks();
        BlocksTC.stairsAncient.func_149663_c("thaumcraft.stairs_ancient_tile");
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("thaumcraft", "StairsAncient"), (ResourceLocation)new ResourceLocation(""), (ItemStack)new ItemStack(BlocksTC.stairsAncient, 4, 0), (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), BlocksTC.stoneAncientTile});
    }

    protected static void registerWispAttacks() {
        PrimalWispAttackRegistry.registerAttack(Aspect.AIR, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            target.func_70653_a((Entity)wisp, damage * 0.15f, Math.sin(wisp.field_70177_z * 0.015f), -Math.cos(wisp.field_70177_z * 0.015f));
            wisp.func_184185_a(SoundEvents.field_187524_aN, 0.5f, 0.66f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), false);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.AVERSION, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage * 1.5f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.COLD, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect slow = new PotionEffect(MobEffects.field_76421_d, MathHelper.func_76125_a((int)(total / 10), (int)1, (int)20));
            if (target.func_70687_e(slow)) {
                target.func_70690_d(slow);
            }
            wisp.func_184185_a(SoundEvents.field_187942_hp, 0.2f, 1.0f + (float)wisp.func_70681_au().nextGaussian() * 0.05f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), false);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.DARKNESS, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect blind = new PotionEffect(MobEffects.field_76440_q, MathHelper.func_76125_a((int)(total / 10), (int)1, (int)20));
            if (target.func_70687_e(blind)) {
                target.func_70690_d(blind);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.DEATH, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect wither = new PotionEffect(MobEffects.field_82731_v, MathHelper.func_76125_a((int)(total / 10), (int)1, (int)20));
            if (target.func_70687_e(wither)) {
                target.func_70690_d(wither);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.DESIRE, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect haste = new PotionEffect(MobEffects.field_76422_e, MathHelper.func_76125_a((int)(total / 10), (int)1, (int)20));
            if (target.func_70687_e(haste)) {
                target.func_70690_d(haste);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.EARTH, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage * 1.2f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.FIRE, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            if (!target.func_70045_F()) {
                target.func_70015_d(MathHelper.func_76125_a((int)(total / 10), (int)1, (int)20));
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.FLIGHT, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect levitate = new PotionEffect(MobEffects.field_82731_v, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10));
            if (target.func_70687_e(levitate)) {
                target.func_70690_d(levitate);
            }
            wisp.func_184185_a(SoundEvents.field_187524_aN, 0.5f, 0.66f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), false);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.FLUX, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p().func_76348_h(), damage);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.LIFE, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage * 0.8f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.MOTION, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect effect = new PotionEffect(MobEffects.field_188423_x, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10));
            if (target.func_70687_e(effect)) {
                target.func_70690_d(effect);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.MIND, (wisp, target, aspect, total) -> {
            IPlayerWarp warp;
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            if (target instanceof EntityPlayer && wisp.func_70681_au().nextBoolean() && (warp = (IPlayerWarp)target.getCapability(ThaumcraftCapabilities.WARP, null)) != null && warp.get(IPlayerWarp.EnumWarpType.TEMPORARY) > 0) {
                ThaumcraftApi.internalMethods.addWarpToPlayer((EntityPlayer)target, -warp.get(IPlayerWarp.EnumWarpType.TEMPORARY), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.MOTION, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect effect = new PotionEffect(wisp.func_70681_au().nextBoolean() ? MobEffects.field_76424_c : MobEffects.field_76430_j, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10));
            if (target.func_70687_e(effect)) {
                target.func_70690_d(effect);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.SENSES, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect effect = new PotionEffect(wisp.func_70681_au().nextBoolean() ? MobEffects.field_76439_r : MobEffects.field_76431_k, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10));
            if (target.func_70687_e(effect)) {
                target.func_70690_d(effect);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.TRAP, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            PotionEffect effect = new PotionEffect(MobEffects.field_76421_d, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10));
            if (target.func_70687_e(effect)) {
                target.func_70690_d(effect);
            }
            if (target.func_70687_e(effect = new PotionEffect(MobEffects.field_76437_t, MathHelper.func_76125_a((int)(total / 20), (int)1, (int)10)))) {
                target.func_70690_d(effect);
            }
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), true);
        });
        PrimalWispAttackRegistry.registerAttack(Aspect.WATER, (wisp, target, aspect, total) -> {
            float damage = (float)wisp.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wisp).func_82726_p(), damage);
            target.func_70015_d(0);
            wisp.func_184185_a(SoundEvents.field_187547_bF, 0.2f, 1.2f);
            PrimalWispAttackRegistry.createWispZap((Entity)wisp, (Entity)target, aspect.getColor(), false);
        });
    }
}

