/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.init.proxy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.common.golems.client.gui.SealBaseContainer;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.WardStorageServer;
import thecodex6824.thaumicaugmentation.common.container.ContainerArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.container.ContainerAutocaster;
import thecodex6824.thaumicaugmentation.common.container.ContainerWardedChest;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocaster;
import thecodex6824.thaumicaugmentation.common.event.PlayerEventHandler;
import thecodex6824.thaumicaugmentation.common.network.PacketBoostState;
import thecodex6824.thaumicaugmentation.common.network.PacketElytraBoost;
import thecodex6824.thaumicaugmentation.common.network.PacketInteractGUI;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.TileArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.tile.TileWardedChest;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;
import thecodex6824.thaumicaugmentation.common.util.ITARenderHelper;
import thecodex6824.thaumicaugmentation.common.util.TARenderHelperServer;
import thecodex6824.thaumicaugmentation.init.GUIHandler;
import thecodex6824.thaumicaugmentation.init.proxy.ISidedProxy;

public class ServerProxy
implements ISidedProxy {
    protected static ITARenderHelper renderHelper;
    protected static Cache<UUID, Integer> invalidBoosts;

    @Override
    public IAnimationStateMachine loadASM(ResourceLocation loc, ImmutableMap<String, ITimeValue> params) {
        return null;
    }

    @Override
    public ITARenderHelper getRenderHelper() {
        if (renderHelper == null) {
            renderHelper = new TARenderHelperServer();
        }
        return renderHelper;
    }

    @Override
    public IWardStorage createWardStorageInstance(World world) {
        return new WardStorageServer();
    }

    @Override
    public void registerRenderableImpetusNode(IImpetusNode node) {
    }

    @Override
    public boolean deregisterRenderableImpetusNode(IImpetusNode node) {
        return false;
    }

    @Override
    public boolean isOpenToLAN() {
        return false;
    }

    @Override
    public boolean isSingleplayer() {
        return false;
    }

    @Override
    public boolean isElytraBoostKeyDown() {
        return false;
    }

    @Override
    public boolean isPvPEnabled() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W();
    }

    @Override
    public boolean isEntityClientPlayer(Entity e) {
        return false;
    }

    @Override
    public boolean isEntityRenderView(Entity e) {
        return false;
    }

    @Override
    public float getPartialTicks() {
        return 1.0f;
    }

    @Override
    public Container getServerGUIElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUIHandler.TAInventory.values()[ID]) {
            case WARDED_CHEST: {
                return new ContainerWardedChest(player.field_71071_by, (TileWardedChest)world.func_175625_s(new BlockPos(x, y, z)));
            }
            case ARCANE_TERRAFORMER: {
                return new ContainerArcaneTerraformer(player.field_71071_by, (TileArcaneTerraformer)world.func_175625_s(new BlockPos(x, y, z)));
            }
            case AUTOCASTER: {
                return new ContainerAutocaster(player.field_71071_by, (EntityAutocaster)world.func_73045_a(x));
            }
        }
        return null;
    }

    @Override
    public Object getClientGUIElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        throw new UnsupportedOperationException("Cannot get client GUI element on the server side!");
    }

    @Override
    public Object getSealContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing face, ISealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    public Object getSealGUI(World world, EntityPlayer player, BlockPos pos, EnumFacing face, ISealEntity seal) {
        throw new UnsupportedOperationException("Cannot get client GUI element on the server side!");
    }

    @Override
    public ISoundHandle playSpecialSound(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick, float x, float y, float z, float vol, float pitch, boolean repeat, int repeatDelay) {
        return new ISoundHandle.Noop();
    }

    @Override
    public void handlePacketClient(IMessage message, MessageContext context) {
        ThaumicAugmentation.getLogger().warn("A packet was received on the wrong side: " + message.getClass().toString());
        if (!this.isSingleplayer()) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: sent invalid client packet", (Object)player.func_70005_c_(), (Object)player.func_146103_bH().getId());
            context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
        }
    }

    @Override
    public void handlePacketServer(IMessage message, MessageContext context) {
        if (message instanceof PacketElytraBoost) {
            this.handleElytraBoostPacket((PacketElytraBoost)message, context);
        } else if (message instanceof PacketInteractGUI) {
            this.handleInteractGUIPacket((PacketInteractGUI)message, context);
        } else {
            ThaumicAugmentation.getLogger().warn("An unknown packet was received and will be dropped: " + message.getClass().toString());
            if (!this.isSingleplayer()) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: sent unknown packet", (Object)player.func_70005_c_(), (Object)player.func_146103_bH().getId());
                context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
            }
        }
    }

    protected void handleElytraBoostPacket(PacketElytraBoost message, MessageContext context) {
        EntityPlayerMP entity = context.getServerHandler().field_147369_b;
        if (!message.isStarting()) {
            if (PlayerEventHandler.getBoostState((EntityPlayer)entity)) {
                PlayerEventHandler.updateBoostState((EntityPlayer)entity, false);
                PacketBoostState packet = new PacketBoostState(entity.func_145782_y(), false);
                if (entity instanceof EntityPlayerMP) {
                    TANetwork.INSTANCE.sendTo((IMessage)packet, entity);
                }
                TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)entity);
            }
        } else if (PlayerEventHandler.playerCanBoost((EntityPlayer)entity)) {
            PlayerEventHandler.updateBoostState((EntityPlayer)entity, true);
            PacketBoostState packet = new PacketBoostState(entity.func_145782_y(), true);
            if (entity instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)packet, entity);
            }
            TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)entity);
        } else if (!this.isSingleplayer()) {
            int fails = 5;
            try {
                fails = (Integer)invalidBoosts.get((Object)entity.func_146103_bH().getId(), () -> 0);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            if (fails >= 5) {
                ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: exceeded maximum acceptable incorrect elytra boost requests", (Object)entity.func_70005_c_(), (Object)entity.func_146103_bH().getId());
                context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
            } else {
                invalidBoosts.put((Object)entity.func_146103_bH().getId(), (Object)(fails + 1));
                entity.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
            }
        } else {
            entity.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
        }
    }

    protected void handleInteractGUIPacket(PacketInteractGUI message, MessageContext context) {
        EntityPlayerMP sender = context.getServerHandler().field_147369_b;
        if (sender != null && sender.field_71070_bA instanceof ContainerArcaneTerraformer) {
            ContainerArcaneTerraformer terraformer = (ContainerArcaneTerraformer)sender.field_71070_bA;
            if (!terraformer.getTile().isRunning()) {
                if (message.getComponentID() == 0) {
                    terraformer.getTile().setRadius(Math.max(Math.min(message.getSelectionValue(), 32), 1));
                } else if (message.getComponentID() == 1) {
                    terraformer.getTile().setCircle(message.getSelectionValue() != 0);
                } else if (!this.isSingleplayer()) {
                    ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: invalid component ID", (Object)sender.func_70005_c_(), (Object)sender.func_146103_bH().getId());
                    context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
                }
            }
        } else if (sender != null && sender.field_71070_bA instanceof ContainerAutocaster) {
            EntityAutocaster autocaster = ((ContainerAutocaster)sender.field_71070_bA).getEntity();
            switch (message.getComponentID()) {
                case 0: {
                    autocaster.setTargetAnimals(message.getSelectionValue() > 0);
                    break;
                }
                case 1: {
                    autocaster.setTargetMobs(message.getSelectionValue() > 0);
                    break;
                }
                case 2: {
                    autocaster.setTargetPlayers(message.getSelectionValue() > 0);
                    break;
                }
                case 3: {
                    autocaster.setTargetFriendly(message.getSelectionValue() > 0);
                    break;
                }
                case 4: {
                    autocaster.setRedstoneControl(message.getSelectionValue() > 0);
                    break;
                }
                default: {
                    if (!this.isSingleplayer()) {
                        ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: invalid component ID", (Object)sender.func_70005_c_(), (Object)sender.func_146103_bH().getId());
                        context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (!this.isSingleplayer()) {
            ThaumicAugmentation.getLogger().info("Player {} ({}) kicked for protocol violation: invalid container", (Object)sender.func_70005_c_(), (Object)sender.func_146103_bH().getId());
            context.getServerHandler().func_194028_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.network_kick", new Object[0]));
        }
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    static {
        invalidBoosts = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }
}

