/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation;

import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.ThaumicAugmentationAPI;
import thecodex6824.thaumicaugmentation.api.internal.TAInternals;
import thecodex6824.thaumicaugmentation.common.TAConfigHolder;
import thecodex6824.thaumicaugmentation.common.event.WardEventHandler;
import thecodex6824.thaumicaugmentation.common.event.WardEventHandlerNoCoremodFallback;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationHandler;
import thecodex6824.thaumicaugmentation.common.internal.InternalMethodProvider;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.WorldDataCache;
import thecodex6824.thaumicaugmentation.common.world.feature.FractureUtils;
import thecodex6824.thaumicaugmentation.init.CapabilityHandler;
import thecodex6824.thaumicaugmentation.init.GUIHandler;
import thecodex6824.thaumicaugmentation.init.LootHandler;
import thecodex6824.thaumicaugmentation.init.MiscHandler;
import thecodex6824.thaumicaugmentation.init.ResearchHandler;
import thecodex6824.thaumicaugmentation.init.WorldHandler;
import thecodex6824.thaumicaugmentation.init.proxy.ISidedProxy;
import thecodex6824.thaumicaugmentation.server.command.TACommands;

@Mod(modid="thaumicaugmentation", name="Thaumic Augmentation", version="1.12.2-2.1.3", useMetadata=true, certificateFingerprint="8f678591ba6f78d579e553a8aa94b4c4766cb13d", acceptedMinecraftVersions="[1.12.2]")
public class ThaumicAugmentation {
    public static final String VERSION = "1.12.2-2.1.3";
    @Mod.Instance(value="thaumicaugmentation")
    public static ThaumicAugmentation instance;
    private static Logger logger;
    @SidedProxy(serverSide="thecodex6824.thaumicaugmentation.init.proxy.ServerProxy", clientSide="thecodex6824.thaumicaugmentation.init.proxy.ClientProxy")
    public static ISidedProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        TAConfigHolder.preInit();
        CapabilityHandler.preInit();
        WorldHandler.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
        TAInternals.setInternalMethodProvider(new InternalMethodProvider());
        MiscHandler.preInit();
        LootHandler.preInit();
        IntegrationHandler.preInit();
        if (!TAConfig.disableWardFocus.getValue().booleanValue()) {
            if (ThaumicAugmentationAPI.isCoremodAvailable()) {
                MinecraftForge.EVENT_BUS.register((Object)new WardEventHandler());
            } else {
                MinecraftForge.EVENT_BUS.register((Object)new WardEventHandlerNoCoremodFallback());
            }
        }
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TANetwork.init();
        WorldHandler.init();
        ResearchHandler.init();
        MiscHandler.init();
        IntegrationHandler.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        WorldHandler.postInit();
        IntegrationHandler.postInit();
        proxy.postInit();
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        for (WorldServer world : event.getServer().field_71305_c) {
            WorldDataCache.addOrUpdateData((World)world);
        }
        FractureUtils.initDimensionCache();
        WorldDataCache.setInitialized();
        TACommands.registerCommands(event);
    }

    @Mod.EventHandler
    public static void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            Logger tempLogger = LogManager.getLogger((String)"thaumicaugmentation");
            tempLogger.warn("A file failed to match with the signing key.");
            tempLogger.warn("If you *know* this is a homebrew/custom build then this is expected, carry on.");
            tempLogger.warn("Otherwise, you might want to redownload this mod from the *official* CurseForge page.");
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        proxy = null;
    }
}

