/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.event;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.ClientWardStorageValue;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageClient;
import thecodex6824.thaumicaugmentation.client.event.ClientLivingEquipmentChangeEvent;
import thecodex6824.thaumicaugmentation.client.sound.SoundHandleSpecialSound;
import thecodex6824.thaumicaugmentation.common.TAConfigHolder;
import thecodex6824.thaumicaugmentation.common.event.AugmentEventHandler;
import thecodex6824.thaumicaugmentation.common.network.PacketElytraBoost;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;

@Mod.EventBusSubscriber(modid="thaumicaugmentation", value={Side.CLIENT})
public final class ClientEventHandler {
    private static final Set<EntityPlayer> CREATIVE_FLIGHT = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<EntityPlayer> ELYTRA_BOOSTS = Collections.newSetFromMap(new WeakHashMap());
    private static float lastFogR;
    private static float lastFogG;
    private static float lastFogB;
    private static final WeakHashMap<EntityLivingBase, RecoilEntry> RECOIL;

    private ClientEventHandler() {
    }

    /*
     * WARNING - void declaration
     */
    private static void handleAugmentTooltips(ItemTooltipEvent event, IAugmentableItem cap) {
        void var5_8;
        LinkedList<LinkedList<String>> tooltip = new LinkedList<LinkedList<String>>();
        ItemStack[] itemStackArray = cap.getAllAugments();
        int n = itemStackArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ItemStack augment = itemStackArray[var5_8];
            IAugment aug = (IAugment)augment.getCapability(CapabilityAugment.AUGMENT, null);
            if (aug != null) {
                LinkedList<String> thisTooltip = new LinkedList<String>();
                thisTooltip.add(augment.func_82833_r());
                if (aug.hasAdditionalAugmentTooltip()) {
                    aug.appendAdditionalAugmentTooltip(thisTooltip);
                }
                tooltip.add(thisTooltip);
            }
            ++var5_8;
        }
        int num = 1;
        for (LinkedList linkedList : tooltip) {
            event.getToolTip().add(" " + num + ". " + (String)linkedList.remove(0));
            for (String str : linkedList) {
                event.getToolTip().add("   " + str);
            }
            ++num;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        lastFogR = event.getRed();
        lastFogG = event.getGreen();
        lastFogB = event.getBlue();
    }

    public static float getLastFogR() {
        return lastFogR;
    }

    public static float getLastFogG() {
        return lastFogG;
    }

    public static float getLastFogB() {
        return lastFogB;
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        IAugmentableItem cap;
        IPlayerKnowledge knowledge;
        Item item;
        List newTooltip;
        ItemStack disp = MorphicArmorHelper.getMorphicArmor(event.getItemStack());
        if (!disp.func_190926_b() && !(newTooltip = disp.func_82840_a(event.getEntityPlayer(), event.getFlags())).isEmpty()) {
            event.getToolTip().remove(0);
            event.getToolTip().add(0, newTooltip.get(0));
        }
        if (!TAConfig.disableStabilizerText.getValue().booleanValue() && event.getEntityPlayer() != null && ((item = event.getItemStack().func_77973_b()) instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IInfusionStabiliser || item == Items.field_151144_bL) && (knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.getEntityPlayer())) != null && knowledge.isResearchComplete("INFUSION")) {
            event.getToolTip().add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("thaumicaugmentation.text.infusion_stabilizer", new Object[0]).func_150254_d());
        }
        if ((cap = (IAugmentableItem)event.getItemStack().getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null && cap.isAugmented()) {
            event.getToolTip().add(TextFormatting.RED + new TextComponentTranslation("thaumicaugmentation.text.augmented", new Object[]{TextFormatting.RESET, cap.getUsedAugmentSlots(), cap.getTotalAugmentSlots()}).func_150254_d());
            ClientEventHandler.handleAugmentTooltips(event, cap);
        }
    }

    private static boolean focusContainsWardFocus(ItemStack focus) {
        FocusPackage f = ItemFocus.getPackage((ItemStack)focus);
        for (IFocusElement element : f.nodes) {
            if (!element.getKey().equals("focus.thaumicaugmentation.ward")) continue;
            return true;
        }
        return false;
    }

    private static void handleWardOverlay(RayTraceResult result) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.field_71441_e;
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos p = result.func_178782_a();
            for (int offsetX = -2; offsetX <= 2; ++offsetX) {
                for (int offsetY = -2; offsetY <= 2; ++offsetY) {
                    for (int offsetZ = -2; offsetZ <= 2; ++offsetZ) {
                        BlockPos pos = p.func_177982_a(offsetX, offsetY, offsetZ);
                        ClientWardStorageValue value = ((IWardStorageClient)world.func_175726_f(pos).getCapability(CapabilityWardStorage.WARD_STORAGE, null)).getWard(pos);
                        if (value == ClientWardStorageValue.EMPTY) continue;
                        float red = 1.0f;
                        float green = 0.0f;
                        if (value == ClientWardStorageValue.OWNED_SELF) {
                            red = 0.0f;
                            green = 1.0f;
                        }
                        AxisAlignedBB box = world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos);
                        for (EnumFacing dir : EnumFacing.values()) {
                            float x = (float)pos.func_177958_n() + 0.5f + (float)dir.func_82601_c() * 0.5f;
                            float y = (float)pos.func_177956_o() + 0.5f + (float)dir.func_96559_d() * 0.5f;
                            float z = (float)pos.func_177952_p() + 0.5f + (float)dir.func_82599_e() * 0.5f;
                            if (dir.func_82601_c() == 0) {
                                x = (float)((double)x + world.field_73012_v.nextGaussian() * 0.5);
                            }
                            if (dir.func_96559_d() == 0) {
                                y = (float)((double)y + world.field_73012_v.nextGaussian() * 0.5);
                            }
                            if (dir.func_82599_e() == 0) {
                                z = (float)((double)z + world.field_73012_v.nextGaussian() * 0.5);
                            }
                            x = MathHelper.func_76131_a((float)x, (float)((float)pos.func_177958_n() + (float)box.field_72340_a), (float)((float)pos.func_177958_n() + (float)box.field_72336_d));
                            y = MathHelper.func_76131_a((float)y, (float)((float)pos.func_177956_o() + (float)box.field_72338_b), (float)((float)pos.func_177956_o() + (float)box.field_72337_e));
                            z = MathHelper.func_76131_a((float)z, (float)((float)pos.func_177952_p() + (float)box.field_72339_c), (float)((float)pos.func_177952_p() + (float)box.field_72334_f));
                            if ((mc.field_71474_y.field_74362_aa != 0 || world.func_82737_E() % 2L != 0L) && world.func_82737_E() % 4L != 0L) continue;
                            FXDispatcher.INSTANCE.drawSimpleSparkle(world.field_73012_v, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, 0.5f + (float)world.field_73012_v.nextGaussian() / 8.0f, red, green, 0.0f, 0, 1.0f, 1.0E-4f, 8);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null) {
            IImpetusStorage impetus;
            IAugmentableItem augmentable;
            ItemStack body;
            Boolean boost;
            EntityPlayerSP player = mc.field_71439_g;
            if (!TAConfig.disableWardFocus.getValue().booleanValue() && player != null && mc.field_71441_e != null && mc.field_71441_e.func_82737_E() % 2L == 0L && mc.func_175606_aa() == player) {
                ItemStack stack;
                if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ICaster && ((ICaster)(stack = player.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b()).getFocus(stack) instanceof ItemFocus && ClientEventHandler.focusContainsWardFocus(((ICaster)stack.func_77973_b()).getFocusStack(stack))) {
                    ClientEventHandler.handleWardOverlay(player.func_174822_a(Math.min(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() * 2.0, 32.0), mc.func_184121_ak()));
                    return;
                }
                if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ICaster && ((ICaster)(stack = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b()).getFocus(stack) instanceof ItemFocus && ClientEventHandler.focusContainsWardFocus(((ICaster)stack.func_77973_b()).getFocusStack(stack))) {
                    ClientEventHandler.handleWardOverlay(player.func_174822_a(Math.min(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() * 2.0, 32.0), mc.func_184121_ak()));
                }
            }
            if (!(boost = Boolean.valueOf(ELYTRA_BOOSTS.contains(player))).booleanValue() && ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) && ThaumicAugmentation.proxy.isElytraBoostKeyDown() && player.func_184613_cA() && player.func_184599_cB() >= 2) {
                IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
                boolean done = false;
                if (baubles != null) {
                    for (int slot : BaubleType.BODY.getValidSlots()) {
                        body = baubles.getStackInSlot(slot);
                        if (body.func_77973_b() == TAItems.ELYTRA_HARNESS && (augmentable = (IAugmentableItem)body.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                            for (ItemStack aug : augmentable.getAllAugments()) {
                                if (aug.func_77973_b() != TAItems.ELYTRA_HARNESS_AUGMENT || aug.func_77960_j() != 0 || (impetus = (IImpetusStorage)aug.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) == null || !player.func_184812_l_() && impetus.extractEnergy(1L, true) != 1L) continue;
                                ClientEventHandler.onBoostChange((EntityPlayer)player, true);
                                PacketElytraBoost boostPacket = new PacketElytraBoost(true);
                                TANetwork.INSTANCE.sendToServer((IMessage)boostPacket);
                                done = true;
                                break;
                            }
                        }
                        if (!done) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (boost.booleanValue() && ThaumicAugmentation.proxy.isEntityRenderView((Entity)player)) {
                boolean stopping;
                boolean bl = stopping = !ThaumicAugmentation.proxy.isElytraBoostKeyDown() || !player.func_184613_cA() || player.func_184599_cB() < 2;
                if (!stopping) {
                    IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
                    stopping = true;
                    if (baubles != null) {
                        for (int slot : BaubleType.BODY.getValidSlots()) {
                            body = baubles.getStackInSlot(slot);
                            if (body.func_77973_b() == TAItems.ELYTRA_HARNESS && (augmentable = (IAugmentableItem)body.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                                for (ItemStack aug : augmentable.getAllAugments()) {
                                    if (aug.func_77973_b() != TAItems.ELYTRA_HARNESS_AUGMENT || aug.func_77960_j() != 0 || (impetus = (IImpetusStorage)aug.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) == null || !player.func_184812_l_() && impetus.extractEnergy(1L, true) != 1L) continue;
                                    stopping = false;
                                    break;
                                }
                            }
                            if (!stopping) break;
                        }
                    }
                }
                if (stopping) {
                    ClientEventHandler.onBoostChange((EntityPlayer)player, false);
                    PacketElytraBoost boostPacket = new PacketElytraBoost(false);
                    TANetwork.INSTANCE.sendToServer((IMessage)boostPacket);
                }
            }
            if (!ThaumicAugmentation.proxy.isSingleplayer() || !mc.func_147113_T()) {
                long now = mc.field_71441_e.func_82737_E();
                Iterator<Map.Entry<EntityLivingBase, RecoilEntry>> i = RECOIL.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<EntityLivingBase, RecoilEntry> entry = i.next();
                    RecoilEntry recoil = entry.getValue();
                    if (now >= recoil.start + recoil.duration) {
                        i.remove();
                        continue;
                    }
                    EntityLivingBase entity = entry.getKey();
                    entity.field_70127_C = entity.field_70125_A;
                    entity.field_70125_A += recoil.recoilFunc.apply(entity, now - recoil.start).floatValue();
                }
            }
        }
    }

    public static void onFlightChange(EntityPlayer player, boolean flying) {
        if (flying != CREATIVE_FLIGHT.contains(player)) {
            IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            if (baubles != null) {
                for (int slot : BaubleType.BODY.getValidSlots()) {
                    ItemStack body = baubles.getStackInSlot(slot);
                    if (body.func_77973_b() != TAItems.THAUMOSTATIC_HARNESS || RechargeHelper.getCharge((ItemStack)body) <= 0) continue;
                    int id = player.func_145782_y();
                    if (flying) {
                        ISoundHandle handle = ThaumicAugmentation.proxy.playSpecialSound(SoundsTC.hhon, SoundCategory.PLAYERS, old -> {
                            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                            if (entity instanceof EntityPlayer && !entity.field_70128_L) {
                                return entity.func_174791_d();
                            }
                            return null;
                        }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 1.0f, false, 0);
                        if (ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) && handle instanceof SoundHandleSpecialSound) {
                            ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
                        }
                        handle = ThaumicAugmentation.proxy.playSpecialSound(SoundsTC.jacobs, SoundCategory.PLAYERS, old -> {
                            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                            if (entity instanceof EntityPlayer && !entity.field_70128_L && CREATIVE_FLIGHT.contains((EntityPlayer)entity)) {
                                return entity.func_174791_d();
                            }
                            return null;
                        }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 0.05f, 1.0f, true, 0);
                        if (!ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) || !(handle instanceof SoundHandleSpecialSound)) break;
                        ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
                        break;
                    }
                    ISoundHandle handle = ThaumicAugmentation.proxy.playSpecialSound(SoundsTC.hhoff, SoundCategory.PLAYERS, old -> {
                        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                        if (entity instanceof EntityPlayer && !entity.field_70128_L) {
                            return entity.func_174791_d();
                        }
                        return null;
                    }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 1.0f, false, 0);
                    if (!ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) || !(handle instanceof SoundHandleSpecialSound)) break;
                    ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
                    break;
                }
            }
            if (flying) {
                CREATIVE_FLIGHT.add(player);
            } else {
                CREATIVE_FLIGHT.remove(player);
            }
        }
    }

    public static void onBoostChange(EntityPlayer player, boolean boost) {
        int id = player.func_145782_y();
        if (boost && !ELYTRA_BOOSTS.contains(player)) {
            ELYTRA_BOOSTS.add(player);
            ISoundHandle handle = ThaumicAugmentation.proxy.playSpecialSound(TASounds.ELYTRA_BOOST_START, SoundCategory.PLAYERS, old -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                if (entity instanceof EntityPlayer && !entity.field_70128_L) {
                    return entity.func_174791_d();
                }
                return null;
            }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 1.0f, false, 0);
            if (ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) && handle instanceof SoundHandleSpecialSound) {
                ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
            }
            handle = ThaumicAugmentation.proxy.playSpecialSound(TASounds.ELYTRA_BOOST_LOOP, SoundCategory.PLAYERS, old -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                if (entity instanceof EntityPlayer && !entity.field_70128_L && ELYTRA_BOOSTS.contains((EntityPlayer)entity)) {
                    return entity.func_174791_d();
                }
                return null;
            }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 0.6f, 1.0f, true, 0);
            if (ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) && handle instanceof SoundHandleSpecialSound) {
                ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
            }
        } else if (!boost && ELYTRA_BOOSTS.contains(player)) {
            ELYTRA_BOOSTS.remove(player);
            ISoundHandle handle = ThaumicAugmentation.proxy.playSpecialSound(TASounds.ELYTRA_BOOST_END, SoundCategory.PLAYERS, old -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                if (entity instanceof EntityPlayer && !entity.field_70128_L) {
                    return entity.func_174791_d();
                }
                return null;
            }, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 1.0f, false, 0);
            if (ThaumicAugmentation.proxy.isEntityRenderView((Entity)player) && handle instanceof SoundHandleSpecialSound) {
                ((SoundHandleSpecialSound)handle).setAttenuationType(ISound.AttenuationType.NONE);
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("thaumicaugmentation")) {
            TAConfigHolder.syncLocally();
            if (ThaumicAugmentation.proxy.isSingleplayer()) {
                TAConfigHolder.loadConfigValues(Side.SERVER);
            } else {
                TAConfigHolder.loadConfigValues(Side.CLIENT);
            }
            for (Runnable r : TAConfigHolder.getListeners()) {
                r.run();
            }
        }
    }

    public static void onClientEquipmentChange(ClientLivingEquipmentChangeEvent event) {
        if (!ThaumicAugmentation.proxy.isSingleplayer()) {
            AugmentEventHandler.onEquipmentChange(event.getEntityLiving());
        }
    }

    public static boolean isBoosting(EntityPlayer player) {
        return ELYTRA_BOOSTS.contains(player);
    }

    public static void onRecoil(EntityLivingBase living, BiFunction<EntityLivingBase, Long, Float> func, long duration) {
        RECOIL.put(living, new RecoilEntry(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 1L, duration, func));
    }

    static {
        RECOIL = new WeakHashMap();
    }

    private static class RecoilEntry {
        public final long start;
        public final long duration;
        public final BiFunction<EntityLivingBase, Long, Float> recoilFunc;

        public RecoilEntry(long startTime, long totalTime, BiFunction<EntityLivingBase, Long, Float> recoilPattern) {
            this.start = startTime;
            this.duration = totalTime;
            this.recoilFunc = recoilPattern;
        }
    }
}

