/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import thaumcraft.api.casters.ICaster;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.tile.INameableTile;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedInventory;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedInventory;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileWardedChest;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;
import thecodex6824.thaumicaugmentation.init.GUIHandler;

public class BlockWardedChest
extends BlockTABase
implements IHorizontallyDirectionalBlock,
IItemBlockProvider,
IUnwardableBlock,
IWardParticles {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockWardedChest() {
        super(Material.field_151573_f);
        this.func_149722_s();
        this.func_149752_b(2.1267647E37f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.SOUTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{IHorizontallyDirectionalBlock.DIRECTION}).add(new IUnlistedProperty[]{Properties.AnimationProperty}).add(new IProperty[]{Properties.StaticProperty}).build();
    }

    public int func_176201_c(IBlockState state) {
        return BitUtil.setBits(0, 1, 3, ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_176736_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_176731_b((int)BitUtil.getBits(meta, 1, 3)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWardedChest();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    protected void dropContents(World world, BlockPos pos) {
        IWardedInventory items;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && (items = (IWardedInventory)te.getCapability(CapabilityWardedInventory.WARDED_INVENTORY, null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stack = items.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 2.0, (double)pos.func_177956_o() + 0.5 + Math.abs(world.field_73012_v.nextGaussian() / 2.0), (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 2.0, stack));
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropContents(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof INameableTile && ((INameableTile)te).hasCustomName()) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
            ItemStack renamed = ItemStack.field_190927_a;
            Iterator it = drops.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (stack.func_77973_b() != this.func_180660_a(state, rand, fortune)) continue;
                it.remove();
                renamed = stack.func_77946_l();
                renamed.func_151001_c(((INameableTile)te).getCustomName());
            }
            drops.add((Object)renamed);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null) {
            IWardedTile warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null);
            if (warded != null && warded.hasPermission((EntityLivingBase)player)) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof ICaster) || !player.func_70093_af()) {
                    player.openGui((Object)ThaumicAugmentation.instance, GUIHandler.TAInventory.WARDED_CHEST.getID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IWardedTile warded;
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            warded.setOwner(placer.func_110124_au());
        }
        if (stack.func_82837_s() && tile instanceof INameableTile) {
            ((INameableTile)tile).setCustomName(stack.func_82833_r());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

