/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.common.entity.ai.EntityLookHelperUnlimitedPitch;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;
import thecodex6824.thaumicaugmentation.init.GUIHandler;

public class EntityCelestialObserver
extends EntityCreature
implements IEntityOwnable {
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityCelestialObserver.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Byte> SCANS = EntityDataManager.func_187226_a(EntityCelestialObserver.class, (DataSerializer)DataSerializers.field_187191_a);
    @Nonnull
    protected static final ItemStack PAPER = new ItemStack(Items.field_151121_aF);
    protected WeakReference<Entity> ownerRef;
    protected int[] lastScanTimes;
    protected ItemStackHandler inventory;

    public EntityCelestialObserver(World world) {
        super(world);
        this.field_70749_g = new EntityLookHelperUnlimitedPitch((EntityLiving)this, false);
        this.ownerRef = new WeakReference<Object>(null);
        this.lastScanTimes = new int[6];
        Arrays.fill(this.lastScanTimes, -1);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70131_O = 2.0f;
        this.inventory = new ItemStackHandler(19){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return super.isItemValid(slot, stack) && OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)stack, (boolean)false);
                }
                return false;
            }
        };
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(13.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCANS, (Object)7);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAILookAtScan());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtCelestialBody());
    }

    protected boolean hasPaper() {
        boolean paper = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)this.inventory.getStackInSlot(i), (boolean)false)) continue;
            paper = true;
            break;
        }
        return paper;
    }

    protected boolean consumePaper() {
        boolean paper = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)this.inventory.getStackInSlot(i), (boolean)false) || !OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)this.inventory.extractItem(i, 1, false), (boolean)false)) continue;
            paper = true;
            break;
        }
        return paper;
    }

    protected boolean tryInsert(@Nonnull ItemStack toInsert, EnumFacing side) {
        IItemHandler other;
        TileEntity test = this.field_70170_p.func_175625_s(this.func_180425_c().func_177972_a(side));
        return test != null && (other = (IItemHandler)test.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) != null && ItemHandlerHelper.insertItem((IItemHandler)other, (ItemStack)toInsert, (boolean)false).func_190926_b();
    }

    protected boolean checkOrBypassResearch(String key, int cacheIndex, int day) {
        if (!((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent()) {
            return true;
        }
        NBTTagCompound writeback = null;
        IPlayerKnowledge cap = null;
        Entity owner = this.func_70902_q();
        if (owner == null && TAConfig.allowOfflinePlayerResearch.getValue().booleanValue()) {
            writeback = ThaumicAugmentation.proxy.getOfflinePlayerNBT((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get());
            if (writeback == null) {
                return true;
            }
            cap = (IPlayerKnowledge)ThaumcraftCapabilities.KNOWLEDGE.getDefaultInstance();
            if (cap != null) {
                cap.deserializeNBT((NBTBase)writeback.func_74775_l("ForgeCaps").func_74775_l("thaumcraft:knowledge"));
            }
        } else if (owner != null) {
            cap = (IPlayerKnowledge)owner.getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
        }
        if (cap == null) {
            return true;
        }
        if (cap.isResearchKnown(key)) {
            this.lastScanTimes[cacheIndex] = (int)(this.field_70170_p.func_82737_E() / 24000L);
            return false;
        }
        cap.addResearch(key);
        ArrayList<String> list = new ArrayList<String>();
        for (String k : cap.getResearchList()) {
            if (!k.startsWith("CEL_") || k.startsWith("CEL_" + day)) continue;
            list.add(k);
        }
        for (String k : list) {
            cap.removeResearch(k);
        }
        if (writeback != null) {
            writeback.func_74775_l("ForgeCaps").func_74782_a("thaumcraft:knowledge", cap.serializeNBT());
            ThaumicAugmentation.proxy.saveOfflinePlayerNBT((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get(), writeback);
        } else if (owner instanceof EntityPlayerMP) {
            cap.sync((EntityPlayerMP)owner);
        }
        return true;
    }

    public boolean isDisabled() {
        if (this.field_70170_p.func_175640_z(this.func_180425_c())) {
            return true;
        }
        IBlockState rail = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
        return rail.func_177230_c() == BlocksTC.activatorRail && (Boolean)rail.func_177229_b((IProperty)BlockRailPowered.field_176569_M) != false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70177_z = this.field_70759_as = MathHelper.func_76142_g((float)this.field_70759_as);
            this.field_70126_B = this.field_70758_at;
            if (!this.isDisabled()) {
                if (this.field_70173_aa % 20 == 0) {
                    ItemStack remain;
                    ItemStack extract;
                    ItemStack result;
                    ItemStack contained;
                    int i;
                    IItemHandler other;
                    if (this.field_70173_aa % 120 == 0) {
                        this.func_70691_i(1.0f);
                    }
                    boolean filled = false;
                    TileEntity test = this.field_70170_p.func_175625_s(this.func_180425_c());
                    if (test != null && (other = (IItemHandler)test.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
                        for (i = 0; i < other.getSlots(); ++i) {
                            contained = other.getStackInSlot(i);
                            if (!OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)contained, (boolean)false) || (result = this.inventory.insertItem(0, contained, true)) == contained) continue;
                            extract = other.extractItem(i, this.inventory.getSlotLimit(0) - this.inventory.getStackInSlot(0).func_190916_E(), false);
                            remain = this.inventory.insertItem(0, extract, false);
                            if (!remain.func_190926_b()) {
                                other.insertItem(i, remain, false);
                            }
                            filled = true;
                            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsTC.page, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                            break;
                        }
                    }
                    if (!filled && this.field_70163_u - Math.floor(this.field_70163_u) < 0.51 && (test = this.field_70170_p.func_175625_s(this.func_180425_c().func_177977_b())) != null && (other = (IItemHandler)test.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
                        for (i = 0; i < other.getSlots(); ++i) {
                            contained = other.getStackInSlot(i);
                            if (!OreDictionary.itemMatches((ItemStack)PAPER, (ItemStack)contained, (boolean)false) || (result = this.inventory.insertItem(0, contained, true)) == contained) continue;
                            extract = other.extractItem(i, this.inventory.getSlotLimit(0) - this.inventory.getStackInSlot(0).func_190916_E(), false);
                            remain = this.inventory.insertItem(0, extract, false);
                            if (!remain.func_190926_b()) {
                                other.insertItem(i, remain, false);
                            }
                            filled = true;
                            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsTC.page, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                            break;
                        }
                    }
                    ArrayList<IItemHandler> outputs = new ArrayList<IItemHandler>();
                    for (EnumFacing f : EnumFacing.field_176754_o) {
                        IItemHandler other2;
                        test = this.field_70170_p.func_175625_s(this.func_180425_c().func_177972_a(f));
                        if (test == null || (other2 = (IItemHandler)test.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) == null) continue;
                        outputs.add(other2);
                    }
                    if (!outputs.isEmpty()) {
                        block3: for (int slot = 1; slot < this.inventory.getSlots(); ++slot) {
                            ItemStack contained2 = this.inventory.getStackInSlot(slot);
                            if (contained2.func_190926_b()) continue;
                            for (IItemHandler output : outputs) {
                                if (ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)contained2, (boolean)true) == contained2) continue;
                                ItemStack out = this.inventory.extractItem(slot, contained2.func_190916_E(), false);
                                ItemStack remain2 = ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)out, (boolean)false);
                                if (remain2.func_190926_b()) continue block3;
                                this.inventory.insertItem(slot, remain2, false);
                                contained2 = this.inventory.getStackInSlot(slot);
                            }
                        }
                    }
                } else if (!this.func_175446_cd() && this.field_70173_aa % 50 == 0 && this.hasPaper() && !this.field_70170_p.func_72896_J() && this.field_70170_p.func_175678_i(new BlockPos(this.func_70040_Z().func_72441_c(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v))) && this.field_70170_p.field_73011_w.func_76569_d()) {
                    boolean night;
                    float y = (this.field_70177_z + 90.0f) % 360.0f;
                    float x = -this.field_70125_A;
                    float angle = (this.field_70170_p.func_72826_c(0.0f) + 0.25f) * 360.0f % 360.0f;
                    boolean bl = night = angle > 180.0f;
                    if (!night && angle > 15.0f || night && angle > 195.0f) {
                        boolean inRangeYaw = false;
                        boolean inRangePitch = false;
                        if (night) {
                            angle -= 180.0f;
                        }
                        if (angle > 90.0f) {
                            inRangeYaw = Math.abs(Math.abs(y) - 180.0f) < 1.5f;
                            inRangePitch = Math.abs(180.0f - angle - x) < 1.5f;
                        } else {
                            inRangeYaw = Math.abs(y) < 1.5f;
                            inRangePitch = Math.abs(angle - x) < 1.5f;
                        }
                        boolean scanned = false;
                        if (inRangeYaw && inRangePitch && (night ? this.getScanMoon() : this.getScanSun())) {
                            int day = (int)(this.field_70170_p.func_82737_E() / 24000L);
                            int meta = night ? 5 + this.field_70170_p.field_73011_w.func_76559_b(this.field_70170_p.func_72820_D()) : 0;
                            ItemStack toMake = new ItemStack(ItemsTC.celestialNotes, 1, meta);
                            if (this.lastScanTimes[night ? 1 : 0] != day && ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toMake, (boolean)true).func_190926_b() && this.checkOrBypassResearch("CEL_" + day + "_" + (night ? "Moon" + (meta - 5) : "Sun"), night ? 1 : 0, day)) {
                                ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toMake, (boolean)false);
                                this.consumePaper();
                                this.lastScanTimes[night ? 1 : 0] = day;
                                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsTC.scan, SoundCategory.NEUTRAL, 0.5f, 0.8f);
                                scanned = true;
                            }
                        }
                        if (night && !scanned && this.getScanStars()) {
                            EnumFacing face = this.func_184172_bi();
                            int day = (int)(this.field_70170_p.func_82737_E() / 24000L);
                            int meta = face.func_176745_a() - 1;
                            ItemStack toMake = new ItemStack(ItemsTC.celestialNotes, 1, meta);
                            if (this.lastScanTimes[face.func_176745_a()] != day && Math.abs(MathHelper.func_76142_g((float)(this.field_70177_z - face.func_185119_l()))) < 1.5f && ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toMake, (boolean)true).func_190926_b() && this.checkOrBypassResearch("CEL_" + day + "_Star" + (meta - 1), face.func_176745_a(), day)) {
                                ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toMake, (boolean)false);
                                this.consumePaper();
                                this.lastScanTimes[face.func_176745_a()] = day;
                                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsTC.scan, SoundCategory.NEUTRAL, 0.5f, 0.8f);
                                scanned = true;
                            }
                        }
                    }
                }
            }
        }
    }

    protected void func_70626_be() {
        if (this.isDisabled()) {
            Vec3d base = new Vec3d(this.field_70165_t + 0.35, this.field_70163_u + 0.35, this.field_70161_v);
            this.field_70749_g.func_75650_a(base.field_72450_a, base.field_72448_b, base.field_72449_c, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            this.field_70749_g.func_75649_a();
        } else {
            super.func_70626_be();
        }
    }

    @Nullable
    public Entity func_70902_q() {
        if ((this.ownerRef.get() == null || ((Entity)this.ownerRef.get()).field_70128_L) && ((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent()) {
            this.ownerRef.clear();
            List entities = this.field_70170_p.func_175644_a(Entity.class, entity -> entity != null && entity.getPersistentID().equals(((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get()));
            if (!entities.isEmpty()) {
                this.ownerRef = new WeakReference(entities.get(0));
            } else {
                List players = !this.field_70170_p.field_72995_K ? FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v() : this.field_70170_p.func_175661_b(EntityPlayer.class, Predicates.alwaysTrue());
                for (EntityPlayer p : players) {
                    if (!p.func_110124_au().equals(((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get())) continue;
                    this.ownerRef = new WeakReference<EntityPlayer>(p);
                    break;
                }
            }
        }
        return (Entity)this.ownerRef.get();
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).orNull();
    }

    public void setOwner(Entity newOwner) {
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.of((Object)newOwner.getPersistentID()));
        this.ownerRef = new WeakReference<Entity>(newOwner);
    }

    public boolean func_184191_r(Entity other) {
        Entity owner = this.func_70902_q();
        if (other.equals((Object)owner)) {
            return true;
        }
        if (owner != null && other.func_184191_r(this.func_70902_q())) {
            return true;
        }
        return super.func_184191_r(other);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public float func_70047_e() {
        return 1.2f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 240;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsTC.clack;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsTC.clack;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsTC.tool;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(TAItems.CELESTIAL_OBSERVER_PLACER);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (player.equals((Object)this.func_70902_q())) {
                if (player.func_70093_af()) {
                    this.func_184185_a(SoundsTC.zap, 1.0f, 1.0f);
                    this.func_70099_a(new ItemStack(TAItems.CELESTIAL_OBSERVER_PLACER), 0.5f);
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        this.func_70099_a(this.inventory.extractItem(i, this.inventory.getSlotLimit(i), false), 0.5f);
                    }
                    this.func_70106_y();
                    player.func_184609_a(hand);
                    return true;
                }
                player.openGui((Object)ThaumicAugmentation.instance, GUIHandler.TAInventory.CELESTIAL_OBSERVER.getID(), this.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
            player.func_146105_b(new TextComponentTranslation("tc.notowned", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150217_b(Boolean.valueOf(true))), true);
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.func_70099_a(this.inventory.extractItem(i, this.inventory.getSlotLimit(i), false), 0.5f);
            }
        }
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 2;
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
        super.func_70653_a(entity, strength / 10.0f, xRatio, zRatio);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x / 20.0, y, z / 20.0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void setLastScanTimes(int[] times) {
        this.lastScanTimes = Arrays.copyOf(times, this.lastScanTimes.length);
    }

    public int[] getLastScanTimes() {
        return this.lastScanTimes;
    }

    public void setScanSun(boolean scan) {
        this.field_70180_af.func_187227_b(SCANS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 0, scan)));
    }

    public boolean getScanSun() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 0);
    }

    public void setScanMoon(boolean scan) {
        this.field_70180_af.func_187227_b(SCANS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 1, scan)));
    }

    public boolean getScanMoon() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 1);
    }

    public void setScanStars(boolean scan) {
        this.field_70180_af.func_187227_b(SCANS, (Object)((byte)BitUtil.setOrClearBit(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 2, scan)));
    }

    public boolean getScanStars() {
        return BitUtil.isBitSet(((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue(), 2);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).isPresent()) {
            compound.func_186854_a("owner", (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_ID)).get());
        }
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74783_a("scanTimes", this.lastScanTimes);
        compound.func_74774_a("scans", ((Byte)this.field_70180_af.func_187225_a(SCANS)).byteValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("owner")) {
            this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.of((Object)compound.func_186857_a("owner")));
        }
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.lastScanTimes = compound.func_74759_k("scanTimes");
        if (this.lastScanTimes.length != 6) {
            this.lastScanTimes = new int[6];
        }
        this.field_70180_af.func_187227_b(SCANS, (Object)compound.func_74771_c("scans"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected class EntityAILookAtScan
    extends EntityAIBase {
        protected int currentTask = -1;

        public EntityAILookAtScan() {
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            if (!EntityCelestialObserver.this.isDisabled() && !EntityCelestialObserver.this.field_70170_p.func_72896_J()) {
                int day = (int)(EntityCelestialObserver.this.field_70170_p.func_82737_E() / 24000L);
                float angle = (EntityCelestialObserver.this.field_70170_p.func_72826_c(0.0f) + 0.25f) * 360.0f % 360.0f;
                if (angle > 195.0f) {
                    for (int i = 1; i < EntityCelestialObserver.this.lastScanTimes.length; ++i) {
                        if (EntityCelestialObserver.this.lastScanTimes[i] == day || !(i == 1 ? EntityCelestialObserver.this.getScanMoon() : EntityCelestialObserver.this.getScanStars())) continue;
                        return true;
                    }
                    return false;
                }
                if (angle > 15.0f && EntityCelestialObserver.this.getScanSun()) {
                    return EntityCelestialObserver.this.lastScanTimes[0] != day;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!EntityCelestialObserver.this.isDisabled()) {
                int day = (int)(EntityCelestialObserver.this.field_70170_p.func_82737_E() / 24000L);
                return this.currentTask != -1 && EntityCelestialObserver.this.lastScanTimes[this.currentTask] != day;
            }
            return false;
        }

        public void func_75251_c() {
            this.currentTask = -1;
        }

        public void func_75249_e() {
            int day = (int)(EntityCelestialObserver.this.field_70170_p.func_82737_E() / 24000L);
            float angle = (EntityCelestialObserver.this.field_70170_p.func_72826_c(0.0f) + 0.25f) * 360.0f % 360.0f;
            if (angle > 195.0f) {
                for (int i = 1; i < EntityCelestialObserver.this.lastScanTimes.length; ++i) {
                    if (EntityCelestialObserver.this.lastScanTimes[i] == day || !(i == 1 ? EntityCelestialObserver.this.getScanMoon() : EntityCelestialObserver.this.getScanStars())) continue;
                    this.currentTask = i;
                    break;
                }
            } else if (angle > 15.0f && EntityCelestialObserver.this.lastScanTimes[0] != day && EntityCelestialObserver.this.getScanSun()) {
                this.currentTask = 0;
            }
        }

        public void func_75246_d() {
            switch (this.currentTask) {
                case 0: 
                case 1: {
                    float angle = (EntityCelestialObserver.this.field_70170_p.func_72826_c(0.0f) + 0.25f) * 360.0f % 180.0f;
                    Vec3d target = EntityCelestialObserver.this.func_174806_f(-angle, 270.0f).func_186678_a(48.0);
                    EntityCelestialObserver.this.func_70671_ap().func_75650_a(EntityCelestialObserver.this.field_70165_t + target.field_72450_a, EntityCelestialObserver.this.field_70163_u + target.field_72448_b, EntityCelestialObserver.this.field_70161_v + target.field_72449_c, (float)EntityCelestialObserver.this.func_184649_cE(), (float)EntityCelestialObserver.this.func_70646_bf());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    EnumFacing f = EnumFacing.func_82600_a((int)this.currentTask);
                    EntityCelestialObserver.this.func_70671_ap().func_75650_a(EntityCelestialObserver.this.field_70165_t + (double)((float)f.func_82601_c() * 128.0f), EntityCelestialObserver.this.field_70163_u + 64.0, EntityCelestialObserver.this.field_70161_v + (double)((float)f.func_82599_e() * 128.0f), (float)EntityCelestialObserver.this.func_184649_cE(), (float)EntityCelestialObserver.this.func_70646_bf());
                    break;
                }
                default: {
                    this.func_75251_c();
                }
            }
        }
    }

    protected class EntityAILookAtCelestialBody
    extends EntityAIBase {
        public EntityAILookAtCelestialBody() {
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return !EntityCelestialObserver.this.isDisabled() && !EntityCelestialObserver.this.field_70170_p.func_72896_J();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            float angle = (EntityCelestialObserver.this.field_70170_p.func_72826_c(0.0f) + 0.25f) * 360.0f % 180.0f;
            Vec3d target = EntityCelestialObserver.this.func_174806_f(-angle, 270.0f).func_186678_a(48.0);
            EntityCelestialObserver.this.func_70671_ap().func_75650_a(EntityCelestialObserver.this.field_70165_t + target.field_72450_a, EntityCelestialObserver.this.field_70163_u + target.field_72448_b, EntityCelestialObserver.this.field_70161_v + target.field_72449_c, (float)EntityCelestialObserver.this.func_184649_cE(), (float)EntityCelestialObserver.this.func_70646_bf());
        }
    }
}

