/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.entity.CapabilityPortalState;
import thecodex6824.thaumicaugmentation.api.entity.IPortalState;
import thecodex6824.thaumicaugmentation.api.entity.PlayerMovementAbilityManager;
import thecodex6824.thaumicaugmentation.api.entity.PortalStateManager;
import thecodex6824.thaumicaugmentation.api.event.FocusTouchGetEntityEvent;
import thecodex6824.thaumicaugmentation.api.util.RaytraceHelper;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;
import thecodex6824.thaumicaugmentation.common.item.ItemThaumiumRobes;
import thecodex6824.thaumicaugmentation.common.network.PacketLivingEquipmentChange;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.ChunkGeneratorEmptiness;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public class EntityEventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IPortalState state = (IPortalState)event.getEntity().getCapability(CapabilityPortalState.PORTAL_STATE, null);
        if (state != null && state.isInPortal()) {
            PortalStateManager.markEntityInPortal(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onProjectileCollide(ProjectileImpactEvent event) {
        EntityFocusShield s;
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityEnderPearl) {
            IWardStorage storage;
            MapGenEldritchSpire.Start start;
            WorldServer w = (WorldServer)event.getEntity().func_130014_f_();
            BlockPos check = event.getEntity().func_180425_c();
            if (w.func_72863_F().func_193413_a((World)w, "EldritchSpire", check) && (start = ((ChunkGeneratorEmptiness)w.func_72863_F().field_186029_c).getSpireStart(check)) != null && (storage = (IWardStorage)w.func_175726_f(check).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer && ((IWardStorageServer)storage).isWardOwner(start.getWard())) {
                event.getEntity().func_70106_y();
                Vec3d pos = event.getEntity().func_174791_d();
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.ENDER_EYE_BREAK, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, Item.func_150891_b((Item)Items.field_151079_bi)), event.getEntity());
                event.setCanceled(true);
                return;
            }
        }
        if (event.getRayTraceResult().field_72308_g instanceof EntityFocusShield && (s = (EntityFocusShield)event.getRayTraceResult().field_72308_g).func_70902_q() != null) {
            Entity projectile = event.getEntity();
            if (projectile instanceof EntityThrowable && s.func_70902_q().equals((Object)((EntityThrowable)projectile).func_85052_h())) {
                event.setCanceled(true);
                return;
            }
            if (projectile instanceof EntityArrow && s.func_70902_q().equals((Object)((EntityArrow)projectile).field_70250_c)) {
                event.setCanceled(true);
                return;
            }
            if (projectile instanceof EntityFireball && s.func_70902_q().equals((Object)((EntityFireball)projectile).field_70235_a)) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PortalStateManager.tick();
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.func_130014_f_().field_72995_K) {
            PacketLivingEquipmentChange packet = new PacketLivingEquipmentChange(entity.func_145782_y(), event.getSlot(), event.getTo());
            TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)entity);
            if (entity instanceof EntityPlayerMP) {
                TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && PlayerMovementAbilityManager.isValidSideForMovement(player = (EntityPlayer)event.getEntityLiving())) {
            PlayerMovementAbilityManager.tick(player);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        ItemStack head = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD);
        if (head.func_77973_b() == TAItems.THAUMIUM_ROBES_HOOD && head.func_77942_o() && head.func_77978_p().func_74762_e("maskType") == ItemThaumiumRobes.MaskType.WITHER.getID() && event.getSource().func_76346_g() instanceof EntityLivingBase && event.getEntity().func_130014_f_().field_73012_v.nextFloat() < event.getAmount() / 10.0f) {
            PotionEffect wither = new PotionEffect(MobEffects.field_82731_v, 80);
            EntityLivingBase base = (EntityLivingBase)event.getSource().func_76346_g();
            if (base.func_70687_e(wither)) {
                base.func_70690_d(wither);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && (head = ((EntityLivingBase)event.getSource().func_76346_g()).func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() == TAItems.THAUMIUM_ROBES_HOOD && head.func_77942_o() && head.func_77978_p().func_74762_e("maskType") == ItemThaumiumRobes.MaskType.LIFESTEAL.getID() && event.getEntity().func_130014_f_().field_73012_v.nextFloat() < event.getAmount() / 12.0f) {
            ((EntityLivingBase)event.getSource().func_76346_g()).func_70691_i(1.0f);
        }
    }

    @SubscribeEvent
    public static void onTouchTrajectory(FocusTouchGetEntityEvent event) {
        if (event.getRay() != null && event.getRay().field_72308_g instanceof EntityFocusShield) {
            EntityFocusShield hit = (EntityFocusShield)event.getRay().field_72308_g;
            EntityLivingBase caster = event.getFocus().getPackage().getCaster();
            if (hit.func_184753_b() != null && hit.func_184753_b().equals(caster.func_110124_au())) {
                Pair<Entity, Vec3d> p = RaytraceHelper.raytraceEntityAndPos(caster, event.getRange(), e -> e != hit);
                if (p != null) {
                    event.setRay(new RayTraceResult((Entity)p.getKey(), (Vec3d)p.getValue()));
                } else {
                    event.setRay(null);
                }
            }
        }
    }
}

