/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.IImpulseCannonAugment;
import thecodex6824.thaumicaugmentation.api.entity.IImpulseSpecialEntity;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.util.RaytraceHelper;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProviderNoSave;
import thecodex6824.thaumicaugmentation.common.event.ScheduledTaskHandler;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseBurst;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseRailgunProjectile;
import thecodex6824.thaumicaugmentation.common.network.PacketRecoil;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class ItemImpulseCannonAugment
extends ItemTABase {
    public ItemImpulseCannonAugment() {
        super("railgun", "burst");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected IImpulseCannonAugment createAugmentForStack(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return new ImpulseCannonAugmentBase(){

                @Override
                public IImpulseCannonAugment.LensModelType getLensModel() {
                    return IImpulseCannonAugment.LensModelType.RAILGUN;
                }

                @Override
                public int getMaxUsageDuration() {
                    return 1;
                }

                @Override
                public boolean isTickable(EntityLivingBase user) {
                    return false;
                }

                @Override
                public long getImpetusCostPerUsage(EntityLivingBase user) {
                    return TAConfig.cannonRailgunCost.getValue();
                }

                @Override
                public void onCannonUsage(EntityLivingBase user) {
                    Vec3d target = RaytraceHelper.raytracePosition(user, TAConfig.cannonRailgunRange.getValue());
                    List<Entity> ents = RaytraceHelper.raytraceEntities(user, TAConfig.cannonRailgunRange.getValue());
                    for (Entity e : ents) {
                        if (e instanceof IImpulseSpecialEntity && ((IImpulseSpecialEntity)e).shouldImpulseCannonIgnore(user)) continue;
                        ImpetusAPI.causeImpetusDamage((Entity)user, e, TAConfig.cannonRailgunDamage.getValue().floatValue());
                        if (!(e instanceof IImpulseSpecialEntity) || !((IImpulseSpecialEntity)e).shouldStopRailgunBeam(user)) continue;
                        break;
                    }
                    Random rand = user.func_70681_au();
                    user.func_130014_f_().func_184133_a(null, new BlockPos(user.func_174824_e(1.0f)), TASounds.IMPULSE_CANNON_RAILGUN, SoundCategory.PLAYERS, 1.0f, (rand.nextFloat() - rand.nextFloat()) / 2.0f + 1.0f);
                    PacketImpulseRailgunProjectile packet = new PacketImpulseRailgunProjectile(user.func_145782_y(), target);
                    PacketRecoil recoil = new PacketRecoil(user.func_145782_y(), PacketRecoil.RecoilType.IMPULSE_RAILGUN);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)user);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)recoil, (Entity)user);
                    if (user instanceof EntityPlayer) {
                        ((EntityPlayer)user).func_184811_cZ().func_185145_a(TAItems.IMPULSE_CANNON, TAConfig.cannonRailgunCooldown.getValue().intValue());
                        if (user instanceof EntityPlayerMP) {
                            TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)user);
                            TANetwork.INSTANCE.sendTo((IMessage)recoil, (EntityPlayerMP)user);
                        }
                    }
                }
            };
        }
        return new ImpulseCannonAugmentBase(){

            @Override
            public IImpulseCannonAugment.LensModelType getLensModel() {
                return IImpulseCannonAugment.LensModelType.BURST;
            }

            @Override
            public int getMaxUsageDuration() {
                return 5;
            }

            @Override
            public boolean isTickable(EntityLivingBase user) {
                return false;
            }

            @Override
            public long getImpetusCostPerUsage(EntityLivingBase user) {
                return TAConfig.cannonBurstCost.getValue();
            }

            private void tick(EntityLivingBase user, int num) {
                Entity e = RaytraceHelper.raytraceEntity(user, TAConfig.cannonBurstRange.getValue());
                if (e != null && (!(e instanceof IImpulseSpecialEntity) || !((IImpulseSpecialEntity)e).shouldImpulseCannonIgnore(user)) && ImpetusAPI.causeImpetusDamage((Entity)user, e, TAConfig.cannonBurstDamage.getValue().floatValue()) && num < 2 && e instanceof EntityLivingBase) {
                    EntityLivingBase base = (EntityLivingBase)e;
                    base.field_70172_ad = Math.min(base.field_70172_ad, 1);
                    base.field_110153_bc = 0.0f;
                }
                Random rand = user.func_70681_au();
                user.func_130014_f_().func_184133_a(null, new BlockPos(user.func_174824_e(1.0f)), TASounds.IMPULSE_CANNON_BURST, SoundCategory.PLAYERS, 1.0f, (rand.nextFloat() - rand.nextFloat()) / 2.0f + 1.0f);
                Vec3d target = RaytraceHelper.raytracePosition(user, TAConfig.cannonBurstRange.getValue());
                PacketImpulseBurst packet = new PacketImpulseBurst(user.func_145782_y(), target, num);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)packet, (Entity)user);
                if (user instanceof EntityPlayerMP) {
                    TANetwork.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)user);
                }
                if (num < 2) {
                    ScheduledTaskHandler.registerTask(() -> this.tick(user, num + 1), 2);
                }
            }

            @Override
            public void onCannonUsage(EntityLivingBase user) {
                ScheduledTaskHandler.registerTask(() -> this.tick(user, 0), 0);
                PacketRecoil recoil = new PacketRecoil(user.func_145782_y(), PacketRecoil.RecoilType.IMPULSE_BURST);
                TANetwork.INSTANCE.sendToAllTracking((IMessage)recoil, (Entity)user);
                if (user instanceof EntityPlayer) {
                    ((EntityPlayer)user).func_184811_cZ().func_185145_a(TAItems.IMPULSE_CANNON, TAConfig.cannonBurstCooldown.getValue().intValue());
                    if (user instanceof EntityPlayerMP) {
                        TANetwork.INSTANCE.sendTo((IMessage)recoil, (EntityPlayerMP)user);
                    }
                }
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        SimpleCapabilityProviderNoSave<IAugment> provider = new SimpleCapabilityProviderNoSave<IAugment>(this.createAugmentForStack(stack), CapabilityAugment.AUGMENT);
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    protected static abstract class ImpulseCannonAugmentBase
    implements IImpulseCannonAugment {
        protected ImpulseCannonAugmentBase() {
        }

        @Override
        public boolean canBeAppliedToItem(ItemStack augmentable) {
            return augmentable.func_77973_b() == TAItems.IMPULSE_CANNON;
        }

        @Override
        public boolean isCompatible(ItemStack otherAugment) {
            return !(otherAugment.getCapability(CapabilityAugment.AUGMENT, null) instanceof ImpulseCannonAugmentBase);
        }
    }
}

