/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.item.CapabilityWardAuthenticator;
import thecodex6824.thaumicaugmentation.api.item.IWardAuthenticator;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.capability.WardAuthenticatorKey;
import thecodex6824.thaumicaugmentation.common.capability.WardAuthenticatorThaumiumKey;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderKey;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;

public class ItemKey
extends ItemTABase {
    public ItemKey() {
        super("iron", "brass", "thaumium");
        this.func_77625_d(1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        WardAuthenticatorKey cap = null;
        if (stack.func_77960_j() == 2) {
            cap = new WardAuthenticatorThaumiumKey();
            if (stack.func_77942_o()) {
                int[] coords;
                boolean didSomething = false;
                if (stack.func_77978_p().func_150297_b("boundTo", 8)) {
                    cap.setOwner(UUID.fromString(stack.func_77978_p().func_74779_i("boundTo")));
                    didSomething = true;
                }
                if (stack.func_77978_p().func_150297_b("boundToDisplay", 8)) {
                    cap.setOwnerName(stack.func_77978_p().func_74779_i("boundToDisplay"));
                    didSomething = true;
                }
                if (stack.func_77978_p().func_150297_b("boundType", 8)) {
                    ((WardAuthenticatorThaumiumKey)cap).setBoundType(stack.func_77978_p().func_74779_i("boundType"));
                    didSomething = true;
                }
                if (stack.func_77978_p().func_150297_b("boundTypeDisplay", 8)) {
                    ((WardAuthenticatorThaumiumKey)cap).setBoundTypeName(stack.func_77978_p().func_74779_i("boundTypeDisplay"));
                    didSomething = true;
                }
                if (stack.func_77978_p().func_150297_b("boundBlockPos", 11) && (coords = stack.func_77978_p().func_74759_k("boundBlockPos")).length == 3) {
                    ((WardAuthenticatorThaumiumKey)cap).setBoundPosition(new BlockPos(coords[0], coords[1], coords[2]));
                    didSomething = true;
                }
                if (nbt != null && didSomething) {
                    nbt.func_74782_a("Parent", (NBTBase)cap.serializeNBT());
                }
            }
        } else {
            cap = new WardAuthenticatorKey();
            if (stack.func_77942_o()) {
                boolean didSomething = false;
                if (stack.func_77978_p().func_150297_b("boundTo", 8)) {
                    cap.setOwner(UUID.fromString(stack.func_77978_p().func_74779_i("boundTo")));
                    didSomething = true;
                }
                if (stack.func_77978_p().func_150297_b("boundToDisplay", 8)) {
                    cap.setOwnerName(stack.func_77978_p().func_74779_i("boundToDisplay"));
                    didSomething = true;
                }
                if (nbt != null && didSomething) {
                    nbt.func_74782_a("Parent", (NBTBase)cap.serializeNBT());
                }
            }
        }
        return new CapabilityProviderKey(cap);
    }

    protected int generateKeyColor(UUID id) {
        return id.hashCode();
    }

    public int getKeyColor(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("boundToColor", 3) ? stack.func_77978_p().func_74762_e("boundToColor") : 0;
    }

    protected String formatBlockPos(BlockPos pos) {
        return "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")";
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_77960_j() == 2) {
            ItemStack stack = player.func_184586_b(hand);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                WardAuthenticatorThaumiumKey key;
                IWardedTile warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null);
                if (!player.func_70093_af() && warded != null && (key = (WardAuthenticatorThaumiumKey)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null)) != null && !key.hasOwner()) {
                    key.setOwner(player.func_110124_au());
                    key.setOwnerName(player.func_70005_c_());
                    key.setBoundPosition(pos);
                    key.setBoundType(warded.getUniqueTypeID());
                    key.setBoundTypeName(world.func_180495_p(pos).func_177230_c().func_149739_a() + ".name");
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74768_a("boundToColor", this.generateKeyColor(player.func_110124_au()));
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.key_bound_object", new Object[]{new TextComponentTranslation(world.func_180495_p(pos).func_177230_c().func_149739_a() + ".name", new Object[0]), this.formatBlockPos(pos)}), true);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        IWardAuthenticator auth;
        if (!world.field_72995_K && (auth = (IWardAuthenticator)(stack = player.func_184586_b(hand)).getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null)) instanceof WardAuthenticatorKey) {
            WardAuthenticatorKey key = (WardAuthenticatorKey)auth;
            if (!player.func_70093_af() && stack.func_77960_j() != 2 && !key.hasOwner()) {
                key.setOwner(player.func_110124_au());
                key.setOwnerName(player.func_70005_c_());
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("boundToColor", this.generateKeyColor(player.func_110124_au()));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.key_bound", new Object[0]), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (player.func_70093_af() && key.hasOwner()) {
                key.reset();
                stack.func_77978_p().func_82580_o("boundToColor");
                player.func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.key_unbound", new Object[0]), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p().func_74737_b());
        }
        tag.func_74782_a("cap", (NBTBase)((WardAuthenticatorKey)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((WardAuthenticatorKey)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 1 || stack.func_77960_j() == 2;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        IWardAuthenticator auth;
        if (stack.func_77960_j() == 1) {
            return stack.func_77946_l();
        }
        if (stack.func_77960_j() == 2 && (auth = (IWardAuthenticator)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null)) instanceof WardAuthenticatorKey && ((WardAuthenticatorKey)auth).hasOwner()) {
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        WardAuthenticatorKey key;
        IWardAuthenticator auth = (IWardAuthenticator)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null);
        if (auth instanceof WardAuthenticatorKey && (key = (WardAuthenticatorKey)auth).hasOwner()) {
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.bound_to", new Object[]{key.getOwnerName()}).func_150254_d());
            if (stack.func_77960_j() == 2 && key instanceof WardAuthenticatorThaumiumKey) {
                WardAuthenticatorThaumiumKey thaum = (WardAuthenticatorThaumiumKey)key;
                tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.bound_to_type", new Object[]{new TextComponentTranslation(thaum.getBoundTypeName(), new Object[0])}).func_150254_d());
                tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.bound_to_pos", new Object[]{this.formatBlockPos(thaum.getBoundPosition())}).func_150254_d());
            }
        }
    }
}

