/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IWarpingGear;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.item.CapabilityMorphicTool;
import thecodex6824.thaumicaugmentation.api.item.IMorphicTool;
import thecodex6824.thaumicaugmentation.common.capability.MorphicTool;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderMorphicTool;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;

public class ItemMorphicTool
extends ItemTABase
implements IWarpingGear {
    private static final IMorphicTool NULL_TOOL = new MorphicTool(){

        @Override
        public NBTTagCompound serializeNBT() {
            return null;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
        }

        @Override
        public void setFunctionalStack(ItemStack stack) {
        }

        @Override
        public void setDisplayStack(ItemStack stack) {
        }

        @Override
        public ItemStack getFunctionalStack() {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack getDisplayStack() {
            return ItemStack.field_190927_a;
        }
    };

    public ItemMorphicTool() {
        super(new String[0]);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityProviderMorphicTool tool = new CapabilityProviderMorphicTool(new MorphicTool());
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            tool.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return tool;
    }

    private IMorphicTool getTool(ItemStack stack) {
        IMorphicTool tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
        return tool != null ? tool : NULL_TOOL;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p().func_74737_b());
        }
        tag.func_74782_a("cap", (NBTBase)((MorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((MorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        if (func.func_77973_b() instanceof IWarpingGear) {
            return Math.max(((IWarpingGear)func.func_77973_b()).getWarp(func, player) - 1, 0);
        }
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            oldStack = this.getTool(oldStack).getFunctionalStack();
        }
        if (newStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            newStack = this.getTool(newStack).getFunctionalStack();
        }
        return oldStack.func_77973_b().canContinueUsing(oldStack, newStack);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().canDestroyBlockInCreative(world, pos, func, player);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().canDisableShield(func, shield, entity, attacker);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().canHarvestBlock(state, func);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().doesSneakBypassUse(func, world, pos, player);
    }

    public ImmutableMap<String, ITimeValue> getAnimationParameters(ItemStack stack, World world, EntityLivingBase entity) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().getAnimationParameters(display, world, entity);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getAttributeModifiers(slot, func);
    }

    public int getDamage(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getDamage(func);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_150893_a(func, state);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getDurabilityForDisplay(func);
    }

    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().getFontRenderer(display);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().getForgeRarity(display);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getHarvestLevel(func, toolClass, player, blockState);
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().getHighlightTip(display, displayName);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        if (display.func_190926_b()) {
            return super.func_77653_i(stack);
        }
        return display.func_77973_b().func_77653_i(display);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().func_77661_b(display);
    }

    public int getMaxDamage(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getMaxDamage(func);
    }

    public int func_77626_a(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_77626_a(func);
    }

    public int getMetadata(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getMetadata(func);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        return display.func_77973_b().func_77613_e(display);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getRGBDurabilityForDisplay(func);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().getToolClasses(func);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        if (display.func_190926_b()) {
            return super.func_77667_c(stack);
        }
        return display.func_77973_b().func_77667_c(display);
    }

    public String func_77657_g(ItemStack stack) {
        ItemStack display = this.getTool(stack).getDisplayStack();
        if (display.func_190926_b()) {
            return super.func_77657_g(stack);
        }
        return display.func_77973_b().func_77657_g(display);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_77636_d(func);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_77644_a(func, target, attacker);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().isDamaged(func);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().isShield(func, entity);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_111207_a(func, playerIn, target, hand);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().func_179218_a(func, worldIn, state, pos, entityLiving);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        ItemStack func = this.getTool(itemstack).getFunctionalStack();
        return func.func_77973_b().onBlockStartBreak(func, pos, player);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        ItemStack func = this.getTool(item).getFunctionalStack();
        return func.func_77973_b().onDroppedByPlayer(func, player);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().onEntitySwing(entityLiving, func);
    }

    private static void setStackWithoutAnnoyingNoise(EntityLivingBase entity, EnumHand hand, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (hand == EnumHand.MAIN_HAND) {
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
            } else if (hand == EnumHand.OFF_HAND) {
                player.field_71071_by.field_184439_c.set(0, (Object)stack);
            }
        } else {
            entity.func_184611_a(hand, stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack func = this.getTool(playerIn.func_184586_b(handIn)).getFunctionalStack();
        if (func.func_190926_b()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack old = playerIn.func_184586_b(handIn);
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)playerIn, handIn, func);
        ActionResult innerResult = func.func_77973_b().func_77659_a(worldIn, playerIn, handIn);
        ((IMorphicTool)old.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).setFunctionalStack((ItemStack)innerResult.func_188398_b());
        ActionResult result = new ActionResult(innerResult.func_188397_a(), (Object)old);
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)playerIn, handIn, old);
        if (result.func_188397_a() == EnumActionResult.SUCCESS && playerIn.func_184600_cs() != null) {
            playerIn.func_184602_cy();
            playerIn.func_184598_c(playerIn.func_184600_cs());
        }
        return result;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack func = this.getTool(player.func_184586_b(hand)).getFunctionalStack();
        if (func.func_190926_b()) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        ItemStack old = player.func_184586_b(hand);
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)player, hand, func);
        EnumActionResult result = func.func_77973_b().func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        ((IMorphicTool)old.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).setFunctionalStack(player.func_184586_b(hand));
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)player, hand, old);
        return result;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        ItemStack ret = func.func_77973_b().func_77654_b(func, worldIn, entityLiving);
        ((IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).setFunctionalStack(ret);
        return stack;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack func = this.getTool(player.func_184586_b(hand)).getFunctionalStack();
        if (func.func_190926_b()) {
            return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        }
        ItemStack old = player.func_184586_b(hand);
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)player, hand, func);
        EnumActionResult result = func.func_77973_b().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        ((IMorphicTool)old.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).setFunctionalStack(player.func_184586_b(hand));
        ItemMorphicTool.setStackWithoutAnnoyingNoise((EntityLivingBase)player, hand, old);
        return result;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        func.func_77973_b().func_77615_a(func, worldIn, entityLiving, timeLeft);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        func.func_77973_b().func_77663_a(func, worldIn, entityIn, itemSlot, isSelected);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        func.func_77973_b().onUsingTick(func, player, count);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().onLeftClickEntity(func, player, entity);
    }

    public void setDamage(ItemStack stack, int damage) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length < 4 || !trace[3].getClassName().equals("net.minecraft.server.management.PlayerInteractionManager") && !trace[3].getClassName().equals("net.minecraft.client.multiplayer.PlayerControllerMP")) {
            ItemStack func = this.getTool(stack).getFunctionalStack();
            func.func_77973_b().setDamage(func, damage);
        }
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            oldStack = this.getTool(oldStack).getFunctionalStack();
        }
        if (newStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            newStack = this.getTool(newStack).getFunctionalStack();
        }
        return oldStack.func_77973_b().shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            oldStack = this.getTool(oldStack).getFunctionalStack();
        }
        if (newStack.hasCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)) {
            newStack = this.getTool(newStack).getFunctionalStack();
        }
        return oldStack.func_77973_b().shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        return func.func_77973_b().showDurabilityBar(func);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack func = this.getTool(stack).getFunctionalStack();
        func.func_77973_b().func_77624_a(func, worldIn, tooltip, flagIn);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("ta_special:morphic_tool", "inventory"));
    }
}

