/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.IModelProvider;

public class ItemPrimalCutter
extends ItemTool
implements IWarpingGear,
IModelProvider<Item> {
    public static final Item.ToolMaterial MATERIAL = EnumHelper.addToolMaterial((String)"PRIMAL_CUTTER", (int)5, (int)500, (float)8.0f, (float)TAConfig.primalCutterDamage.getValue().floatValue(), (int)20).setRepairItem(new ItemStack(ItemsTC.ingots, 1, 1));
    private static final ImmutableSet<String> TOOL_CLASSES = ImmutableSet.of((Object)"sword", (Object)"axe");
    private static final ImmutableSet<Block> EFFECTIVE = new ImmutableSet.Builder().add((Object[])new Block[]{Blocks.field_180410_as, Blocks.field_180405_aT, Blocks.field_180387_bt, Blocks.field_150400_ck, Blocks.field_180412_aq, Blocks.field_180404_aQ, Blocks.field_180392_bq, Blocks.field_150487_bG, Blocks.field_150342_X, Blocks.field_150420_aW, Blocks.field_150486_ae, Blocks.field_150375_by, Blocks.field_150462_ai, Blocks.field_180409_at, Blocks.field_180406_aS, Blocks.field_180385_bs, Blocks.field_150401_cl, Blocks.field_150453_bW, Blocks.field_180402_cm, Blocks.field_150373_bw, Blocks.field_150421_aI, Blocks.field_180411_ar, Blocks.field_180403_aR, Blocks.field_180386_br, Blocks.field_150481_bH, Blocks.field_150468_ap, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150428_aP, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150440_ba, Blocks.field_150323_B, Blocks.field_180413_ao, Blocks.field_180407_aO, Blocks.field_180390_bo, Blocks.field_150476_ad, Blocks.field_150344_f, Blocks.field_150423_aK, Blocks.field_150419_aX, Blocks.field_180414_ap, Blocks.field_180408_aP, Blocks.field_180391_bp, Blocks.field_150485_bF, Blocks.field_180393_cK, Blocks.field_150472_an, Blocks.field_150447_bR, Blocks.field_150395_bd, Blocks.field_180394_cL, Blocks.field_150444_as, Blocks.field_150321_G, Blocks.field_150471_bO, Blocks.field_150452_aw, Blocks.field_150376_bx, BlocksTC.alembic, BlocksTC.arcaneEar, BlocksTC.arcaneEarToggle, BlocksTC.arcaneWorkbench, BlocksTC.bannerCrimsonCult, BlocksTC.bellows, BlocksTC.centrifuge, BlocksTC.doubleSlabGreatwood, BlocksTC.doubleSlabSilverwood, BlocksTC.hungryChest, BlocksTC.leafGreatwood, BlocksTC.leafSilverwood, BlocksTC.levitator, BlocksTC.logGreatwood, BlocksTC.logSilverwood, BlocksTC.lootCrateCommon, BlocksTC.lootCrateRare, BlocksTC.lootCrateUncommon, BlocksTC.placeholderTable, BlocksTC.plankGreatwood, BlocksTC.plankSilverwood, BlocksTC.researchTable, BlocksTC.slabGreatwood, BlocksTC.slabSilverwood, BlocksTC.stairsGreatwood, BlocksTC.stairsSilverwood, BlocksTC.tableWood, BlocksTC.taintFibre, BlocksTC.taintLog, TABlocks.VIS_REGENERATOR}).addAll(BlocksTC.banners.values()).build();

    public ItemPrimalCutter() {
        super(3.0f, -2.4f, MATERIAL, EFFECTIVE);
        this.func_77627_a(true);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Material mat = state.func_185904_a();
        return mat != Material.field_151584_j && mat != Material.field_151585_k;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material mat = state.func_185904_a();
        return mat == Material.field_151572_C || mat == Material.field_151584_j || mat == Material.field_151582_l || mat == Material.field_151569_G || mat == Material.field_151575_d ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return TOOL_CLASSES;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(target.func_130014_f_().field_72995_K || target instanceof EntityPlayer && !ThaumicAugmentation.proxy.isPvPEnabled())) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60));
            target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 120));
        }
        stack.func_77972_a(1, attacker);
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (stack.func_77951_h() && entity != null && entity.field_70173_aa % 20 == 0) {
            stack.func_96631_a(-1, world.field_73012_v, entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"ingotVoid"), (ItemStack[])new ItemStack[]{repair});
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    protected boolean preventDrawing(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74767_n("drawingDisabled");
    }

    public int func_77626_a(ItemStack stack) {
        return this.preventDrawing(stack) ? 0 : 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.preventDrawing(stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() == newStack.func_77973_b() && !this.preventDrawing(newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        for (Entity target : player.func_130014_f_().func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(5.0, 4.5, 5.0))) {
            if (target instanceof EntityPlayer || target.field_70128_L || !(target instanceof EntityLivingBase) && !(target instanceof EntityItem) && !(target instanceof EntityFallingBlock) && !(target instanceof EntityBoat) && !(target instanceof EntityMinecart) && !(target instanceof IProjectile) && !(target instanceof EntityTNTPrimed) || target.func_184180_b(EntityLivingBase.class).contains(player)) continue;
            Vec3d playerVector = player.func_174791_d();
            Vec3d targetVector = target.func_174791_d();
            double dist = playerVector.func_72438_d(targetVector) + 0.1;
            Vec3d difference = targetVector.func_178788_d(playerVector);
            target.field_70159_w -= difference.field_72450_a / 2.5 / dist;
            target.field_70181_x -= difference.field_72448_b / 2.5 / dist;
            target.field_70179_y -= difference.field_72449_c / 2.5 / dist;
        }
        if (count % 10 == 0) {
            stack.func_77972_a(1, player);
            if (count % 20 == 0) {
                player.func_184185_a(SoundsTC.craftfail, 0.5f, 0.35f + player.func_130014_f_().field_73012_v.nextFloat() * 0.15f);
            }
        }
        if (!player.func_130014_f_().field_72995_K) {
            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SMOKE_SPIRAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)player.field_70130_N / 2.0, player.func_130014_f_().field_73012_v.nextInt(360), player.field_70163_u - 1.0, 2236207.0), (Entity)player);
        } else {
            ThaumicAugmentation.proxy.getRenderHelper().renderSmokeSpiral(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70130_N / 2.0f, player.func_130014_f_().field_73012_v.nextInt(360), (int)player.field_70163_u - 1, 0x221F2F);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.WEAPON || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            ItemStack stack = new ItemStack((Item)this);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.ARCING, (int)2);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.BURROWING, (int)1);
            items.add((Object)stack);
            stack = stack.func_77946_l();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("drawingDisabled", true);
            items.add((Object)stack);
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ELDRITCH;
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(new TextComponentTranslation("enchantment.special.sapgreat", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150254_d());
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("drawingDisabled")) {
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.drawing_disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)).func_150254_d());
        }
    }
}

