/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.WeakImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.BufferedImpetusProvider;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.tile.trait.IAnimatedTile;
import thecodex6824.thaumicaugmentation.common.tile.trait.IBreakCallback;
import thecodex6824.thaumicaugmentation.common.util.AnimationHelper;

public class TileImpetusDrainer
extends TileEntity
implements ITickable,
IBreakCallback,
IAnimatedTile {
    protected BufferedImpetusProvider provider;
    protected Vec3d lastRiftPos;
    protected WeakImpetusStorage storage = new WeakImpetusStorage(){

        @Override
        public long extractEnergy(long maxToExtract, boolean simulate) {
            long result = super.extractEnergy(maxToExtract, simulate);
            if (result > 0L && !simulate) {
                ImpetusAPI.createImpetusParticles(TileImpetusDrainer.this.field_145850_b, TileImpetusDrainer.this.lastRiftPos, new Vec3d((double)TileImpetusDrainer.this.field_174879_c.func_177958_n() + 0.5, (double)TileImpetusDrainer.this.field_174879_c.func_177956_o() + 0.5, (double)TileImpetusDrainer.this.field_174879_c.func_177952_p() + 0.5));
            }
            return result;
        }

        @Override
        public void onEnergyChanged() {
            TileImpetusDrainer.this.func_70296_d();
        }
    };
    protected IAnimationStateMachine asm;
    protected TimeValues.VariableValue actionTime;
    protected boolean lastState = false;
    protected int ticks;

    public TileImpetusDrainer() {
        this.provider = new BufferedImpetusProvider(0, 2, (IImpetusStorage)this.storage){

            @Override
            public Vec3d getBeamEndpoint() {
                return new Vec3d((double)TileImpetusDrainer.this.field_174879_c.func_177958_n() + 0.5, (double)TileImpetusDrainer.this.field_174879_c.func_177956_o() + 0.4375, (double)TileImpetusDrainer.this.field_174879_c.func_177952_p() + 0.5);
            }
        };
        this.ticks = ThreadLocalRandom.current().nextInt(20);
        this.actionTime = new TimeValues.VariableValue(-1.0f);
        this.asm = ThaumicAugmentation.proxy.loadASM(new ResourceLocation("thaumicaugmentation", "asms/block/impetus_drainer.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)new TimeValues.VariableValue(1.0f), (Object)"act_time", (Object)this.actionTime, (Object)"delay", (Object)new TimeValues.VariableValue((float)this.ticks)));
    }

    protected void findRift() {
        List rifts = this.field_145850_b.func_72872_a(EntityFluxRift.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(8.0));
        rifts.sort((rift1, rift2) -> Double.compare(rift1.func_180425_c().func_177951_i((Vec3i)this.field_174879_c), rift2.func_180425_c().func_177951_i((Vec3i)this.field_174879_c)));
        for (EntityFluxRift rift : rifts) {
            IImpetusStorage riftStorage;
            if (rift.field_70128_L || (riftStorage = (IImpetusStorage)rift.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) == null) continue;
            for (Vec3d point : rift.points) {
                Vec3d translated = rift.func_174791_d().func_178787_e(point);
                double dX = Math.max(-1.0, Math.min(1.0, translated.field_72450_a - (double)this.field_174879_c.func_177958_n()));
                double dY = Math.max(-1.0, Math.min(1.0, translated.field_72448_b - (double)this.field_174879_c.func_177956_o()));
                double dZ = Math.max(-1.0, Math.min(1.0, translated.field_72449_c - (double)this.field_174879_c.func_177952_p()));
                RayTraceResult result = this.field_145850_b.func_147447_a(new Vec3d((double)this.field_174879_c.func_177958_n() + dX, (double)this.field_174879_c.func_177956_o() + dY, (double)this.field_174879_c.func_177952_p() + dZ), rift.func_174791_d().func_178787_e(point), false, true, false);
                if (result != null && result.func_178782_a() != null) continue;
                this.storage.bind(riftStorage);
                this.lastRiftPos = translated;
                return;
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 60 == 0 && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue()) {
            this.findRift();
        } else if (!this.field_145850_b.field_72995_K && !((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue() && this.storage.isValid()) {
            this.storage.bind(null);
        } else if (this.field_145850_b.field_72995_K && this.ticks++ % 5 == 0) {
            boolean enabled;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = enabled = state.func_177227_a().contains(IEnabledBlock.ENABLED) && (Boolean)state.func_177229_b((IProperty)IEnabledBlock.ENABLED) != false;
            if (enabled != this.lastState) {
                this.lastState = enabled;
                this.actionTime.setValue(Animation.getWorldTime((World)this.field_145850_b, (float)Animation.getPartialTickTime()));
                AnimationHelper.transitionSafely(this.asm, this.lastState ? "starting" : "stopping");
            }
        }
        if (!this.field_145850_b.field_72995_K && this.ticks % 20 == 0) {
            NodeHelper.validateOutputs(this.field_145850_b, this.provider);
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.provider.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.provider.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.provider.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.provider);
    }

    @Override
    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.provider);
        }
        this.provider.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.provider);
    }

    public void onChunkUnload() {
        this.provider.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.provider);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.provider.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.provider.init(this.field_145850_b);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.provider.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.provider.deserializeNBT(nbt.func_74775_l("node"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE || capability == CapabilityImpetusStorage.IMPETUS_STORAGE || capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.provider);
        }
        if (capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return (T)CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.storage);
        }
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, facing);
    }
}

